/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class jTPCC
implements jTPCCConfig {
    private static Logger log = Logger.getLogger(jTPCC.class);
    private static String resultDirName = null;
    private static BufferedWriter resultCSV = null;
    private static BufferedWriter runInfoCSV = null;
    private static int runID = 0;
    private int dbType = 0;
    private int currentlyDisplayedTerminal;
    private jTPCCTerminal[] terminals;
    private String[] terminalNames;
    private boolean terminalsBlockingExit = false;
    private long terminalsStarted = 0L;
    private long sessionCount = 0L;
    private long transactionCount = 0L;
    private Object counterLock = new Object();
    private long newOrderCounter = 0L;
    private long sessionStartTimestamp;
    private long sessionEndTimestamp;
    private long sessionNextTimestamp = 0L;
    private long sessionNextKounter = 0L;
    private long sessionEndTargetTime = -1L;
    private long fastNewOrderCounter;
    private long recentTpmC = 0L;
    private long recentTpmTotal = 0L;
    private boolean signalTerminalsRequestEndSent = false;
    private boolean databaseDriverLoaded = false;
    private FileOutputStream fileOutputStream;
    private PrintStream printStreamReport;
    private String sessionStart;
    private String sessionEnd;
    private int limPerMin_Terminal;
    private double tpmC;
    private jTPCCRandom rnd;
    private OSCollector osCollector = null;

    public static void main(String[] args) {
        PropertyConfigurator.configure((String)"log4j.properties");
        new jTPCC();
    }

    private String getProp(Properties p, String pName) {
        String prop = p.getProperty(pName);
        log.info((Object)("Term-00, " + pName + "=" + prop));
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public jTPCC() {
        Properties ini = new Properties();
        try {
            ini.load(new FileInputStream(System.getProperty("prop")));
        }
        catch (IOException e) {
            this.errorMessage("Term-00, could not load properties file");
        }
        log.info((Object)"Term-00, ");
        log.info((Object)"Term-00, +-------------------------------------------------------------+");
        log.info((Object)"Term-00,      BenchmarkSQL v5.0");
        log.info((Object)"Term-00, +-------------------------------------------------------------+");
        log.info((Object)"Term-00,  (c) 2003, Raul Barbosa");
        log.info((Object)"Term-00,  (c) 2004-2016, Denis Lussier");
        log.info((Object)"Term-00,  (c) 2016, Jan Wieck");
        log.info((Object)"Term-00, +-------------------------------------------------------------+");
        log.info((Object)"Term-00, ");
        String iDB = this.getProp(ini, "db");
        String iDriver = this.getProp(ini, "driver");
        String iConn = this.getProp(ini, "conn");
        String iUser = this.getProp(ini, "user");
        String iPassword = ini.getProperty("password");
        log.info((Object)"Term-00, ");
        String iWarehouses = this.getProp(ini, "warehouses");
        String iTerminals = this.getProp(ini, "terminals");
        String iRunTxnsPerTerminal = ini.getProperty("runTxnsPerTerminal");
        String iRunMins = ini.getProperty("runMins");
        if (Integer.parseInt(iRunTxnsPerTerminal) == 0 && Integer.parseInt(iRunMins) != 0) {
            log.info((Object)("Term-00, runMins=" + iRunMins));
        } else if (Integer.parseInt(iRunTxnsPerTerminal) != 0 && Integer.parseInt(iRunMins) == 0) {
            log.info((Object)("Term-00, runTxnsPerTerminal=" + iRunTxnsPerTerminal));
        } else {
            this.errorMessage("Term-00, Must indicate either transactions per terminal or number of run minutes!");
        }
        String limPerMin = this.getProp(ini, "limitTxnsPerMin");
        String iTermWhseFixed = this.getProp(ini, "terminalWarehouseFixed");
        log.info((Object)"Term-00, ");
        String iNewOrderWeight = this.getProp(ini, "newOrderWeight");
        String iPaymentWeight = this.getProp(ini, "paymentWeight");
        String iOrderStatusWeight = this.getProp(ini, "orderStatusWeight");
        String iDeliveryWeight = this.getProp(ini, "deliveryWeight");
        String iStockLevelWeight = this.getProp(ini, "stockLevelWeight");
        log.info((Object)"Term-00, ");
        String resultDirectory = this.getProp(ini, "resultDirectory");
        String osCollectorScript = this.getProp(ini, "osCollectorScript");
        log.info((Object)"Term-00, ");
        if (iDB.equals("firebird")) {
            this.dbType = 1;
        } else if (iDB.equals("oracle")) {
            this.dbType = 2;
        } else if (iDB.equals("postgres")) {
            this.dbType = 3;
        } else if (iDB.equals("gbase")) {
            this.dbType = 4;
        } else {
            log.error((Object)("unknown database type '" + iDB + "'"));
            return;
        }
        this.limPerMin_Terminal = Integer.parseInt(limPerMin) != 0 ? Integer.parseInt(limPerMin) / Integer.parseInt(iTerminals) : -1;
        boolean iRunMinsBool = false;
        try {
            String driver = iDriver;
            this.printMessage("Loading database driver: '" + driver + "'...");
            Class.forName(iDriver);
            this.databaseDriverLoaded = true;
        }
        catch (Exception ex) {
            this.errorMessage("Unable to load the database driver!");
            this.databaseDriverLoaded = false;
        }
        if (this.databaseDriverLoaded && resultDirectory != null) {
            StringBuffer sb = new StringBuffer();
            Formatter fmt = new Formatter(sb);
            Pattern p = Pattern.compile("%t");
            Calendar cal = Calendar.getInstance();
            String iRunID = System.getProperty("runID");
            if (iRunID != null) {
                runID = Integer.parseInt(iRunID);
            }
            String[] parts = p.split(resultDirectory, -1);
            sb.append(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                fmt.format("%t" + parts[i].substring(0, 1), cal);
                sb.append(parts[i].substring(1));
            }
            resultDirName = sb.toString();
            File resultDir = new File(resultDirName);
            File resultDataDir = new File(resultDir, "data");
            if (!resultDir.mkdir()) {
                log.error((Object)("Failed to create directory '" + resultDir.getPath() + "'"));
                System.exit(1);
            }
            if (!resultDataDir.mkdir()) {
                log.error((Object)("Failed to create directory '" + resultDataDir.getPath() + "'"));
                System.exit(1);
            }
            try {
                Files.copy(new File(System.getProperty("prop")).toPath(), new File(resultDir, "run.properties").toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
                System.exit(1);
            }
            log.info((Object)("Term-00, copied " + System.getProperty("prop") + " to " + new File(resultDir, "run.properties").toPath()));
            String runInfoCSVName = new File(resultDataDir, "runInfo.csv").getPath();
            try {
                runInfoCSV = new BufferedWriter(new FileWriter(runInfoCSVName));
                runInfoCSV.write("run,driver,driverVersion,db,sessionStart,runMins,loadWarehouses,runWarehouses,numSUTThreads,limitTxnsPerMin,thinkTimeMultiplier,keyingTimeMultiplier\n");
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
                System.exit(1);
            }
            log.info((Object)("Term-00, created " + runInfoCSVName + " for runID " + runID));
            String resultCSVName = new File(resultDataDir, "result.csv").getPath();
            try {
                resultCSV = new BufferedWriter(new FileWriter(resultCSVName));
                resultCSV.write("run,elapsed,latency,dblatency,ttype,rbk,dskipped,error\n");
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
                System.exit(1);
            }
            log.info((Object)("Term-00, writing per transaction results to " + resultCSVName));
            if (osCollectorScript != null) {
                this.osCollector = new OSCollector(this.getProp(ini, "osCollectorScript"), runID, Integer.parseInt(this.getProp(ini, "osCollectorInterval")), this.getProp(ini, "osCollectorSSHAddr"), this.getProp(ini, "osCollectorDevices"), resultDataDir, log);
            }
            log.info((Object)"Term-00,");
        }
        if (this.databaseDriverLoaded) {
            try {
                Properties dbProps;
                boolean terminalWarehouseFixed;
                long executionTimeMillis;
                int stockLevelWeightValue;
                int deliveryWeightValue;
                int orderStatusWeightValue;
                int paymentWeightValue;
                int newOrderWeightValue;
                int loadWarehouses;
                int numWarehouses;
                int transactionsPerTerminal;
                int numTerminals;
                boolean limitIsTime;
                block78: {
                    block77: {
                        long CLoad;
                        limitIsTime = iRunMinsBool;
                        numTerminals = -1;
                        transactionsPerTerminal = -1;
                        numWarehouses = -1;
                        loadWarehouses = -1;
                        newOrderWeightValue = -1;
                        paymentWeightValue = -1;
                        orderStatusWeightValue = -1;
                        deliveryWeightValue = -1;
                        stockLevelWeightValue = -1;
                        executionTimeMillis = -1L;
                        terminalWarehouseFixed = true;
                        dbProps = new Properties();
                        dbProps.setProperty("user", iUser);
                        dbProps.setProperty("password", iPassword);
                        switch (this.dbType) {
                            case 1: {
                                dbProps.setProperty("TRANSACTION_READ_COMMITTED", "isc_tpb_read_committed,isc_tpb_no_rec_version,isc_tpb_write,isc_tpb_wait");
                                break;
                            }
                        }
                        try {
                            loadWarehouses = Integer.parseInt(jTPCCUtil.getConfig(iConn, dbProps, "warehouses"));
                            CLoad = Long.parseLong(jTPCCUtil.getConfig(iConn, dbProps, "nURandCLast"));
                        }
                        catch (Exception e) {
                            this.errorMessage(e.getMessage());
                            throw e;
                        }
                        this.rnd = new jTPCCRandom(CLoad);
                        log.info((Object)("Term-00, C value for C_LAST during load: " + CLoad));
                        log.info((Object)("Term-00, C value for C_LAST this run:    " + this.rnd.getNURandCLast()));
                        log.info((Object)"Term-00, ");
                        this.fastNewOrderCounter = 0L;
                        this.updateStatusLine();
                        try {
                            if (Integer.parseInt(iRunMins) != 0 && Integer.parseInt(iRunTxnsPerTerminal) == 0) {
                                iRunMinsBool = true;
                                break block77;
                            }
                            if (Integer.parseInt(iRunMins) == 0 && Integer.parseInt(iRunTxnsPerTerminal) != 0) {
                                iRunMinsBool = false;
                                break block77;
                            }
                            throw new NumberFormatException();
                        }
                        catch (NumberFormatException e1) {
                            this.errorMessage("Must indicate either transactions per terminal or number of run minutes!");
                            throw new Exception();
                        }
                    }
                    try {
                        numWarehouses = Integer.parseInt(iWarehouses);
                        if (numWarehouses <= 0) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException e1) {
                        this.errorMessage("Invalid number of warehouses!");
                        throw new Exception();
                    }
                    if (numWarehouses > loadWarehouses) {
                        this.errorMessage("numWarehouses cannot be greater than the warehouses loaded in the database");
                        throw new Exception();
                    }
                    try {
                        numTerminals = Integer.parseInt(iTerminals);
                        if (numTerminals <= 0 || numTerminals > 10 * numWarehouses) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException e1) {
                        this.errorMessage("Invalid number of terminals!");
                        throw new Exception();
                    }
                    if (Long.parseLong(iRunMins) != 0L && Integer.parseInt(iRunTxnsPerTerminal) == 0) {
                        try {
                            executionTimeMillis = Long.parseLong(iRunMins) * 60000L;
                            if (executionTimeMillis <= 0L) {
                                throw new NumberFormatException();
                            }
                            break block78;
                        }
                        catch (NumberFormatException e1) {
                            this.errorMessage("Invalid number of minutes!");
                            throw new Exception();
                        }
                    }
                    try {
                        transactionsPerTerminal = Integer.parseInt(iRunTxnsPerTerminal);
                        if (transactionsPerTerminal <= 0) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException e1) {
                        this.errorMessage("Invalid number of transactions per terminal!");
                        throw new Exception();
                    }
                }
                terminalWarehouseFixed = Boolean.parseBoolean(iTermWhseFixed);
                try {
                    newOrderWeightValue = Integer.parseInt(iNewOrderWeight);
                    paymentWeightValue = Integer.parseInt(iPaymentWeight);
                    orderStatusWeightValue = Integer.parseInt(iOrderStatusWeight);
                    deliveryWeightValue = Integer.parseInt(iDeliveryWeight);
                    stockLevelWeightValue = Integer.parseInt(iStockLevelWeight);
                    if (newOrderWeightValue < 0 || paymentWeightValue < 0 || orderStatusWeightValue < 0 || deliveryWeightValue < 0 || stockLevelWeightValue < 0) {
                        throw new NumberFormatException();
                    }
                    if (newOrderWeightValue == 0 && paymentWeightValue == 0 && orderStatusWeightValue == 0 && deliveryWeightValue == 0 && stockLevelWeightValue == 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e1) {
                    this.errorMessage("Invalid number in mix percentage!");
                    throw new Exception();
                }
                if (newOrderWeightValue + paymentWeightValue + orderStatusWeightValue + deliveryWeightValue + stockLevelWeightValue > 100) {
                    this.errorMessage("Sum of mix percentage parameters exceeds 100%!");
                    throw new Exception();
                }
                this.newOrderCounter = 0L;
                this.printMessage("Session started!");
                if (!limitIsTime) {
                    this.printMessage("Creating " + numTerminals + " terminal(s) with " + transactionsPerTerminal + " transaction(s) per terminal...");
                } else {
                    this.printMessage("Creating " + numTerminals + " terminal(s) with " + executionTimeMillis / 60000L + " minute(s) of execution...");
                }
                if (terminalWarehouseFixed) {
                    this.printMessage("Terminal Warehouse is fixed");
                } else {
                    this.printMessage("Terminal Warehouse is NOT fixed");
                }
                this.printMessage("Transaction Weights: " + newOrderWeightValue + "% New-Order, " + paymentWeightValue + "% Payment, " + orderStatusWeightValue + "% Order-Status, " + deliveryWeightValue + "% Delivery, " + stockLevelWeightValue + "% Stock-Level");
                this.printMessage("Number of Terminals\t" + numTerminals);
                this.terminals = new jTPCCTerminal[numTerminals];
                this.terminalNames = new String[numTerminals];
                this.terminalsStarted = numTerminals;
                try {
                    int i;
                    String database = iConn;
                    String username = iUser;
                    String password = iPassword;
                    int[][] usedTerminals = new int[numWarehouses][10];
                    for (i = 0; i < numWarehouses; ++i) {
                        for (int j = 0; j < 10; ++j) {
                            usedTerminals[i][j] = 0;
                        }
                    }
                    for (i = 0; i < numTerminals; ++i) {
                        jTPCCTerminal terminal;
                        int terminalDistrictID;
                        int terminalWarehouseID;
                        while (usedTerminals[(terminalWarehouseID = this.rnd.nextInt(1, numWarehouses)) - 1][(terminalDistrictID = this.rnd.nextInt(1, 10)) - 1] == 1) {
                        }
                        usedTerminals[terminalWarehouseID - 1][terminalDistrictID - 1] = 1;
                        String terminalName = "Term-" + (i >= 9 ? "" + (i + 1) : "0" + (i + 1));
                        Connection conn = null;
                        this.printMessage("Creating database connection for " + terminalName + "...");
                        conn = DriverManager.getConnection(database, dbProps);
                        conn.setAutoCommit(false);
                        this.terminals[i] = terminal = new jTPCCTerminal(terminalName, terminalWarehouseID, terminalDistrictID, conn, this.dbType, transactionsPerTerminal, terminalWarehouseFixed, paymentWeightValue, orderStatusWeightValue, deliveryWeightValue, stockLevelWeightValue, numWarehouses, this.limPerMin_Terminal, this);
                        this.terminalNames[i] = terminalName;
                        this.printMessage(terminalName + "\t" + terminalWarehouseID);
                    }
                    this.sessionEndTargetTime = executionTimeMillis;
                    this.signalTerminalsRequestEndSent = false;
                    this.printMessage("Transaction\tWeight");
                    this.printMessage("% New-Order\t" + newOrderWeightValue);
                    this.printMessage("% Payment\t" + paymentWeightValue);
                    this.printMessage("% Order-Status\t" + orderStatusWeightValue);
                    this.printMessage("% Delivery\t" + deliveryWeightValue);
                    this.printMessage("% Stock-Level\t" + stockLevelWeightValue);
                    this.printMessage("Transaction Number\tTerminal\tType\tExecution Time (ms)\t\tComment");
                    this.printMessage("Created " + numTerminals + " terminal(s) successfully!");
                    boolean dummvar = true;
                    this.sessionStart = this.getCurrentTime();
                    this.sessionNextTimestamp = this.sessionStartTimestamp = System.currentTimeMillis();
                    if (this.sessionEndTargetTime != -1L) {
                        this.sessionEndTargetTime += this.sessionStartTimestamp;
                    }
                    if (runInfoCSV != null) {
                        try {
                            StringBuffer infoSB = new StringBuffer();
                            Formatter infoFmt = new Formatter(infoSB);
                            infoFmt.format("%d,simple,%s,%s,%s,%s,%d,%d,%d,%d,1.0,1.0\n", runID, "5.0", iDB, new Timestamp(this.sessionStartTimestamp).toString(), iRunMins, loadWarehouses, numWarehouses, numTerminals, Integer.parseInt(limPerMin));
                            runInfoCSV.write(infoSB.toString());
                            runInfoCSV.close();
                        }
                        catch (Exception e) {
                            log.error((Object)e.getMessage());
                            System.exit(1);
                        }
                    }
                    jTPCCTerminal[] jTPCCTerminalArray = this.terminals;
                    synchronized (this.terminals) {
                        this.printMessage("Starting all terminals...");
                        this.transactionCount = 1L;
                        for (int i2 = 0; i2 < this.terminals.length; ++i2) {
                            new Thread(this.terminals[i2]).start();
                        }
                        // ** MonitorExit[var42_69] (shouldn't be in output)
                        this.printMessage("All terminals started executing " + this.sessionStart);
                    }
                }
                catch (Exception e1) {
                    this.errorMessage("This session ended with errors!");
                    this.printStreamReport.close();
                    this.fileOutputStream.close();
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        {
            this.updateStatusLine();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalTerminalsRequestEnd(boolean timeTriggered) {
        jTPCCTerminal[] jTPCCTerminalArray = this.terminals;
        synchronized (this.terminals) {
            if (!this.signalTerminalsRequestEndSent) {
                if (timeTriggered) {
                    this.printMessage("The time limit has been reached.");
                }
                this.printMessage("Signalling all terminals to stop...");
                this.signalTerminalsRequestEndSent = true;
                for (int i = 0; i < this.terminals.length; ++i) {
                    if (this.terminals[i] == null) continue;
                    this.terminals[i].stopRunningWhenPossible();
                }
                this.printMessage("Waiting for all active transactions to end...");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalTerminalEnded(jTPCCTerminal terminal, long countNewOrdersExecuted) {
        jTPCCTerminal[] jTPCCTerminalArray = this.terminals;
        synchronized (this.terminals) {
            boolean found = false;
            --this.terminalsStarted;
            for (int i = 0; i < this.terminals.length && !found; ++i) {
                if (this.terminals[i] != terminal) continue;
                this.terminals[i] = null;
                this.terminalNames[i] = "(" + this.terminalNames[i] + ")";
                this.newOrderCounter += countNewOrdersExecuted;
                found = true;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (this.terminalsStarted == 0L) {
                this.sessionEnd = this.getCurrentTime();
                this.sessionEndTimestamp = System.currentTimeMillis();
                this.sessionEndTargetTime = -1L;
                this.printMessage("All terminals finished executing " + this.sessionEnd);
                this.endReport();
                this.terminalsBlockingExit = false;
                this.printMessage("Session finished!");
                if (resultCSV != null) {
                    try {
                        resultCSV.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage());
                    }
                }
                if (this.osCollector != null) {
                    this.osCollector.stop();
                    this.osCollector = null;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalTerminalEndedTransaction(String terminalName, String transactionType, long executionTime, String comment, int newOrder) {
        Object object = this.counterLock;
        synchronized (object) {
            ++this.transactionCount;
            this.fastNewOrderCounter += (long)newOrder;
        }
        if (this.sessionEndTargetTime != -1L && System.currentTimeMillis() > this.sessionEndTargetTime) {
            this.signalTerminalsRequestEnd(true);
        }
        this.updateStatusLine();
    }

    public jTPCCRandom getRnd() {
        return this.rnd;
    }

    public void resultAppend(jTPCCTData term) {
        if (resultCSV != null) {
            try {
                resultCSV.write(runID + "," + term.resultLine(this.sessionStartTimestamp));
            }
            catch (IOException e) {
                log.error((Object)("Term-00, " + e.getMessage()));
            }
        }
    }

    private void endReport() {
        long currTimeMillis = System.currentTimeMillis();
        long freeMem = Runtime.getRuntime().freeMemory() / 0x100000L;
        long totalMem = Runtime.getRuntime().totalMemory() / 0x100000L;
        double tpmC = (double)(6000000L * this.fastNewOrderCounter / (currTimeMillis - this.sessionStartTimestamp)) / 100.0;
        double tpmTotal = (double)(6000000L * this.transactionCount / (currTimeMillis - this.sessionStartTimestamp)) / 100.0;
        System.out.println("");
        log.info((Object)"Term-00, ");
        log.info((Object)"Term-00, ");
        log.info((Object)("Term-00, Measured tpmC (NewOrders) = " + tpmC));
        log.info((Object)("Term-00, Measured tpmTOTAL = " + tpmTotal));
        log.info((Object)("Term-00, Session Start     = " + this.sessionStart));
        log.info((Object)("Term-00, Session End       = " + this.sessionEnd));
        log.info((Object)("Term-00, Transaction Count = " + (this.transactionCount - 1L)));
    }

    private void printMessage(String message) {
        log.trace((Object)("Term-00, " + message));
    }

    private void errorMessage(String message) {
        log.error((Object)("Term-00, " + message));
    }

    private void exit() {
        System.exit(0);
    }

    private String getCurrentTime() {
        return dateFormat.format(new Date());
    }

    private String getFileNameSuffix() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return dateFormat.format(new Date());
    }

    private synchronized void updateStatusLine() {
        long currTimeMillis = System.currentTimeMillis();
        if (currTimeMillis > this.sessionNextTimestamp) {
            StringBuilder informativeText = new StringBuilder("");
            Formatter fmt = new Formatter(informativeText);
            double tpmC = (double)(6000000L * this.fastNewOrderCounter / (currTimeMillis - this.sessionStartTimestamp)) / 100.0;
            double tpmTotal = (double)(6000000L * this.transactionCount / (currTimeMillis - this.sessionStartTimestamp)) / 100.0;
            this.sessionNextTimestamp += 1000L;
            fmt.format("Term-00, Running Average tpmTOTAL: %.2f", tpmTotal);
            this.recentTpmC = (this.fastNewOrderCounter - this.sessionNextKounter) * 12L;
            this.recentTpmTotal = (this.transactionCount - this.sessionNextKounter) * 12L;
            this.sessionNextKounter = this.fastNewOrderCounter;
            fmt.format("    Current tpmTOTAL: %d", this.recentTpmTotal);
            long freeMem = Runtime.getRuntime().freeMemory() / 0x100000L;
            long totalMem = Runtime.getRuntime().totalMemory() / 0x100000L;
            fmt.format("    Memory Usage: %dMB / %dMB          ", totalMem - freeMem, totalMem);
            System.out.print(informativeText);
            for (int count = 0; count < 1 + informativeText.length(); ++count) {
                System.out.print("\b");
            }
        }
    }
}

