/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class jTPCCTerminal
implements jTPCCConfig,
Runnable {
    private static Logger log = Logger.getLogger(jTPCCTerminal.class);
    private String terminalName;
    private Connection conn = null;
    private Statement stmt = null;
    private Statement stmt1 = null;
    private ResultSet rs = null;
    private int terminalWarehouseID;
    private int terminalDistrictID;
    private boolean terminalWarehouseFixed;
    private int paymentWeight;
    private int orderStatusWeight;
    private int deliveryWeight;
    private int stockLevelWeight;
    private int limPerMin_Terminal;
    private jTPCC parent;
    private jTPCCRandom rnd;
    private int transactionCount = 1;
    private int numTransactions;
    private int numWarehouses;
    private int newOrderCounter;
    private long totalTnxs = 1L;
    private StringBuffer query = null;
    private int result = 0;
    private boolean stopRunningSignal = false;
    long terminalStartTime = 0L;
    long transactionEnd = 0L;
    jTPCCConnection db = null;
    int dbType = 0;

    public jTPCCTerminal(String terminalName, int terminalWarehouseID, int terminalDistrictID, Connection conn, int dbType, int numTransactions, boolean terminalWarehouseFixed, int paymentWeight, int orderStatusWeight, int deliveryWeight, int stockLevelWeight, int numWarehouses, int limPerMin_Terminal, jTPCC parent) throws SQLException {
        this.terminalName = terminalName;
        this.conn = conn;
        this.dbType = dbType;
        this.stmt = conn.createStatement();
        this.stmt.setMaxRows(200);
        this.stmt.setFetchSize(100);
        this.stmt1 = conn.createStatement();
        this.stmt1.setMaxRows(1);
        this.terminalWarehouseID = terminalWarehouseID;
        this.terminalDistrictID = terminalDistrictID;
        this.terminalWarehouseFixed = terminalWarehouseFixed;
        this.parent = parent;
        this.rnd = parent.getRnd().newRandom();
        this.numTransactions = numTransactions;
        this.paymentWeight = paymentWeight;
        this.orderStatusWeight = orderStatusWeight;
        this.deliveryWeight = deliveryWeight;
        this.stockLevelWeight = stockLevelWeight;
        this.numWarehouses = numWarehouses;
        this.newOrderCounter = 0;
        this.limPerMin_Terminal = limPerMin_Terminal;
        this.db = new jTPCCConnection(conn, dbType);
        this.terminalMessage("");
        this.terminalMessage("Terminal '" + terminalName + "' has WarehouseID=" + terminalWarehouseID + " and DistrictID=" + terminalDistrictID + ".");
        this.terminalStartTime = System.currentTimeMillis();
    }

    @Override
    public void run() {
        this.executeTransactions(this.numTransactions);
        try {
            this.printMessage("");
            this.printMessage("Closing statement and connection...");
            this.stmt.close();
            this.conn.close();
        }
        catch (Exception e) {
            this.printMessage("");
            this.printMessage("An error occurred!");
            this.logException(e);
        }
        this.printMessage("");
        this.printMessage("Terminal '" + this.terminalName + "' finished after " + (this.transactionCount - 1) + " transaction(s).");
        this.parent.signalTerminalEnded(this, this.newOrderCounter);
    }

    public void stopRunningWhenPossible() {
        this.stopRunningSignal = true;
        this.printMessage("");
        this.printMessage("Terminal received stop signal!");
        this.printMessage("Finishing current transaction before exit...");
    }

    private void executeTransactions(int numTransactions) {
        boolean stopRunning = false;
        if (numTransactions != -1) {
            this.printMessage("Executing " + numTransactions + " transactions...");
        } else {
            this.printMessage("Executing for a limited time...");
        }
        for (int i = 0; !(i >= numTransactions && numTransactions != -1 || stopRunning); ++i) {
            long timePerTx;
            long elapse;
            String transactionTypeName;
            jTPCCTData term;
            long transactionType = this.rnd.nextLong(1L, 100L);
            int skippedDeliveries = 0;
            int newOrder = 0;
            long transactionStart = System.currentTimeMillis();
            if (!this.terminalWarehouseFixed) {
                this.terminalWarehouseID = this.rnd.nextInt(1, this.numWarehouses);
            }
            if (transactionType <= (long)this.paymentWeight) {
                term = new jTPCCTData();
                term.setNumWarehouses(this.numWarehouses);
                term.setWarehouse(this.terminalWarehouseID);
                term.setDistrict(this.terminalDistrictID);
                try {
                    term.generatePayment(log, this.rnd, 0L);
                    term.traceScreen(log);
                    term.execute(log, this.db);
                    this.parent.resultAppend(term);
                    term.traceScreen(log);
                }
                catch (Exception e) {
                    log.fatal((Object)e.getMessage());
                    e.printStackTrace();
                    System.exit(4);
                }
                transactionTypeName = "Payment";
            } else if (transactionType <= (long)(this.paymentWeight + this.stockLevelWeight)) {
                term = new jTPCCTData();
                term.setNumWarehouses(this.numWarehouses);
                term.setWarehouse(this.terminalWarehouseID);
                term.setDistrict(this.terminalDistrictID);
                try {
                    term.generateStockLevel(log, this.rnd, 0L);
                    term.traceScreen(log);
                    term.execute(log, this.db);
                    this.parent.resultAppend(term);
                    term.traceScreen(log);
                }
                catch (Exception e) {
                    log.fatal((Object)e.getMessage());
                    e.printStackTrace();
                    System.exit(4);
                }
                transactionTypeName = "Stock-Level";
            } else if (transactionType <= (long)(this.paymentWeight + this.stockLevelWeight + this.orderStatusWeight)) {
                term = new jTPCCTData();
                term.setNumWarehouses(this.numWarehouses);
                term.setWarehouse(this.terminalWarehouseID);
                term.setDistrict(this.terminalDistrictID);
                try {
                    term.generateOrderStatus(log, this.rnd, 0L);
                    term.traceScreen(log);
                    term.execute(log, this.db);
                    this.parent.resultAppend(term);
                    term.traceScreen(log);
                }
                catch (Exception e) {
                    log.fatal((Object)e.getMessage());
                    e.printStackTrace();
                    System.exit(4);
                }
                transactionTypeName = "Order-Status";
            } else if (transactionType <= (long)(this.paymentWeight + this.stockLevelWeight + this.orderStatusWeight + this.deliveryWeight)) {
                term = new jTPCCTData();
                term.setNumWarehouses(this.numWarehouses);
                term.setWarehouse(this.terminalWarehouseID);
                term.setDistrict(this.terminalDistrictID);
                try {
                    term.generateDelivery(log, this.rnd, 0L);
                    term.traceScreen(log);
                    term.execute(log, this.db);
                    this.parent.resultAppend(term);
                    term.traceScreen(log);
                    jTPCCTData bg = term.getDeliveryBG();
                    bg.traceScreen(log);
                    bg.execute(log, this.db);
                    this.parent.resultAppend(bg);
                    bg.traceScreen(log);
                    skippedDeliveries = bg.getSkippedDeliveries();
                }
                catch (Exception e) {
                    log.fatal((Object)e.getMessage());
                    e.printStackTrace();
                    System.exit(4);
                }
                transactionTypeName = "Delivery";
            } else {
                term = new jTPCCTData();
                term.setNumWarehouses(this.numWarehouses);
                term.setWarehouse(this.terminalWarehouseID);
                term.setDistrict(this.terminalDistrictID);
                try {
                    term.generateNewOrder(log, this.rnd, 0L);
                    term.traceScreen(log);
                    term.execute(log, this.db);
                    this.parent.resultAppend(term);
                    term.traceScreen(log);
                }
                catch (Exception e) {
                    log.fatal((Object)e.getMessage());
                    e.printStackTrace();
                    System.exit(4);
                }
                transactionTypeName = "New-Order";
                ++this.newOrderCounter;
                newOrder = 1;
            }
            long transactionEnd = System.currentTimeMillis();
            if (!transactionTypeName.equals("Delivery")) {
                this.parent.signalTerminalEndedTransaction(this.terminalName, transactionTypeName, transactionEnd - transactionStart, null, newOrder);
            } else {
                this.parent.signalTerminalEndedTransaction(this.terminalName, transactionTypeName, transactionEnd - transactionStart, skippedDeliveries == 0 ? "None" : "" + skippedDeliveries + " delivery(ies) skipped.", newOrder);
            }
            if (this.limPerMin_Terminal > 0 && (elapse = transactionEnd - transactionStart) < (timePerTx = (long)(60000 / this.limPerMin_Terminal))) {
                try {
                    long sleepTime = timePerTx - elapse;
                    Thread.sleep(sleepTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.stopRunningSignal) continue;
            stopRunning = true;
        }
    }

    private void error(String type) {
        log.error((Object)(this.terminalName + ", TERMINAL=" + this.terminalName + "  TYPE=" + type + "  COUNT=" + this.transactionCount));
        System.out.println(this.terminalName + ", TERMINAL=" + this.terminalName + "  TYPE=" + type + "  COUNT=" + this.transactionCount);
    }

    private void logException(Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        printWriter.close();
        log.error((Object)stringWriter.toString());
    }

    private void terminalMessage(String message) {
        log.trace((Object)(this.terminalName + ", " + message));
    }

    private void printMessage(String message) {
        log.trace((Object)(this.terminalName + ", " + message));
    }

    void transRollback() {
        try {
            this.conn.rollback();
        }
        catch (SQLException se) {
            log.error((Object)se.getMessage());
        }
    }

    void transCommit() {
        try {
            this.conn.commit();
        }
        catch (SQLException se) {
            log.error((Object)se.getMessage());
            this.transRollback();
        }
    }
}

