/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data.handlers;

import java.sql.SQLException;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCObjectValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class JDBCUUIDValueHandler
extends JDBCObjectValueHandler {
    public static final JDBCUUIDValueHandler INSTANCE = new JDBCUUIDValueHandler();

    @NotNull
    public Class<UUID> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return UUID.class;
    }

    @Override
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof UUID) {
            return object;
        }
        if (object instanceof byte[]) {
            return GeneralUtils.getUUIDFromBytes((byte[])((byte[])object));
        }
        String str = object.toString();
        if (str.isEmpty()) {
            return null;
        }
        return UUID.fromString(str);
    }

    @Override
    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (value instanceof String && paramType.getDataKind() != DBPDataKind.STRING) {
            value = UUID.fromString((String)value);
        }
        if (value instanceof UUID) {
            switch (paramType.getDataKind()) {
                case BINARY: {
                    value = GeneralUtils.getBytesFromUUID((UUID)((UUID)value));
                    break;
                }
                case STRING: {
                    value = value.toString();
                }
            }
        }
        super.bindParameter(session, statement, paramType, paramIndex, value);
    }
}

