/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilterObjectType;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class NavigatorStatePersister {
    private static final Log log = Log.getLog(NavigatorStatePersister.class);
    private static final String KEY_PREFIX = "element";
    private static final String PROP_FILTER_TYPE = "filterType";
    private static final String PROP_FILTER_TEXT = "filterText";

    private NavigatorStatePersister() {
    }

    public static void saveExpandedState(Object[] expandedElements, IMemento memento) {
        int i = 0;
        while (i < expandedElements.length) {
            memento.putString(KEY_PREFIX + i, NavigatorStatePersister.createNodeIdentifier((DBNNode)expandedElements[i]));
            ++i;
        }
    }

    public static void restoreExpandedState(TreeViewer navigatorViewer, DBNNode rootNode, int maxDepth, IMemento memento) {
        if (memento == null) {
            return;
        }
        String[] nodeIdentifiers = (String[])Arrays.stream(memento.getAttributeKeys()).filter(x -> x.startsWith(KEY_PREFIX)).map(arg_0 -> ((IMemento)memento).getString(arg_0)).toArray(String[]::new);
        if (nodeIdentifiers.length == 0) {
            return;
        }
        final DBRRunnableWithProgress runnable = monitor -> {
            try {
                monitor.beginTask("Expand navigator nodes", nodeIdentifiers.length);
                String[] stringArray2 = nodeIdentifiers;
                int n2 = nodeIdentifiers.length;
                int n3 = 0;
                while (n3 < n2) {
                    String nodeIdentifier = stringArray2[n3];
                    if (monitor.isCanceled()) break;
                    monitor.subTask("Expand node " + nodeIdentifier);
                    DBNNode node = NavigatorStatePersister.findNode(nodeIdentifier, rootNode, 1, maxDepth, monitor);
                    if (node != null && !node.isDisposed()) {
                        UIUtils.syncExec(() -> navigatorViewer.setExpandedState((Object)node, true));
                    }
                    ++n3;
                }
                monitor.done();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        };
        AbstractJob expandJob = new AbstractJob("Expand navigator nodes"){
            {
                super($anonymous0);
                this.setSystem(false);
                this.setUser(true);
            }

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    runnable.run(monitor);
                }
                catch (InvocationTargetException e) {
                    log.error((Object)e);
                }
                catch (InterruptedException interruptedException) {}
                return Status.OK_STATUS;
            }
        };
        UIUtils.asyncExec(() -> ((AbstractJob)expandJob).schedule());
    }

    public static void saveFilterState(@NotNull DatabaseNavigatorTree tree, @NotNull IMemento memento) {
        memento.putString(PROP_FILTER_TYPE, tree.getFilterObjectType().name());
        Text filterControl = tree.getFilterControl();
        if (filterControl != null && !filterControl.isDisposed() && CommonUtils.isNotEmpty((String)filterControl.getText())) {
            memento.putString(PROP_FILTER_TEXT, filterControl.getText());
        }
    }

    public static void restoreFilterState(@NotNull DatabaseNavigatorTree tree, @NotNull IMemento memento) {
        UIUtils.syncExec(() -> {
            DatabaseNavigatorTreeFilterObjectType type = (DatabaseNavigatorTreeFilterObjectType)CommonUtils.valueOf(DatabaseNavigatorTreeFilterObjectType.class, (String)memento.getString(PROP_FILTER_TYPE), (Enum)DatabaseNavigatorTreeFilterObjectType.connection);
            if (type != null && tree.getFilterObjectType() != type) {
                tree.setFilterObjectType(type);
                tree.getViewer().getControl().setRedraw(false);
                try {
                    tree.getViewer().refresh();
                }
                finally {
                    tree.getViewer().getControl().setRedraw(true);
                }
            }
            String text = memento.getString(PROP_FILTER_TEXT);
            Text filterControl = tree.getFilterControl();
            if (CommonUtils.isNotEmpty((String)text) && filterControl != null && !filterControl.isDisposed()) {
                filterControl.setText(text);
                filterControl.notifyListeners(24, new Event());
            }
        });
    }

    private static DBNNode findNode(String nodeIdentifier, DBNNode rootNode, int currentDepth, int maxDepth, DBRProgressMonitor monitor) throws DBException {
        if (currentDepth <= maxDepth) {
            DBNNode[] childNodes;
            NavigatorStatePersister.initializeNode(rootNode, monitor);
            if (nodeIdentifier.equals(NavigatorStatePersister.createNodeIdentifier(rootNode))) {
                return rootNode;
            }
            if (currentDepth < maxDepth && (childNodes = rootNode.getChildren(monitor)) != null) {
                DBNNode[] dBNNodeArray = childNodes;
                int n = childNodes.length;
                int n2 = 0;
                while (n2 < n) {
                    DBNNode newRootNode = dBNNodeArray[n2];
                    if (nodeIdentifier.contains(NavigatorStatePersister.createNodeIdentifier(newRootNode))) {
                        return NavigatorStatePersister.findNode(nodeIdentifier, newRootNode, currentDepth + 1, maxDepth, monitor);
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    private static void initializeNode(DBNNode node, DBRProgressMonitor monitor) throws DBException {
        if (node instanceof DBNDataSource) {
            DBPDataSourceContainer dsContainer = ((DBNDataSource)node).getDataSourceContainer();
            long connectionTimeout = dsContainer.getPreferenceStore().getInt("connection.validation.timeout");
            long connectionStart = System.currentTimeMillis();
            while (!dsContainer.isConnected()) {
                dsContainer.connect(monitor, true, false);
                if (connectionTimeout > 0L && connectionStart + connectionTimeout <= System.currentTimeMillis()) break;
                RuntimeUtils.pause((int)100);
            }
        }
        node.getChildren(monitor);
    }

    private static String createNodeIdentifier(DBNNode node) {
        StringBuilder identifier = new StringBuilder();
        DBNNode currentNode = node;
        while (currentNode != null) {
            identifier.append(currentNode.getNodeDisplayName()).append("/");
            currentNode = currentNode.getParentNode();
        }
        return identifier.toString();
    }
}

