/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator;

import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOResource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNObjectNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNodeHandler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSStructContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.IDataSourceContainerUpdate;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.dnd.DatabaseObjectTransfer;
import org.jkiss.dbeaver.ui.dnd.TreeNodeTransfer;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContext;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContextBase;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.INavigatorObjectManager;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerRefresh;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorView;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;
import org.jkiss.dbeaver.ui.navigator.dnd.NavigatorDragSourceListener;
import org.jkiss.dbeaver.ui.navigator.dnd.NavigatorDropTargetListener;
import org.jkiss.dbeaver.ui.navigator.project.ProjectNavigatorView;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class NavigatorUtils {
    private static final Log log = Log.getLog(NavigatorUtils.class);

    public static DBNNode getSelectedNode(ISelectionProvider selectionProvider) {
        if (selectionProvider == null) {
            return null;
        }
        return NavigatorUtils.getSelectedNode(selectionProvider.getSelection());
    }

    public static DBNNode getSelectedNode(ISelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
            if (selectedObject instanceof DBNNode) {
                return (DBNNode)selectedObject;
            }
            if (selectedObject != null) {
                return (DBNNode)RuntimeUtils.getObjectAdapter((Object)selectedObject, DBNNode.class);
            }
        }
        return null;
    }

    @NotNull
    public static List<DBNNode> getSelectedNodes(@NotNull ISelection selection) {
        if (selection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DBNNode> nodes = new ArrayList<DBNNode>();
        if (selection instanceof IStructuredSelection) {
            for (Object selectedObject : (IStructuredSelection)selection) {
                if (selectedObject instanceof DBNNode) {
                    nodes.add((DBNNode)selectedObject);
                    continue;
                }
                DBNNode node = (DBNNode)RuntimeUtils.getObjectAdapter(selectedObject, DBNNode.class);
                if (node == null) continue;
                nodes.add(node);
            }
        }
        return Collections.unmodifiableList(nodes);
    }

    public static DBNNode getSelectedNode(UIElement element) {
        ISelectionProvider selectionProvider = UIUtils.getSelectionProvider((IServiceLocator)element.getServiceLocator());
        if (selectionProvider != null) {
            return NavigatorUtils.getSelectedNode(selectionProvider);
        }
        return null;
    }

    public static DBSObject getSelectedObject(ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        return DBUtils.getFromObject((Object)((IStructuredSelection)selection).getFirstElement());
    }

    public static List<DBSObject> getSelectedObjects(ISelection selection) {
        if (selection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DBSObject> result = new ArrayList<DBSObject>();
        if (selection instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                DBSObject selectedObject = DBUtils.getFromObject(iter.next());
                if (selectedObject == null) continue;
                result.add(selectedObject);
            }
        }
        return result;
    }

    public static void addContextMenu(IWorkbenchSite workbenchSite, Viewer viewer) {
        NavigatorUtils.addContextMenu(workbenchSite, viewer, (ISelectionProvider)viewer);
    }

    public static void addContextMenu(@Nullable IWorkbenchSite workbenchSite, @NotNull Viewer viewer, @NotNull ISelectionProvider selectionProvider) {
        MenuManager menuMgr = NavigatorUtils.createContextMenu(workbenchSite, viewer, selectionProvider, null);
        if (workbenchSite instanceof IWorkbenchPartSite) {
            ((IWorkbenchPartSite)workbenchSite).registerContextMenu(menuMgr, (ISelectionProvider)viewer);
        } else if (workbenchSite instanceof IPageSite) {
            ((IPageSite)workbenchSite).registerContextMenu("navigatorMenu", menuMgr, (ISelectionProvider)viewer);
        }
    }

    public static MenuManager createContextMenu(@Nullable IWorkbenchSite workbenchSite, @NotNull Viewer viewer, @NotNull IMenuListener menuListener) {
        return NavigatorUtils.createContextMenu(workbenchSite, viewer, (ISelectionProvider)viewer, menuListener);
    }

    public static MenuManager createContextMenu(@Nullable IWorkbenchSite workbenchSite, final @NotNull Viewer viewer, @NotNull ISelectionProvider selectionProvider, @Nullable IMenuListener menuListener) {
        Control control = viewer.getControl();
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(control);
        menu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                Menu menu = (Menu)e.widget;
                DBNNode node = NavigatorUtils.getSelectedNode(viewer.getSelection());
                NavigatorUtils.removeUnrelatedMenuItems(menu, node);
                if (node != null && !node.isLocked() && node.allowsOpen()) {
                    String commandID = NavigatorUtils.getNodeActionCommand(DBXTreeNodeHandler.Action.open, node, "org.jkiss.dbeaver.core.object.open");
                    try {
                        MenuItem[] menuItemArray = menu.getItems();
                        int n = menuItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String contribId;
                            MenuItem item = menuItemArray[n2];
                            Object itemData = item.getData();
                            if (itemData instanceof IContributionItem && (contribId = ((IContributionItem)itemData).getId()) != null && contribId.equals(commandID)) {
                                menu.setDefaultItem(item);
                            }
                            ++n2;
                        }
                    }
                    catch (Exception ex) {
                        log.debug((Object)ex);
                    }
                }
            }
        });
        menuMgr.addMenuListener(manager -> {
            ViewerColumnController columnController = ViewerColumnController.getFromControl(control);
            if (columnController != null && columnController.isClickOnHeader()) {
                columnController.fillConfigMenu((IContributionManager)manager);
                manager.add((IContributionItem)new Separator());
                return;
            }
            manager.add((IContributionItem)new Separator());
            NavigatorUtils.addStandardMenuItem(workbenchSite, manager, selectionProvider);
            if (menuListener != null) {
                menuListener.menuAboutToShow(manager);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        control.setMenu(menu);
        return menuMgr;
    }

    public static void addStandardMenuItem(@Nullable IWorkbenchSite workbenchSite, @NotNull IMenuManager manager, @NotNull ISelectionProvider selectionProvider) {
        ISelection selection = selectionProvider.getSelection();
        DBNNode selectedNode = NavigatorUtils.getSelectedNode(selectionProvider);
        if (selectedNode != null && !selectedNode.isLocked() && workbenchSite != null) {
            NavigatorUtils.addSetDefaultObjectAction(workbenchSite, manager, selectedNode);
        }
        manager.add((IContributionItem)new GroupMarker("navigator_additions"));
        manager.add((IContributionItem)new GroupMarker("tools"));
        manager.add((IContributionItem)new GroupMarker("tools_end"));
        manager.add((IContributionItem)new GroupMarker("navigator_additions_end"));
        manager.add((IContributionItem)new GroupMarker("additions_end"));
        if (selectedNode != null && !selectedNode.isLocked() && workbenchSite != null) {
            Object firstElement;
            manager.add((IContributionItem)new Separator());
            if (selection instanceof IStructuredSelection && PreferencesUtil.hasPropertiesContributors((Object)(firstElement = ((IStructuredSelection)selection).getFirstElement())) && firstElement instanceof DBNResource) {
                manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.eclipse.ui.file.properties"));
            }
            if (selectedNode.isPersisted()) {
                manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.eclipse.ui.file.refresh"));
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private static void addSetDefaultObjectAction(IWorkbenchSite workbenchSite, IMenuManager manager, DBNNode selectedNode) {
        boolean addSetActive = false;
        if (selectedNode.isPersisted() && selectedNode instanceof DBNDatabaseNode && !(selectedNode instanceof DBNDatabaseFolder) && ((DBNDatabaseNode)selectedNode).getObject() != null) {
            DBCExecutionContext defaultContext;
            DBCExecutionContextDefaults contextDefaults;
            DBSObject selectedObject = ((DBNDatabaseNode)selectedNode).getObject();
            DBPDataSource dataSource = ((DBNDatabaseNode)selectedNode).getDataSource();
            if (dataSource != null && (contextDefaults = (defaultContext = DBUtils.getDefaultContext((DBSObject)dataSource, (boolean)false)).getContextDefaults()) != null && (selectedObject instanceof DBSCatalog && contextDefaults.supportsCatalogChange() && contextDefaults.getDefaultCatalog() != selectedObject || selectedObject instanceof DBSSchema && contextDefaults.supportsSchemaChange() && contextDefaults.getDefaultSchema() != selectedObject)) {
                addSetActive = true;
            }
        }
        if (addSetActive) {
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.jkiss.dbeaver.core.navigator.set.default"));
        }
        manager.add((IContributionItem)new Separator());
    }

    public static void executeNodeAction(DBXTreeNodeHandler.Action action, Object node, IServiceLocator serviceLocator) {
        NavigatorUtils.executeNodeAction(action, node, null, serviceLocator);
    }

    public static void executeNodeAction(DBXTreeNodeHandler.Action action, Object node, Map<String, Object> parameters, IServiceLocator serviceLocator) {
        String actionCommand;
        String defCommandId = null;
        if (action == DBXTreeNodeHandler.Action.open) {
            defCommandId = "org.jkiss.dbeaver.core.object.open";
        }
        if ((actionCommand = NavigatorUtils.getNodeActionCommand(action, node, defCommandId)) != null) {
            ActionUtils.runCommand((String)actionCommand, (ISelection)new StructuredSelection(node), parameters, (IServiceLocator)serviceLocator);
        }
    }

    public static String getNodeActionCommand(DBXTreeNodeHandler.Action action, Object node, String defCommand) {
        DBXTreeNodeHandler handler;
        if (node instanceof DBNDatabaseNode && (handler = ((DBNDatabaseNode)node).getMeta().getHandler(action)) != null && handler.getPerform() == DBXTreeNodeHandler.Perform.command && !CommonUtils.isEmpty((String)handler.getCommand())) {
            return handler.getCommand();
        }
        return defCommand;
    }

    public static void addDragAndDropSupport(Viewer viewer) {
        NavigatorUtils.addDragAndDropSupport(viewer, true, true);
    }

    public static void addDragAndDropSupport(Viewer viewer, boolean enableDrag, boolean enableDrop) {
        if (enableDrag) {
            Object[] dragTransferTypes = new Transfer[]{TextTransfer.getInstance(), TreeNodeTransfer.getInstance(), DatabaseObjectTransfer.getInstance(), EditorInputTransfer.getInstance(), FileTransfer.getInstance()};
            if (RuntimeUtils.isGtk()) {
                ArrayUtils.reverse((Object[])dragTransferTypes);
            }
            int operations = 7;
            DragSource source = new DragSource(viewer.getControl(), operations);
            source.setTransfer((Transfer[])dragTransferTypes);
            source.addDragListener((DragSourceListener)new NavigatorDragSourceListener(viewer));
        }
        if (enableDrop) {
            DropTarget dropTarget = new DropTarget(viewer.getControl(), 2);
            dropTarget.setTransfer(new Transfer[]{TreeNodeTransfer.getInstance(), FileTransfer.getInstance()});
            dropTarget.addDropListener((DropTargetListener)new NavigatorDropTargetListener(viewer));
        }
    }

    public static NavigatorViewBase getActiveNavigatorView(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof NavigatorViewBase) {
            return (NavigatorViewBase)activePart;
        }
        IWorkbenchPage activePage = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage();
        activePart = activePage.findView("org.jkiss.dbeaver.core.databaseNavigator");
        if (activePart instanceof NavigatorViewBase && activePage.isPartVisible(activePart)) {
            return (NavigatorViewBase)activePart;
        }
        activePart = activePage.findView("org.jkiss.dbeaver.core.projectNavigator");
        if (activePart instanceof NavigatorViewBase && activePage.isPartVisible(activePart)) {
            return (NavigatorViewBase)activePart;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void filterSelection(ISelection selection, boolean exclude) {
        if (!(selection instanceof IStructuredSelection)) {
            log.error((Object)("Invalid selection type: " + String.valueOf(selection)));
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selection;
        try {
            void structuredSelection;
            HashMap<DBNDatabaseNode, DBSObjectFilter> folders = new HashMap<DBNDatabaseNode, DBSObjectFilter>();
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBNDatabaseNode parent;
                DBNNode dBNNode;
                DBNDatabaseNode parentNode;
                DBNDatabaseNode node;
                DBXTreeItem nodeMeta;
                Object item = objectArray[n2];
                if (item instanceof DBNDatabaseNode && (nodeMeta = (DBXTreeItem)UIUtils.runWithMonitor(arg_0 -> NavigatorUtils.lambda$1(node, parentNode = (dBNNode = (node = (DBNDatabaseNode)item).getParentNode()) instanceof DBNDatabaseNode ? (parent = (DBNDatabaseNode)dBNNode) : node, arg_0))) != null) {
                    DBSObjectFilter nodeFilter = (DBSObjectFilter)folders.get(parentNode);
                    if (nodeFilter == null) {
                        nodeFilter = parentNode.getNodeFilter(nodeMeta, true);
                        if (nodeFilter == null) {
                            nodeFilter = new DBSObjectFilter();
                        }
                        folders.put(parentNode, nodeFilter);
                    }
                    if (exclude) {
                        nodeFilter.addExclude(node.getNodeDisplayName());
                    } else {
                        nodeFilter.addInclude(node.getNodeDisplayName());
                    }
                    nodeFilter.setEnabled(true);
                }
                ++n2;
            }
            HashSet<DBPDataSourceContainer> changedContainers = new HashSet<DBPDataSourceContainer>();
            for (Map.Entry entry : folders.entrySet()) {
                DBNDatabaseNode targetNode = (DBNDatabaseNode)entry.getKey();
                DBXTreeItem nodeMeta = (DBXTreeItem)UIUtils.runWithMonitor(monitor -> DBNUtils.getValidItemsMeta((DBRProgressMonitor)monitor, (DBNDatabaseNode)targetNode));
                targetNode.setNodeFilter(nodeMeta, (DBSObjectFilter)entry.getValue(), false);
                changedContainers.add(targetNode.getDataSourceContainer());
            }
            for (DBPDataSourceContainer ds : changedContainers) {
                ds.persistConfiguration();
            }
            NavigatorHandlerRefresh.refreshNavigator(folders.keySet());
        }
        catch (DBException e) {
            log.error((Object)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean syncEditorWithNavigator(INavigatorModelView navigatorView, IEditorPart activeEditor) {
        void dsProvider;
        DBNDatabaseNode databaseNode;
        block13: {
            block12: {
                if (!(activeEditor instanceof IDataSourceContainerUpdate)) {
                    return false;
                }
                IDataSourceContainerUpdate iDataSourceContainerUpdate = (IDataSourceContainerUpdate)activeEditor;
                Viewer navigatorViewer = navigatorView.getNavigatorViewer();
                if (navigatorViewer == null) {
                    return false;
                }
                DBNNode selectedNode = NavigatorUtils.getSelectedNode(navigatorViewer.getSelection());
                DBPProject nodeProject = selectedNode.getOwnerProject();
                if (!(selectedNode instanceof DBNDatabaseNode)) break block12;
                databaseNode = (DBNDatabaseNode)selectedNode;
                if (nodeProject == null || nodeProject.hasRealmPermission("project-resource-edit")) break block13;
            }
            return false;
        }
        DBSObject dbsObject = databaseNode.getObject();
        if (!(dbsObject instanceof DBSStructContainer)) {
            dbsObject = (DBSObject)DBUtils.getParentOfType(DBSStructContainer.class, (DBSObject)dbsObject);
        }
        DBPDataSourceContainer ds = databaseNode.getDataSourceContainer();
        if (dsProvider.getDataSourceContainer() != ds) {
            dsProvider.setDataSourceContainer(ds);
            DatabaseEditorContextBase editorContext = new DatabaseEditorContextBase(ds, dbsObject);
            EditorUtils.setInputDataSource((IEditorInput)activeEditor.getEditorInput(), (DatabaseEditorContext)editorContext);
        }
        if (activeEditor instanceof DBPContextProvider && dbsObject != null) {
            DBCExecutionContextDefaults editorContextDefaults;
            DBCExecutionContext navExecutionContext = null;
            try {
                navExecutionContext = DBUtils.getOrOpenDefaultContext((DBSObject)dbsObject, (boolean)false);
            }
            catch (DBCException dBCException) {}
            DBCExecutionContext editorExecutionContext = ((DBPContextProvider)activeEditor).getExecutionContext();
            if (navExecutionContext != null && editorExecutionContext != null && (editorContextDefaults = editorExecutionContext.getContextDefaults()) != null) {
                DBSObject dbObject = dbsObject;
                RuntimeUtils.runTask(monitor -> {
                    try {
                        monitor.beginTask("Change default object", 1);
                        if (dbObject instanceof DBSCatalog && dbObject != editorContextDefaults.getDefaultCatalog()) {
                            monitor.subTask("Change default catalog");
                            editorContextDefaults.setDefaultCatalog(monitor, (DBSCatalog)dbObject, null);
                        } else if (dbObject instanceof DBSSchema && dbObject != editorContextDefaults.getDefaultSchema()) {
                            monitor.subTask("Change default schema");
                            editorContextDefaults.setDefaultSchema(monitor, (DBSSchema)dbObject);
                        }
                        monitor.worked(1);
                        monitor.done();
                    }
                    catch (DBCException e) {
                        throw new InvocationTargetException(e);
                    }
                }, (String)"Set active object", (long)dbObject.getDataSource().getContainer().getPreferenceStore().getInt("connection.open.timeout"));
            }
        }
        return true;
    }

    public static void openNavigatorNode(Object node, IWorkbenchWindow window) {
        NavigatorUtils.openNavigatorNode(node, window, null);
    }

    public static void openNavigatorNode(Object node, IWorkbenchWindow window, Map<?, ?> parameters) {
        block8: {
            try {
                DBNNode baseNode;
                if (node instanceof DBNResource) {
                    DBNResource resource = (DBNResource)node;
                    DBPResourceHandler resourceHandler = resource.getHandler();
                    resourceHandler.openResource(resource.getResource());
                    break block8;
                }
                if (node instanceof DBNPathBase) {
                    DBNPathBase dbnPath = (DBNPathBase)node;
                    if (!EditorUtils.openExternalFiles((Path[])new Path[]{dbnPath.getPath()}, null)) {
                        IResource resource = (IResource)dbnPath.getAdapter(IResource.class);
                        if (resource instanceof IFile) {
                            IFile file = (IFile)resource;
                            NavigatorUtils.openResourceWithHandler(file);
                        } else {
                            NavigatorUtils.openEntityEditor(node, window, parameters);
                        }
                    }
                    break block8;
                }
                if (node instanceof DBNNode && (baseNode = (DBNNode)node).allowsOpen()) {
                    NavigatorUtils.openEntityEditor(node, window, parameters);
                    break block8;
                }
                throw new DBException("Do not know how to open node '" + String.valueOf(node) + "'");
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError("Error opening object", "Error while opening object '" + String.valueOf(node) + "'", (Throwable)e);
            }
        }
    }

    private static void openResourceWithHandler(IFile file) throws CoreException, DBException {
        DBPResourceHandler handler = DBPPlatformDesktop.getInstance().getWorkspace().getResourceHandler((IResource)file);
        if (handler == null) {
            throw new DBException("Cannot find resource handler for " + String.valueOf(file));
        }
        handler.openResource((IResource)file);
    }

    private static void openEntityEditor(Object node, IWorkbenchWindow window, Map<?, ?> parameters) throws DBException {
        DBNObjectNode objectNode;
        INavigatorObjectManager objectManager;
        if (node instanceof DBNObjectNode && (objectManager = (INavigatorObjectManager)GeneralUtils.adapt((Object)(objectNode = (DBNObjectNode)node).getNodeObject(), INavigatorObjectManager.class)) != null) {
            if ((objectManager.getSupportedFeatures() & 1) != 0) {
                objectManager.openObjectEditor(window, objectNode);
            }
            return;
        }
        Object activePage = parameters == null ? null : parameters.get("activePage");
        NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)node, CommonUtils.toString(activePage, null), window);
    }

    @Nullable
    public static IStructuredSelection getSelectionFromPart(IWorkbenchPart part) {
        if (part == null) {
            return null;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        return (IStructuredSelection)selection;
    }

    public static DBPProject getSelectedProject() {
        ISelectionProvider selectionProvider;
        IWorkbenchPart activePart = UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart();
        ISelection selection = activePart == null ? null : ((selectionProvider = activePart.getSite().getSelectionProvider()) == null ? null : selectionProvider.getSelection());
        return NavigatorUtils.getSelectedProject(selection, activePart);
    }

    public static DBPProject getSelectedProject(ISelection currentSelection, IWorkbenchPart activePart) {
        Object selItem;
        DBPProject activeProject = null;
        if (currentSelection instanceof IStructuredSelection && !currentSelection.isEmpty() && (selItem = ((IStructuredSelection)currentSelection).getFirstElement()) instanceof DBNNode) {
            activeProject = ((DBNNode)selItem).getOwnerProjectOrNull();
        }
        if (activeProject == null && activePart instanceof DBPContextProvider) {
            DBPDataSourceContainer container;
            DBCExecutionContext executionContext = ((DBPContextProvider)activePart).getExecutionContext();
            if (executionContext != null) {
                activeProject = executionContext.getDataSource().getContainer().getRegistry().getProject();
            } else if (activePart instanceof DBPDataSourceContainerProvider && (container = ((DBPDataSourceContainerProvider)activePart).getDataSourceContainer()) != null) {
                activeProject = container.getProject();
            }
        }
        if (activeProject == null) {
            activeProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        }
        return activeProject;
    }

    public static void showNodeInNavigator(DBNDatabaseNode dsNode) {
        NavigatorViewBase nodeView;
        IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
        try {
            if (dsNode.getOwnerProject() == DBWorkbench.getPlatform().getWorkspace().getActiveProject()) {
                nodeView = (NavigatorViewBase)UIUtils.findView((IWorkbenchWindow)workbenchWindow, DatabaseNavigatorView.class);
                if (nodeView == null) {
                    nodeView = (NavigatorViewBase)workbenchWindow.getActivePage().showView("org.jkiss.dbeaver.core.databaseNavigator");
                }
            } else {
                nodeView = (NavigatorViewBase)UIUtils.findView((IWorkbenchWindow)workbenchWindow, ProjectNavigatorView.class);
                if (nodeView == null) {
                    nodeView = (NavigatorViewBase)workbenchWindow.getActivePage().showView("org.jkiss.dbeaver.core.projectNavigator");
                }
            }
        }
        catch (PartInitException e) {
            DBWorkbench.getPlatformUI().showError("Can't open view", "Error opening navigator view", (Throwable)e);
            return;
        }
        if (nodeView != null) {
            if (!workbenchWindow.getActivePage().isPartVisible((IWorkbenchPart)nodeView)) {
                workbenchWindow.getActivePage().bringToTop((IWorkbenchPart)nodeView);
            }
            nodeView.showNode((DBNNode)dsNode);
        }
    }

    private static void removeUnrelatedMenuItems(Menu menu, DBNNode node) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem contribution;
            String id;
            MenuItem item = menuItemArray[n2];
            Object itemData = item.getData();
            if (itemData instanceof IContributionItem && (id = (contribution = (IContributionItem)itemData).getId()) != null) {
                IResource resource;
                if (id.startsWith("org.eclipse.debug") || id.startsWith("addFromHistoryAction")) {
                    item.dispose();
                }
                if (node != null && ((resource = (IResource)node.getAdapter(IResource.class)) instanceof IFolder || resource instanceof EFSNIOResource) && (id.startsWith("compareWithMenu") || id.startsWith("replaceWithMenu") || id.startsWith("team.main"))) {
                    item.dispose();
                }
            }
            ++n2;
        }
    }

    private static /* synthetic */ DBXTreeItem lambda$1(DBNDatabaseNode dBNDatabaseNode, DBNDatabaseNode dBNDatabaseNode2, DBRProgressMonitor monitor) throws DBException {
        DBXTreeItem meta = DBNUtils.getValidItemsMeta((DBRProgressMonitor)monitor, (DBNDatabaseNode)dBNDatabaseNode);
        if (meta == null && dBNDatabaseNode != dBNDatabaseNode2) {
            meta = DBNUtils.getValidItemsMeta((DBRProgressMonitor)monitor, (DBNDatabaseNode)dBNDatabaseNode2);
        }
        return meta;
    }
}

