/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import org.antlr.v4.runtime.Token;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.impl.sql.AbstractSQLDialect;
import org.jkiss.dbeaver.model.lsm.LSMAnalyzerParameters;
import org.jkiss.dbeaver.model.lsm.sql.dialect.SQLStandardAnalyzer;
import org.jkiss.dbeaver.model.lsm.sql.impl.syntax.SQLStandardLexer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLPartitionScanner;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLParserActionKind;
import org.jkiss.dbeaver.model.sql.parser.SQLParserContext;
import org.jkiss.dbeaver.model.sql.parser.SQLParserPartitions;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLControlToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.SQLTokenEntry;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.SQLTokenPredicateEvaluator;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandHandlerDescriptor;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandsRegistry;
import org.jkiss.dbeaver.model.stm.LSMInspections;
import org.jkiss.dbeaver.model.stm.STMSource;
import org.jkiss.dbeaver.model.text.TextUtils;
import org.jkiss.dbeaver.model.text.parser.TPRuleBasedScanner;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SQLScriptParser {
    protected static final Log log = Log.getLog(SQLScriptParser.class);
    private static final String CLI_ARG_DEBUG_DISABLE_SKIP_TOKEN_EVALUATION = "dbeaver.debug.sql.disable-skip-token-evaluation";
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$model$sql$parser$tokens$SQLTokenType;

    private static boolean isPredicateEvaluationEnabled() {
        String property = System.getProperty(CLI_ARG_DEBUG_DISABLE_SKIP_TOKEN_EVALUATION);
        return CommonUtils.isEmpty((String)property);
    }

    public static SQLScriptElement parseQuery(@NotNull SQLParserContext context, int startPos, int endPos, int currentPos, boolean scriptMode, boolean keepDelimiters) {
        return SQLScriptParser.tryExpandElement(SQLScriptParser.parseQueryImpl(context, startPos, endPos, currentPos, scriptMode, keepDelimiters), context);
    }

    /*
     * Unable to fully structure code
     */
    private static SQLScriptElement parseQueryImpl(@NotNull SQLParserContext context, int startPos, int endPos, int currentPos, boolean scriptMode, boolean keepDelimiters) {
        length = endPos - startPos;
        document = context.getDocument();
        if (length <= 0 || length > document.getLength()) {
            return null;
        }
        dialect = context.getDialect();
        predicateEvaluator = new SQLTokenPredicateEvaluator(dialect.getSkipTokenPredicates());
        isPredicateEvaluationEnabled = SQLScriptParser.isPredicateEvaluationEnabled();
        newTokenCaptured = false;
        ruleScanner = context.getScanner();
        useBlankLines = scriptMode == false && context.getSyntaxManager().getStatementDelimiterMode().useBlankLine != false;
        lineFeedIsDelimiter = ArrayUtils.contains((Object[])context.getSyntaxManager().getStatementDelimiters(), (Object)"\n");
        ruleScanner.setRange(document, startPos, endPos - startPos);
        statementStart = startPos;
        hasValuableTokens = false;
        curBlock = null;
        hasBlocks = false;
        lastTokenLineFeeds = 0;
        prevNotEmptyTokenType = SQLTokenType.T_UNKNOWN;
        firstKeyword = null;
        lastKeyword = null;
        while (true) {
            token = ruleScanner.nextToken();
            tokenOffset = ruleScanner.getTokenOffset();
            tokenLength = ruleScanner.getTokenLength();
            v0 = tokenType = token instanceof TPTokenDefault != false ? (SQLTokenType)((TPTokenDefault)token).getData() : SQLTokenType.T_OTHER;
            if (tokenOffset < startPos) {
                return null;
            }
            isControl = false;
            delimiterText = null;
            try {
                block71: {
                    if (isPredicateEvaluationEnabled && tokenLength > 0 && !token.isWhitespace()) {
                        tokenText = document.get(tokenOffset, tokenLength);
                        predicateEvaluator.captureToken(new SQLTokenEntry(tokenText, tokenType, false));
                        newTokenCaptured = true;
                    }
                    v1 = isDelimiter = tokenType == SQLTokenType.T_DELIMITER || lineFeedIsDelimiter != false && token.isWhitespace() != false && document.get(tokenOffset, tokenLength).contains("\n") != false;
                    if (isDelimiter) {
                        delimiterText = document.get(tokenOffset, tokenLength);
                    } else if (useBlankLines && token.isWhitespace() && tokenLength > 1 && lastTokenLineFeeds + SQLScriptParser.countLineFeeds(document, tokenOffset, tokenLength) >= 2) {
                        isDelimiter = true;
                    }
                    lastTokenLineFeeds = 0;
                    if (tokenLength == 1) {
                        aChar = document.getChar(tokenOffset);
                        if (aChar == '(' || aChar == '{' || aChar == '[') {
                            curBlock = new ScriptBlockInfo(curBlock, false);
                        } else if ((aChar == ')' || aChar == '}' || aChar == ']') && curBlock != null) {
                            curBlock = curBlock.parent;
                        }
                    }
                    if (tokenType == SQLTokenType.T_BLOCK_BEGIN && prevNotEmptyTokenType == SQLTokenType.T_BLOCK_END) {
                        tokenType = SQLTokenType.T_UNKNOWN;
                    }
                    if (tokenType == SQLTokenType.T_DELIMITER && prevNotEmptyTokenType == SQLTokenType.T_BLOCK_BEGIN && curBlock != null) {
                        curBlock = curBlock.parent;
                    }
                    if (dialect.isStripCommentsBeforeBlocks() && tokenType == SQLTokenType.T_BLOCK_HEADER && prevNotEmptyTokenType == SQLTokenType.T_COMMENT) {
                        statementStart = tokenOffset;
                    }
                    if (tokenType == SQLTokenType.T_BLOCK_HEADER) {
                        curBlock = new ScriptBlockInfo(curBlock, true);
                        hasBlocks = true;
                    } else if (tokenType == SQLTokenType.T_BLOCK_TOGGLE) {
                        try {
                            togglePattern = document.get(tokenOffset, tokenLength);
                        }
                        catch (BadLocationException e) {
                            SQLScriptParser.log.warn((Object)e);
                            togglePattern = "";
                        }
                        if (curBlock != null && togglePattern.equals(curBlock.togglePattern)) {
                            curBlock = curBlock.parent;
                        } else {
                            curBlock = new ScriptBlockInfo(curBlock, togglePattern);
                            hasBlocks = true;
                        }
                    } else if (tokenType == SQLTokenType.T_BLOCK_BEGIN) {
                        if (curBlock != null && curBlock.isHeader && !ArrayUtils.containsIgnoreCase((String[])dialect.getInnerBlockPrefixes(), lastKeyword)) {
                            curBlock = curBlock.parent;
                        }
                        curBlock = new ScriptBlockInfo(curBlock, false);
                        hasBlocks = true;
                    } else if (tokenType == SQLTokenType.T_BLOCK_END) {
                        if (curBlock != null) {
                            if (curBlock.togglePattern != null) {
                                SQLScriptParser.log.trace((Object)"SQLScriptParser: blocks structure recognition inconsistency - trying to leave toggled block on non-togging token");
                            } else {
                                curBlock = curBlock.parent;
                            }
                        }
                    } else {
                        if (isDelimiter && curBlock != null) continue;
                        if (tokenType == SQLTokenType.T_SET_DELIMITER || tokenType == SQLTokenType.T_CONTROL) {
                            isDelimiter = true;
                            v2 = cursorInsideToken = currentPos >= tokenOffset && currentPos <= tokenOffset + tokenLength;
                            if (!hasValuableTokens || cursorInsideToken) {
                                isControl = true;
                            }
                        } else if (tokenType == SQLTokenType.T_COMMENT) {
                            v3 = lastTokenLineFeeds = tokenLength < 2 ? 0 : SQLScriptParser.countLineFeeds(document, tokenOffset + tokenLength - 2, 2);
                        }
                    }
                    if (tokenLength > 0 && !token.isWhitespace()) {
                        switch (SQLScriptParser.$SWITCH_TABLE$org$jkiss$dbeaver$model$sql$parser$tokens$SQLTokenType()[tokenType.ordinal()]) {
                            case 1: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: {
                                lastKeyword = document.get(tokenOffset, tokenLength);
                                if (firstKeyword != null) break;
                                firstKeyword = lastKeyword;
                            }
                        }
                    }
                    if (isPredicateEvaluationEnabled && !token.isEOF() && newTokenCaptured) {
                        newTokenCaptured = false;
                        actionKind = predicateEvaluator.evaluatePredicates();
                        if (actionKind == SQLParserActionKind.BEGIN_BLOCK) {
                            while (curBlock != null && curBlock.isHeader) {
                                curBlock = curBlock.parent;
                            }
                            curBlock = new ScriptBlockInfo(curBlock, false);
                            hasBlocks = true;
                        }
                        if (curBlock != null && !token.isEOF() || actionKind == SQLParserActionKind.SKIP_SUFFIX_TERM) continue;
                    }
                    v4 = cursorInsideToken = currentPos >= tokenOffset && currentPos < tokenOffset + tokenLength;
                    if (isControl && ((scriptMode || cursorInsideToken) && !hasValuableTokens || token.isEOF() || isDelimiter && tokenOffset + tokenLength >= currentPos)) {
                        controlText = document.get(tokenOffset, tokenLength);
                        commandId = null;
                        if (token instanceof SQLControlToken) {
                            commandId = ((SQLControlToken)token).getCommandId();
                        }
                        if ((command = new SQLControlCommand(context.getDataSource(), context.getSyntaxManager(), controlText.trim(), commandId, tokenOffset, tokenLength, tokenType == SQLTokenType.T_SET_DELIMITER)).isEmptyCommand() || command.getCommandId() != null && SQLCommandsRegistry.getInstance().getCommandHandler(command.getCommandId()) != null) {
                            var36_41 = command;
                            return var36_41;
                        }
                        isControl = false;
                    }
                    if (!hasValuableTokens || !token.isEOF() && (!isDelimiter || tokenOffset + tokenLength < currentPos) && tokenOffset <= endPos) break block71;
                    if (tokenOffset > endPos) {
                        tokenOffset = endPos;
                    }
                    if (tokenOffset >= document.getLength()) {
                        tokenOffset = document.getLength();
                    }
                    if (SQLScriptParser.$assertionsDisabled || tokenOffset >= currentPos) ** GOTO lbl128
                    throw new AssertionError();
lbl-1000:
                    // 1 sources

                    {
                        ++statementStart;
lbl128:
                        // 2 sources

                        ** while (statementStart < tokenOffset && Character.isWhitespace((char)document.getChar((int)statementStart)))
                    }
lbl129:
                    // 1 sources

                    if (tokenOffset == statementStart) {
                        if (token.isEOF()) {
                            return null;
                        }
                        statementStart = tokenOffset + tokenLength;
                        continue;
                    }
                    queryText = document.get(statementStart, tokenOffset - statementStart);
                    queryText = SQLUtils.fixLineFeeds((String)queryText);
                    queryEndPos = tokenOffset;
                    if (isDelimiter && (keepDelimiters || hasBlocks && dialect.isDelimiterAfterQuery() || SQLScriptParser.needsDelimiterAfterBlock(firstKeyword, lastKeyword, dialect)) && delimiterText != null && delimiterText.equals(";")) {
                        queryText = (String)queryText + delimiterText;
                    }
                    if (tokenType == SQLTokenType.T_DELIMITER) {
                        queryEndPos += tokenLength;
                    }
                    if (curBlock != null) {
                        SQLScriptParser.log.trace((Object)"Found leftover blocks in script after parsing");
                    }
                    if ((lastMatchedPredicate = predicateEvaluator.getLastMatchedPredicate()) != null && lastMatchedPredicate.getActionKind() == SQLParserActionKind.CAPTURE_COMMAND) {
                        var36_42 = new SQLControlCommand(context.getDataSource(), (String)queryText, lastMatchedPredicate.getParameter(), statementStart, queryEndPos - statementStart, predicateEvaluator.obtainPrefixCaptures());
                        return var36_42;
                    }
                    query = new SQLQuery(context.getDataSource(), (String)queryText, statementStart, queryEndPos - statementStart);
                    query.setEndsWithDelimiter(tokenType == SQLTokenType.T_DELIMITER);
                    var36_43 = query;
                    return var36_43;
                }
                if (isDelimiter) {
                    statementStart = tokenOffset + tokenLength;
                    if (isPredicateEvaluationEnabled) {
                        firstKeyword = null;
                        predicateEvaluator.reset();
                        isControl = false;
                        hasBlocks = false;
                        hasValuableTokens = false;
                    }
                }
                if (token.isEOF()) {
                    return null;
                }
                try {
                    if (hasValuableTokens || token.isWhitespace() || isControl) continue;
                    if (tokenType == SQLTokenType.T_COMMENT) {
                        hasValuableTokens = dialect.supportsCommentQuery();
                        continue;
                    }
                    hasValuableTokens = true;
                    continue;
                }
                catch (BadLocationException e) {
                    SQLScriptParser.log.warn((Object)"Error parsing query", (Throwable)e);
                    buf = new StringWriter();
                    e.printStackTrace(new PrintWriter((Writer)buf, true));
                    var36_44 = new SQLQuery(context.getDataSource(), buf.toString());
                    return var36_44;
                }
            }
            finally {
                if (token.isWhitespace() || token.isEOF()) continue;
                prevNotEmptyTokenType = tokenType;
                continue;
            }
            break;
        }
    }

    public static SQLScriptElement parseQuery(DBPDataSource dataSource, SQLDialect dialect, DBPPreferenceStore preferenceStore, String sqlScriptContent, int cursorPosition) {
        SQLParserContext parserContext = SQLScriptParser.prepareSqlParserContext(dataSource, dialect, preferenceStore, sqlScriptContent);
        return SQLScriptParser.extractQueryAtPos(parserContext, cursorPosition);
    }

    private static boolean needsDelimiterAfterBlock(String firstKeyword, String lastKeyword, SQLDialect dialect) {
        if (dialect.needsDelimiterFor(firstKeyword, lastKeyword)) {
            return true;
        }
        if (!dialect.isDelimiterAfterBlock()) {
            return false;
        }
        if (firstKeyword == null) {
            return false;
        }
        if (!"END".equalsIgnoreCase(lastKeyword)) {
            return false;
        }
        firstKeyword = firstKeyword.toUpperCase(Locale.ENGLISH);
        String[][] blockBoundStrings = dialect.getBlockBoundStrings();
        if (blockBoundStrings != null) {
            String[][] stringArray = blockBoundStrings;
            int n = blockBoundStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String[] bb = stringArray[n2];
                if (bb[0].equals(firstKeyword)) {
                    return true;
                }
                ++n2;
            }
        }
        return ArrayUtils.contains((Object[])dialect.getBlockHeaderStrings(), (Object)firstKeyword) || ArrayUtils.contains((Object[])dialect.getDDLKeywords(), (Object)firstKeyword);
    }

    private static int countLineFeeds(IDocument document, int offset, int length) {
        int lfCount = 0;
        try {
            int i = offset;
            while (i < offset + length) {
                if (document.getChar(i) == '\n') {
                    ++lfCount;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            log.error((Object)e);
        }
        return lfCount;
    }

    public static SQLScriptElement extractQueryAtPos(SQLParserContext context, int currentPos) {
        return SQLScriptParser.tryExpandElement(SQLScriptParser.extractQueryAtPosImpl(context, currentPos), context);
    }

    /*
     * Unable to fully structure code
     */
    private static SQLScriptElement extractQueryAtPosImpl(SQLParserContext context, int currentPos) {
        block26: {
            block24: {
                block25: {
                    block27: {
                        document = context.getDocument();
                        if (document.getLength() == 0) {
                            return null;
                        }
                        syntaxManager = context.getSyntaxManager();
                        docLength = document.getLength();
                        v0 = partitioner = document instanceof IDocumentExtension3 != false ? ((IDocumentExtension3)document).getDocumentPartitioner("___sql_partitioning") : null;
                        if (partitioner == null) break block27;
                        try {
                            currLineIndex = document.getLineOfOffset(currentPos);
                            currLine = document.getLineInformation(currLineIndex);
                            currLineEnd = currLine.getOffset() + currLine.getLength();
                            hasNextLine = currLineIndex + 1 < document.getNumberOfLines();
                            inTailComment = "sql_comment".equals(partitioner.getContentType(currentPos));
                            if (!inTailComment && currentPos >= currLineEnd && (!hasNextLine || hasNextLine && currentPos < document.getLineInformation(currLineIndex + 1).getOffset())) {
                                inTailComment = "sql_comment".equals(partitioner.getContentType(currLineEnd - 1));
                            }
                            if (!inTailComment || (letterBeforeComment = SQLScriptParser.skipCommentsBackTillLetter(document, partitioner, observablePosition = currentPos < document.getLength() ? currentPos : currentPos - 1, currLine.getOffset())) < currLine.getOffset()) ** GOTO lbl23
                            currentPos = letterBeforeComment;
                            if (true) ** GOTO lbl23
                        }
                        catch (BadLocationException v1) {
                            return null;
                        }
                        do {
                            ++currentPos;
lbl23:
                            // 3 sources

                        } while (currentPos < docLength && SQLScriptParser.isMultiCommentPartition(partitioner, currentPos));
                    }
                    startPos = 0;
                    useBlankLines = syntaxManager.getStatementDelimiterMode().useBlankLine;
                    statementDelimiters = syntaxManager.getStatementDelimiters();
                    lastPos = currentPos >= docLength ? docLength - 1 : currentPos;
                    lineFeedIsDelimiter = ArrayUtils.contains((Object[])statementDelimiters, (Object)"\n");
                    currentLine = originalPosLine = document.getLineOfOffset(currentPos);
                    if (!useBlankLines || !TextUtils.isEmptyLine(document, currentLine)) break block24;
                    if (currentLine != 0) break block25;
                    return null;
                }
                if (!TextUtils.isEmptyLine(document, --currentLine)) break block24;
                return null;
            }
            try {
                if (!lineFeedIsDelimiter) {
                    document.getLineOffset(currentLine);
                    firstLine = currentLine;
                    while (firstLine > 0) {
                        if (useBlankLines && TextUtils.isEmptyLine(document, firstLine) && SQLScriptParser.isDefaultPartition(partitioner, document.getLineOffset(firstLine))) break;
                        if (currentLine == firstLine) {
                            var17_24 = statementDelimiters;
                            var16_22 = statementDelimiters.length;
                            var15_20 = 0;
                            while (var15_20 < var16_22) {
                                delim = var17_24[var15_20];
                                if (!Character.isLetterOrDigit(delim.charAt(0)) && (offset = TextUtils.getOffsetOf(document, firstLine, (String)delim)) >= 0 && SQLScriptParser.isDefaultPartition(partitioner, delimOffset = document.getLineOffset(firstLine) + offset + delim.length()) && currentPos > startPos && docLength > delimOffset) {
                                    hasValuableChars = false;
                                    i = delimOffset;
                                    while (i <= lastPos) {
                                        if (!Character.isWhitespace(document.getChar(i))) {
                                            hasValuableChars = true;
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (hasValuableChars) {
                                        startPos = delimOffset;
                                        break;
                                    }
                                }
                                ++var15_20;
                            }
                        }
                        --firstLine;
                    }
                    if (startPos == 0) {
                        startPos = document.getLineOffset(firstLine);
                    }
                }
                region = document.getLineInformation(currentLine);
                if (lineFeedIsDelimiter) {
                    startPos = currentPos = region.getOffset();
                    break block26;
                }
                if (region.getLength() <= 0) break block26;
                offsetFromLineStart = currentPos - region.getOffset();
                lineStr = document.get(region.getOffset(), offsetFromLineStart);
                var19_28 = statementDelimiters;
                var18_26 = statementDelimiters.length;
                var17_25 = 0;
                while (var17_25 < var18_26) {
                    delim = var19_28[var17_25];
                    delimIndex = lineStr.lastIndexOf((String)delim);
                    if (delimIndex != -1) {
                        hasValuableChars = false;
                        i = region.getOffset() + delimIndex + delim.length();
                        while (i < currentPos) {
                            if (!Character.isWhitespace(document.getChar(i))) {
                                hasValuableChars = true;
                                break;
                            }
                            ++i;
                        }
                        if (!hasValuableChars) {
                            currentPos = region.getOffset() + delimIndex - 1;
                            break;
                        }
                    }
                    ++var17_25;
                }
            }
            catch (BadLocationException e) {
                SQLScriptParser.log.warn((Object)e);
            }
        }
        return SQLScriptParser.parseQueryImpl(context, startPos, document.getLength(), currentPos, false, false);
    }

    private static boolean isDefaultPartition(IDocumentPartitioner partitioner, int currentPos) {
        return partitioner == null || "__dftl_partition_content_type".equals(partitioner.getContentType(currentPos));
    }

    private static boolean isMultiCommentPartition(IDocumentPartitioner partitioner, int currentPos) {
        return partitioner != null && "sql_multiline_comment".equals(partitioner.getContentType(currentPos));
    }

    public static SQLScriptElement extractNextQuery(@NotNull SQLParserContext context, int offset, boolean next) {
        SQLScriptElement curElement = SQLScriptParser.extractQueryAtPos(context, offset);
        return SQLScriptParser.tryExpandElement(SQLScriptParser.extractNextQueryImpl(context, curElement, next), context);
    }

    public static SQLScriptElement extractNextQuery(@NotNull SQLParserContext context, @Nullable SQLScriptElement curElement, boolean next) {
        return SQLScriptParser.tryExpandElement(SQLScriptParser.extractNextQueryImpl(context, curElement, next), context);
    }

    /*
     * Unable to fully structure code
     */
    private static SQLScriptElement extractNextQueryImpl(@NotNull SQLParserContext context, @Nullable SQLScriptElement curElement, boolean next) {
        block20: {
            if (curElement == null) {
                return null;
            }
            document = context.getDocument();
            partitioner = document instanceof IDocumentExtension3 != false ? ((IDocumentExtension3)document).getDocumentPartitioner("___sql_partitioning") : null;
            try {
                block19: {
                    block21: {
                        docLength = document.getLength();
                        if (!next) break block21;
                        statementDelimiters = context.getSyntaxManager().getStatementDelimiters();
                        curPos = curElement.getOffset() + curElement.getLength();
                        while (curPos < docLength) {
                            if (partitioner == null) ** GOTO lbl-1000
                            region = partitioner.getPartition(curPos);
                            var9_11 = region.getType();
                            tmp = -1;
                            switch (var9_11.hashCode()) {
                                case -1367807844: {
                                    if (var9_11.equals("sql_multiline_comment")) {
                                        tmp = 1;
                                    }
                                    break;
                                }
                                case 154903790: {
                                    if (var9_11.equals("sql_comment")) {
                                        tmp = 1;
                                    }
                                    break;
                                }
                            }
                            switch (tmp) {
                                case 1: {
                                    curPos = region.getOffset() + region.getLength();
                                    break;
                                }
                                default: lbl-1000:
                                // 2 sources

                                {
                                    if (!Character.isWhitespace(c = document.getChar(curPos))) {
                                        isDelimiter = false;
                                        var13_16 = statementDelimiters;
                                        var12_15 = statementDelimiters.length;
                                        var11_14 = 0;
                                        while (var11_14 < var12_15) {
                                            delim = var13_16[var11_14];
                                            if (delim.indexOf(c) != -1) {
                                                isDelimiter = true;
                                            }
                                            ++var11_14;
                                        }
                                        if (!isDelimiter) break block19;
                                    }
                                    ++curPos;
                                }
                            }
                        }
                        break block19;
                    }
                    curPos = curElement.getOffset() - 1;
                    curPos = SQLScriptParser.skipCommentsBackTillLetter(document, partitioner, curPos, 0);
                }
                if (curPos > 0 && curPos < docLength) break block20;
                return null;
            }
            catch (BadLocationException e) {
                SQLScriptParser.log.warn((Object)e);
                return null;
            }
        }
        return SQLScriptParser.extractQueryAtPosImpl(context, curPos);
    }

    /*
     * Unable to fully structure code
     */
    private static int skipCommentsBackTillLetter(@NotNull IDocument document, @Nullable IDocumentPartitioner partitioner, int pos, int limit) throws BadLocationException {
        curPos = pos;
        while (curPos >= limit) {
            if (partitioner == null) ** GOTO lbl-1000
            region = partitioner.getPartition(curPos);
            var6_7 = region.getType();
            tmp = -1;
            switch (var6_7.hashCode()) {
                case -1367807844: {
                    if (var6_7.equals("sql_multiline_comment")) {
                        tmp = 1;
                    }
                    break;
                }
                case 154903790: {
                    if (var6_7.equals("sql_comment")) {
                        tmp = 1;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    curPos = region.getOffset() - 1;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (Character.isLetter(c = document.getChar(curPos))) {
                        return curPos;
                    }
                    --curPos;
                }
            }
        }
        return -1;
    }

    @Nullable
    public static SQLScriptElement extractActiveQuery(SQLParserContext context, int selOffset, int selLength) {
        return SQLScriptParser.extractActiveQuery(context, new IRegion[]{new Region(selOffset, selLength)});
    }

    @Nullable
    public static SQLScriptElement extractActiveQuery(@NotNull SQLParserContext context, @NotNull IRegion[] regions) {
        SQLScriptElement element;
        String selText = null;
        try {
            StringJoiner text = new StringJoiner(CommonUtils.getLineSeparator());
            IRegion[] iRegionArray = regions;
            int n = regions.length;
            int n2 = 0;
            while (n2 < n) {
                IRegion region = iRegionArray[n2];
                if (region.getOffset() >= 0 && region.getLength() > 0) {
                    text.add(context.getDocument().get(region.getOffset(), region.getLength()));
                }
                ++n2;
            }
            if (text.length() > 0) {
                selText = text.toString();
            }
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
        }
        if (selText != null && context.getPreferenceStore().getBoolean("script.sql.query.remove.trailing.delimiter")) {
            SQLSyntaxManager syntaxManager;
            selText = SQLUtils.trimQueryStatement((SQLSyntaxManager)syntaxManager, (String)selText, (!(syntaxManager = context.getSyntaxManager()).getDialect().isDelimiterAfterQuery() ? 1 : 0) != 0);
        }
        IRegion region = regions[0];
        if (!CommonUtils.isEmpty(selText)) {
            SQLScriptElement parsedElement = SQLScriptParser.parseQuery(context, region.getOffset(), region.getOffset() + region.getLength(), region.getOffset(), false, false);
            if (parsedElement instanceof SQLControlCommand) {
                element = parsedElement;
            } else {
                selText = SQLUtils.fixLineFeeds((String)selText);
                element = new SQLQuery(context.getDataSource(), selText, region.getOffset(), region.getLength());
            }
        } else {
            element = region.getOffset() >= 0 ? SQLScriptParser.extractQueryAtPos(context, region.getOffset()) : null;
        }
        if (element == null || CommonUtils.isEmpty((String)element.getText())) {
            return null;
        }
        if (element instanceof SQLQuery) {
            SQLQuery query = (SQLQuery)element;
            query.setParameters(SQLScriptParser.parseParametersAndVariables(context, query.getText()));
        }
        return element;
    }

    public static List<SQLQueryParameter> parseParametersAndVariables(SQLParserContext context, String selectedQueryText) {
        SQLParserContext ctx = new SQLParserContext(context.getDataSource(), context.getSyntaxManager(), context.getRuleManager(), (IDocument)new Document(selectedQueryText));
        return SQLScriptParser.parseParametersAndVariables(ctx, 0, selectedQueryText.length());
    }

    public static List<SQLQueryParameter> parseParametersAndVariables(SQLParserContext context, int queryOffset, int queryLength) {
        SQLDialect sqlDialect = context.getDialect();
        IDocument document = context.getDocument();
        if (queryOffset + queryLength > document.getLength()) {
            queryLength = document.getLength() - queryOffset;
        }
        SQLSyntaxManager syntaxManager = context.getSyntaxManager();
        boolean supportParamsInEmbeddedCode = context.getPreferenceStore().getBoolean("sql.parameter.ddl.enabled");
        boolean execQuery = false;
        boolean ddlQuery = false;
        boolean insideDollarQuote = false;
        ArrayList<SQLQueryParameter> parameters = null;
        TPRuleBasedScanner ruleScanner = context.getScanner();
        ruleScanner.setRange(document, queryOffset, queryLength);
        boolean firstKeyword = true;
        if (syntaxManager.isParametersEnabled()) {
            while (true) {
                SQLTokenType tokenType;
                TPToken token = ruleScanner.nextToken();
                int tokenOffset = ruleScanner.getTokenOffset();
                int tokenLength = ruleScanner.getTokenLength();
                if (token.isEOF() || tokenOffset > queryOffset + queryLength) break;
                SQLTokenType sQLTokenType = tokenType = token instanceof TPTokenDefault ? (SQLTokenType)((TPTokenDefault)token).getData() : null;
                if (token.isWhitespace() || tokenType == SQLTokenType.T_COMMENT) continue;
                if (firstKeyword) {
                    try {
                        String tokenText = document.get(tokenOffset, tokenLength);
                        if (ArrayUtils.containsIgnoreCase((String[])sqlDialect.getDDLKeywords(), (String)tokenText)) {
                            ddlQuery = true;
                        } else {
                            execQuery = ArrayUtils.containsIgnoreCase((String[])sqlDialect.getExecuteKeywords(), (String)tokenText);
                        }
                    }
                    catch (BadLocationException e) {
                        log.warn((Object)e);
                    }
                    firstKeyword = false;
                }
                if (tokenType == SQLTokenType.T_BLOCK_TOGGLE) {
                    boolean bl = insideDollarQuote = !insideDollarQuote;
                }
                if (tokenType != SQLTokenType.T_PARAMETER || tokenLength <= 0) continue;
                try {
                    String variableName;
                    String paramName = document.get(tokenOffset, tokenLength);
                    if (!supportParamsInEmbeddedCode && (ddlQuery || insideDollarQuote) || execQuery && paramName.equals(String.valueOf(syntaxManager.getAnonymousParameterMark()))) continue;
                    if (parameters == null) {
                        parameters = new ArrayList<SQLQueryParameter>();
                    }
                    String preparedParamName = null;
                    String paramMark = paramName.substring(0, 1);
                    if (paramMark.equals("$") && !(variableName = SQLQueryParameter.stripVariablePattern((String)paramName)).equals(paramName)) {
                        preparedParamName = variableName;
                    }
                    if (preparedParamName == null) {
                        preparedParamName = ArrayUtils.contains((Object[])syntaxManager.getNamedParameterPrefixes(), (Object)paramMark) ? paramName.substring(1) : paramName;
                    }
                    SQLQueryParameter parameter = new SQLQueryParameter(syntaxManager, parameters.size(), preparedParamName, paramName, tokenOffset - queryOffset, tokenLength);
                    parameter.setPrevious(SQLScriptParser.getPreviousParameter(parameters, parameter));
                    parameters.add(parameter);
                }
                catch (BadLocationException e) {
                    log.warn((Object)"Can't extract query parameter", (Throwable)e);
                }
            }
        }
        if (syntaxManager.isVariablesEnabled()) {
            try {
                String query = document.get(queryOffset, queryLength);
                Matcher matcher = SQLQueryParameter.getVariablePattern().matcher(query);
                int position = 0;
                while (matcher.find(position)) {
                    int start = matcher.start();
                    int orderPos = 0;
                    SQLQueryParameter param = null;
                    if (parameters != null) {
                        for (SQLQueryParameter p : parameters) {
                            if (p.getTokenOffset() == start) {
                                param = p;
                                break;
                            }
                            if (p.getTokenOffset() >= start) continue;
                            ++orderPos;
                        }
                    }
                    if (param == null) {
                        String paramName = matcher.group("pn");
                        param = new SQLQueryParameter(syntaxManager, orderPos, paramName, paramName, start, matcher.end() - matcher.start());
                        if (parameters == null) {
                            parameters = new ArrayList();
                        }
                        param.setPrevious(SQLScriptParser.getPreviousParameter(parameters, param));
                        parameters.add(param.getOrdinalPosition(), param);
                    }
                    position = matcher.end();
                }
            }
            catch (BadLocationException e) {
                log.warn((Object)"Error parsing variables", (Throwable)e);
            }
        }
        return parameters;
    }

    private static SQLQueryParameter getPreviousParameter(List<SQLQueryParameter> parameters, SQLQueryParameter parameter) {
        String varName = parameter.getVarName();
        if (parameter.isNamed()) {
            int i = parameters.size();
            while (i > 0) {
                if (parameters.get(i - 1).getVarName().equals(varName)) {
                    return parameters.get(i - 1);
                }
                --i;
            }
        }
        return null;
    }

    public static List<SQLScriptElement> extractScriptQueries(@NotNull SQLParserContext parserContext, int startOffset, int length, boolean scriptMode, boolean keepDelimiters, boolean parseParameters) {
        LinkedList<SQLScriptElement> queryList = new LinkedList<SQLScriptElement>();
        IDocument document = parserContext.getDocument();
        if (document.getLength() == 0) {
            return queryList;
        }
        parserContext.startScriptEvaluation();
        try {
            SQLScriptElement query;
            int queryOffset = startOffset;
            while ((query = SQLScriptParser.parseQueryImpl(parserContext, queryOffset, startOffset + length, queryOffset, scriptMode, keepDelimiters)) != null) {
                queryList.add(query);
                queryOffset = query.getOffset() + query.getLength();
            }
        }
        finally {
            parserContext.endScriptEvaluation();
        }
        if (parserContext.getSyntaxManager().getStatementDelimiterMode().useSmart) {
            SQLScriptParser.expandQueries(parserContext, queryList);
        }
        if (parseParameters) {
            for (SQLScriptElement element : queryList) {
                if (!(element instanceof SQLQuery)) continue;
                SQLQuery query = (SQLQuery)element;
                query.setParameters(SQLScriptParser.parseParametersAndVariables(parserContext, query.getOffset(), query.getLength()));
            }
        }
        return queryList;
    }

    private static void expandQueries(@NotNull SQLParserContext parserContext, @NotNull List<SQLScriptElement> queryList) {
        ScriptElementContinuationDetector continuationDetector = new ScriptElementContinuationDetector(parserContext);
        ListIterator<SQLScriptElement> it = queryList.listIterator();
        while (it.hasNext()) {
            SQLQuery lastElement;
            SQLQuery queryElement;
            boolean captureCurrElement;
            SQLQuery queryStart;
            SQLScriptElement firstElement = it.next();
            if (!(firstElement instanceof SQLQuery) || (queryStart = (SQLQuery)firstElement).isEndsWithDelimiter().booleanValue() || !it.hasNext()) continue;
            SQLQuery prevElement = queryStart;
            SQLScriptElement currElement = it.next();
            while ((captureCurrElement = currElement instanceof SQLQuery && !continuationDetector.elementStartsProperly((SQLScriptElement)(queryElement = (SQLQuery)currElement)) && prevElement.isEndsWithDelimiter() == false) && it.hasNext()) {
                it.remove();
                prevElement = (SQLQuery)currElement;
                currElement = it.next();
            }
            SQLQuery sQLQuery = lastElement = captureCurrElement ? (SQLQuery)currElement : prevElement;
            if (lastElement != firstElement) {
                if (captureCurrElement) {
                    it.remove();
                }
                SQLScriptElement prev = it.previous();
                if (!captureCurrElement) {
                    assert (prev == currElement);
                    prev = it.previous();
                }
                assert (prev == firstElement);
                it.remove();
                it.add((SQLScriptElement)continuationDetector.prepareExtendedSQLScriptElement(queryStart, lastElement));
                continue;
            }
            it.previous();
        }
    }

    public static List<SQLScriptElement> parseScript(DBPDataSource dataSource, String sqlScriptContent) {
        SQLSyntaxManager syntaxManager = new SQLSyntaxManager();
        syntaxManager.init(dataSource.getSQLDialect(), dataSource.getContainer().getPreferenceStore());
        SQLRuleManager ruleManager = new SQLRuleManager(syntaxManager);
        ruleManager.loadRules(dataSource, false);
        Document sqlDocument = new Document(sqlScriptContent);
        SQLParserContext parserContext = new SQLParserContext(dataSource, syntaxManager, ruleManager, (IDocument)sqlDocument);
        return SQLScriptParser.extractScriptQueries(parserContext, 0, sqlScriptContent.length(), true, false, true);
    }

    public static List<SQLScriptElement> parseScript(DBPDataSource dataSource, SQLDialect dialect, DBPPreferenceStore preferenceStore, String sqlScriptContent) {
        SQLParserContext parserContext = SQLScriptParser.prepareSqlParserContext(dataSource, dialect, preferenceStore, sqlScriptContent);
        return SQLScriptParser.extractScriptQueries(parserContext, 0, sqlScriptContent.length(), true, false, true);
    }

    @NotNull
    private static SQLParserContext prepareSqlParserContext(DBPDataSource dataSource, SQLDialect dialect, DBPPreferenceStore preferenceStore, String sqlScriptContent) {
        SQLSyntaxManager syntaxManager = new SQLSyntaxManager();
        syntaxManager.init(dialect, preferenceStore);
        SQLRuleManager ruleManager = new SQLRuleManager(syntaxManager);
        ruleManager.loadRules();
        Document sqlDocument = new Document(sqlScriptContent);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new SQLPartitionScanner(dataSource, dialect, ruleManager), SQLParserPartitions.SQL_CONTENT_TYPES);
        partitioner.connect((IDocument)sqlDocument);
        sqlDocument.setDocumentPartitioner("___sql_partitioning", (IDocumentPartitioner)partitioner);
        SQLParserContext parserContext = new SQLParserContext(dataSource, syntaxManager, ruleManager, (IDocument)sqlDocument);
        parserContext.setPreferenceStore(preferenceStore);
        return parserContext;
    }

    private static SQLScriptElement tryExpandElement(SQLScriptElement element, SQLParserContext context) {
        if (element instanceof SQLQuery) {
            ScriptElementContinuationDetector continuationDetector;
            SQLScriptElement extendedElement;
            SQLQuery queryElement = (SQLQuery)element;
            if (context.getSyntaxManager().getStatementDelimiterMode().useSmart && (extendedElement = (continuationDetector = new ScriptElementContinuationDetector(context)).tryPrepareExtendedElement(queryElement)) != null) {
                return extendedElement;
            }
        }
        return element;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$model$sql$parser$tokens$SQLTokenType() {
        if ($SWITCH_TABLE$org$jkiss$dbeaver$model$sql$parser$tokens$SQLTokenType != null) {
            return $SWITCH_TABLE$org$jkiss$dbeaver$model$sql$parser$tokens$SQLTokenType;
        }
        int[] nArray = new int[SQLTokenType.values().length];
        try {
            nArray[SQLTokenType.T_BLOCK_BEGIN.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_BLOCK_END.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_BLOCK_HEADER.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_BLOCK_TOGGLE.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_COLUMN.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_COLUMN_DERIVED.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_COMMENT.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_COMPOSITE_FIELD.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_CONTROL.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_DELIMITER.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_FUNCTION.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_KEYWORD.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_NUMBER.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_OTHER.ordinal()] = 26;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_PARAMETER.ordinal()] = 24;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_QUOTED.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_SCHEMA.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_SEMANTIC_ERROR.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_SET_DELIMITER.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_SQL_VARIABLE.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_STRING.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_TABLE.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_TABLE_ALIAS.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_TYPE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_UNKNOWN.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_VARIABLE.ordinal()] = 25;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$jkiss$dbeaver$model$sql$parser$tokens$SQLTokenType = nArray;
        return nArray;
    }

    private static class ScriptBlockInfo {
        final ScriptBlockInfo parent;
        final String togglePattern;
        boolean isHeader;

        ScriptBlockInfo(ScriptBlockInfo parent, boolean isHeader) {
            this.parent = parent;
            this.togglePattern = null;
            this.isHeader = isHeader;
        }

        ScriptBlockInfo(ScriptBlockInfo parent, String togglePattern) {
            this.parent = parent;
            this.togglePattern = togglePattern;
        }
    }

    private static class ScriptElementContinuationDetector {
        private static final Set<Integer> statementStartTokenIds = LSMInspections.prepareOffquerySyntaxInspection().predictedTokenIds();
        private static final Map<SQLDialect, Set<String>> statementStartKeywordsByDialect = Collections.synchronizedMap(new WeakHashMap());
        private final Set<String> statementStartKeywords;
        private final SQLParserContext context;
        private final LSMAnalyzerParameters analyzerParameters;

        public ScriptElementContinuationDetector(@NotNull SQLParserContext context) {
            this.context = context;
            this.statementStartKeywords = ScriptElementContinuationDetector.getStatementStartKeywords(this.context);
            this.analyzerParameters = LSMAnalyzerParameters.forDialect((SQLDialect)this.context.getDialect(), (SQLSyntaxManager)this.context.getSyntaxManager());
        }

        private static Set<String> getStatementStartKeywords(SQLParserContext context) {
            return statementStartKeywordsByDialect.computeIfAbsent(context.getDialect(), d -> ScriptElementContinuationDetector.prepareStatementStartKeywordsSet(context));
        }

        private static Set<String> prepareStatementStartKeywordsSet(SQLParserContext context) {
            String[][] blockBoundStrings;
            SQLDialect dialect = context.getDialect();
            HashSet<String> statementStartKeywords = new HashSet<String>();
            if (dialect.getBlockHeaderStrings() != null) {
                Arrays.stream(dialect.getBlockHeaderStrings()).map(String::toUpperCase).forEach(statementStartKeywords::add);
            }
            if ((blockBoundStrings = dialect.getBlockBoundStrings()) != null) {
                String[][] stringArray = blockBoundStrings;
                int n = blockBoundStrings.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] block = stringArray[n2];
                    statementStartKeywords.add(block[0]);
                    ++n2;
                }
            }
            if (dialect.getTransactionCommitKeywords() != null) {
                Arrays.stream(dialect.getTransactionCommitKeywords()).map(String::toUpperCase).forEach(statementStartKeywords::add);
            }
            if (dialect.getTransactionRollbackKeywords() != null) {
                Arrays.stream(dialect.getTransactionRollbackKeywords()).map(String::toUpperCase).forEach(statementStartKeywords::add);
            }
            if (dialect instanceof AbstractSQLDialect) {
                AbstractSQLDialect abstractSQLDialect = (AbstractSQLDialect)dialect;
                Arrays.stream(abstractSQLDialect.getNonTransactionKeywords()).map(String::toUpperCase).forEach(statementStartKeywords::add);
            }
            Arrays.stream(dialect.getExecuteKeywords()).map(String::toUpperCase).forEach(statementStartKeywords::add);
            String commandPrefix = context.getSyntaxManager().getControlCommandPrefix();
            String multilineCommandPrefix = commandPrefix.repeat(2);
            for (SQLCommandHandlerDescriptor controlCommand : SQLCommandsRegistry.getInstance().getCommandHandlers()) {
                statementStartKeywords.add(commandPrefix + controlCommand.getId().toUpperCase());
                statementStartKeywords.add(multilineCommandPrefix + controlCommand.getId().toUpperCase());
            }
            Arrays.stream(dialect.getQueryKeywords()).map(String::toUpperCase).forEach(statementStartKeywords::add);
            Arrays.stream(dialect.getDMLKeywords()).map(String::toUpperCase).forEach(statementStartKeywords::add);
            Arrays.stream(dialect.getDDLKeywords()).map(String::toUpperCase).forEach(statementStartKeywords::add);
            return statementStartKeywords;
        }

        private boolean elementStartsProperly(@NotNull SQLScriptElement element) {
            SQLStandardLexer lexer = SQLStandardAnalyzer.createLexer((STMSource)STMSource.fromString((String)element.getOriginalText()), (LSMAnalyzerParameters)this.analyzerParameters);
            Token token = lexer.nextToken();
            while (token != null && token.getType() != -1 && token.getChannel() != 0) {
                token = lexer.nextToken();
            }
            return token != null && (statementStartTokenIds.contains(token.getType()) || this.statementStartKeywords.contains(token.getText().toUpperCase()));
        }

        /*
         * Unable to fully structure code
         */
        private SQLQuery findSmartStatementBegginning(@NotNull SQLQuery element) {
            lastElement = element;
            prevElement = SQLScriptParser.extractNextQueryImpl(this.context, (SQLScriptElement)element, false);
            takePrev = true;
            while (prevElement instanceof SQLQuery && (takePrev = Boolean.TRUE.equals((prevQueryFragment = (SQLQuery)prevElement).isEndsWithDelimiter()) == false || prevElement.getOffset() + prevElement.getLength() >= lastElement.getOffset() + lastElement.getLength()) && !this.elementStartsProperly(prevElement) && prevElement.getOffset() < lastElement.getOffset()) {
                lastElement = prevQueryFragment;
                prevElement = SQLScriptParser.extractNextQueryImpl(this.context, (SQLScriptElement)lastElement, false);
            }
            if (!(prevElement instanceof SQLQuery)) ** GOTO lbl-1000
            prevQueryElement = (SQLQuery)prevElement;
            if (takePrev) {
                v0 = prevQueryElement;
            } else lbl-1000:
            // 2 sources

            {
                v0 = lastElement;
            }
            boundaryElement = v0;
            return boundaryElement;
        }

        private SQLQuery findSmartStatementEnding(@NotNull SQLQuery element) {
            SQLQuery lastElement = element;
            SQLScriptElement nextElement = SQLScriptParser.extractNextQueryImpl(this.context, (SQLScriptElement)element, true);
            while (nextElement instanceof SQLQuery) {
                SQLQuery nextQueryFragment = (SQLQuery)nextElement;
                if (Boolean.TRUE.equals(lastElement.isEndsWithDelimiter()) || this.elementStartsProperly(nextElement) || nextElement.getOffset() <= lastElement.getOffset()) break;
                lastElement = nextQueryFragment;
                nextElement = SQLScriptParser.extractNextQueryImpl(this.context, (SQLScriptElement)lastElement, true);
            }
            return lastElement;
        }

        @Nullable
        public SQLScriptElement tryPrepareExtendedElement(@NotNull SQLQuery element) {
            SQLQuery headElement = this.elementStartsProperly((SQLScriptElement)element) ? element : this.findSmartStatementBegginning(element);
            SQLQuery extendedHead = headElement == element ? element : this.prepareExtendedSQLScriptElement(headElement, element);
            SQLQuery tailElement = this.findSmartStatementEnding(extendedHead);
            return this.prepareExtendedSQLScriptElement(extendedHead, tailElement);
        }

        public SQLQuery prepareExtendedSQLScriptElement(@NotNull SQLQuery headElement, @NotNull SQLQuery tailElement) {
            try {
                int extractionEnd;
                int realEnd;
                int start = headElement.getOffset();
                int headEnd = headElement.getOffset() + headElement.getLength();
                int tailEnd = tailElement.getOffset() + tailElement.getLength();
                if (headEnd > tailEnd) {
                    realEnd = headEnd;
                    extractionEnd = headElement.getOffset() + headElement.getOriginalText().length();
                } else {
                    realEnd = tailEnd;
                    extractionEnd = tailElement.getOffset() + tailElement.getOriginalText().length();
                }
                String text = this.context.getDocument().get(start, extractionEnd - start);
                SQLQuery query = new SQLQuery(this.context.getDataSource(), text, start, realEnd - start);
                query.setEndsWithDelimiter(tailElement.isEndsWithDelimiter().booleanValue());
                return query;
            }
            catch (BadLocationException badLocationException) {
                return headElement;
            }
        }
    }
}

