/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScopeItem;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDummyDataSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryMemberAccessEntry;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;

public class SQLQueryQualifiedName
extends SQLQueryLexicalScopeItem {
    @NotNull
    public final List<SQLQuerySymbolEntry> scopeName;
    @NotNull
    public final SQLQuerySymbolEntry entityName;
    public final int invalidPartsCount;
    @Nullable
    public final SQLQueryMemberAccessEntry endingPeriodNode;

    public SQLQueryQualifiedName(@NotNull STMTreeNode syntaxNode, @NotNull List<SQLQuerySymbolEntry> scopeName, @NotNull SQLQuerySymbolEntry entityName, int invalidPartsCount, @Nullable SQLQueryMemberAccessEntry endingPeriodNode) {
        super(syntaxNode);
        this.scopeName = scopeName;
        this.entityName = entityName;
        this.invalidPartsCount = invalidPartsCount;
        this.endingPeriodNode = endingPeriodNode;
    }

    @Override
    @NotNull
    public SQLQuerySymbolClass getSymbolClass() {
        return this.entityName != null ? this.entityName.getSymbolClass() : SQLQuerySymbolClass.UNKNOWN;
    }

    public void setSymbolClass(@NotNull SQLQuerySymbolClass symbolClass) {
        this.entityName.getSymbol().setSymbolClass(symbolClass);
        for (SQLQuerySymbolEntry e : this.scopeName) {
            if (e == null) continue;
            e.getSymbol().setSymbolClass(symbolClass);
        }
    }

    public void setDefinition(@NotNull DBSObject realObject, SQLQuerySymbolOrigin origin) {
        SQLQuerySymbolClass entityNameClass = realObject instanceof DBSTable || realObject instanceof DBSView ? SQLQuerySymbolClass.TABLE : SQLQuerySymbolClass.OBJECT;
        this.setDefinition(realObject, entityNameClass, origin);
    }

    public void setDefinition(@NotNull DBSObject realObject, @NotNull SQLQuerySymbolClass entityNameClass, @NotNull SQLQuerySymbolOrigin origin) {
        SQLQueryQualifiedName.setNamePartsDefinition(this.scopeName, this.entityName, realObject, entityNameClass, origin);
    }

    private static void setNamePartsDefinition(@NotNull List<SQLQuerySymbolEntry> scopeName, @NotNull SQLQuerySymbolEntry entityName, @NotNull DBSObject realObject, @NotNull SQLQuerySymbolClass entityNameClass, @NotNull SQLQuerySymbolOrigin origin) {
        SQLQuerySymbolEntry lastPart = entityName;
        entityName.setDefinition(new SQLQuerySymbolByDbObjectDefinition(realObject, entityNameClass));
        DBSObject object = realObject.getParentObject();
        int scopeNameIndex = scopeName.size() - 1;
        while (object != null && scopeNameIndex >= 0) {
            SQLQuerySymbolEntry nameEntry = scopeName.get(scopeNameIndex);
            String objectName = SQLUtils.identifierToCanonicalForm((SQLDialect)object.getDataSource().getSQLDialect(), (String)DBUtils.getQuotedIdentifier((DBSObject)object), (boolean)false, (boolean)true);
            if (objectName.equalsIgnoreCase(nameEntry.getName())) {
                SQLQuerySymbolClass objectNameClass = object instanceof DBSSchema ? SQLQuerySymbolClass.SCHEMA : (object instanceof DBSCatalog ? SQLQuerySymbolClass.CATALOG : SQLQuerySymbolClass.UNKNOWN);
                nameEntry.setDefinition(new SQLQuerySymbolByDbObjectDefinition(object, objectNameClass));
                lastPart.setOrigin(new SQLQuerySymbolOrigin.DbObjectFromDbObject(object, RelationalObjectType.TYPE_UNKNOWN));
                lastPart = nameEntry;
                --scopeNameIndex;
            }
            object = object.getParentObject();
        }
        lastPart.setOrigin(origin);
    }

    public void setDefinition(@NotNull SourceResolutionResult rr, @NotNull SQLQuerySymbolOrigin origin) {
        SQLQueryRowsTableDataModel tableModel;
        SQLQueryQualifiedName tableName;
        if (rr.aliasOrNull != null) {
            this.entityName.setDefinition(rr.aliasOrNull.getDefinition());
            this.entityName.setOrigin(origin);
        } else if (rr.source instanceof SQLQueryRowsTableDataModel && (tableName = (tableModel = (SQLQueryRowsTableDataModel)rr.source).getName()) != null) {
            SQLQuerySymbolEntry lastDefSymbolEntry = tableName.entityName;
            this.entityName.setDefinition(lastDefSymbolEntry);
            this.entityName.setOrigin(lastDefSymbolEntry.getOrigin());
            int i = this.scopeName.size() - 1;
            int j = tableName.scopeName.size() - 1;
            while (i >= 0 && j >= 0) {
                SQLQuerySymbolEntry part = this.scopeName.get(i);
                lastDefSymbolEntry = tableName.scopeName.get(j);
                part.setDefinition(lastDefSymbolEntry);
                part.setOrigin(lastDefSymbolEntry.getOrigin());
                --i;
                --j;
            }
            while (i >= 0) {
                this.scopeName.get(i).setDefinition(lastDefSymbolEntry);
                --i;
            }
        }
    }

    @NotNull
    public List<String> toListOfStrings() {
        if (this.scopeName.isEmpty()) {
            return List.of(this.entityName.getName());
        }
        return Stream.of(this.scopeName.stream().filter(Objects::nonNull).map(SQLQuerySymbolEntry::getName), Stream.of(this.entityName.getName())).flatMap(s -> s).toList();
    }

    @NotNull
    public String toIdentifierString() {
        if (this.scopeName.isEmpty()) {
            return this.entityName.getRawName();
        }
        return String.join((CharSequence)".", this.toListOfStrings());
    }

    public String toString() {
        return String.join((CharSequence)".", this.toListOfStrings());
    }

    public int hashCode() {
        return this.toListOfStrings().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SQLQueryQualifiedName) {
            SQLQueryQualifiedName other = (SQLQueryQualifiedName)obj;
            if (this.toListOfStrings().equals(other.toListOfStrings())) {
                return true;
            }
        }
        return false;
    }

    public boolean isNotClassified() {
        return this.entityName.isNotClassified() && this.scopeName.stream().filter(Objects::nonNull).allMatch(SQLQuerySymbolEntry::isNotClassified);
    }

    public static void performPartialResolution(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics, @NotNull SQLQueryQualifiedName name, @NotNull SQLQuerySymbolOrigin origin, @NotNull Set<DBSObjectType> objectTypes, @NotNull SQLQuerySymbolClass entityNameClass) {
        if (!statistics.useRealMetadata() || context instanceof SQLQueryDummyDataSourceContext) {
            return;
        }
        List<SQLQuerySymbolEntry> nameParts = SQLQueryQualifiedName.prepareNamePartsList(name);
        DBSObject object = null;
        List<SQLQuerySymbolEntry> nameFragment = nameParts;
        int len = nameParts.size();
        while (len > 0 && object == null) {
            nameFragment = nameParts.subList(0, len);
            List<String> fragmentStrings = nameFragment.stream().map(SQLQuerySymbolEntry::getName).toList();
            object = context.findRealObject(statistics.getMonitor(), RelationalObjectType.TYPE_UNKNOWN, fragmentStrings);
            --len;
        }
        if (object != null && !nameFragment.isEmpty()) {
            SQLQueryQualifiedName.setNamePartsDefinition(nameFragment.subList(0, nameFragment.size() - 1), nameFragment.get(nameFragment.size() - 1), object, SQLQuerySymbolClass.OBJECT, origin);
            if (nameParts.size() > nameFragment.size()) {
                nameParts.get(nameFragment.size()).setOrigin(new SQLQuerySymbolOrigin.DbObjectFromDbObject(object, objectTypes));
            }
        } else if (!nameFragment.isEmpty()) {
            nameFragment.get(0).setOrigin(origin);
        }
        if (name.entityName.isNotClassified()) {
            name.entityName.getSymbol().setSymbolClass(entityNameClass);
        }
    }

    @NotNull
    private static List<SQLQuerySymbolEntry> prepareNamePartsList(@NotNull SQLQueryQualifiedName name) {
        ArrayList<SQLQuerySymbolEntry> nameParts = new ArrayList<SQLQuerySymbolEntry>(name.scopeName.size());
        boolean closed = false;
        for (SQLQuerySymbolEntry entry : name.scopeName) {
            if (entry != null) {
                nameParts.add(entry);
                continue;
            }
            closed = true;
            break;
        }
        if (!closed && name.entityName != null) {
            nameParts.add(name.entityName);
        }
        return nameParts;
    }
}

