/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.completion;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.jface.text.BadLocationException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionAnalyzer;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionContext;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionDescriptionProvider;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionExtraTextProvider;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItem;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemKind;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionProposal;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionProposalContext;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionSet;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionTextProvider;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryWordEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDummyDataSourceContext;
import org.jkiss.dbeaver.model.stm.LSMInspections;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.Pair;

public class SQLQueryCompletionAnalyzer
implements DBRRunnableParametrized<DBRProgressMonitor> {
    private static final Log log = Log.getLog(SQLCompletionAnalyzer.class);
    @NotNull
    private final Function<DBRProgressMonitor, SQLQueryCompletionContext> completionContextSupplier;
    @NotNull
    protected final SQLCompletionRequest request;
    @NotNull
    private final Supplier<Integer> currentCompletionOffsetSupplier;
    @NotNull
    private final AtomicReference<Pair<Integer, List<SQLQueryCompletionProposal>>> result = new AtomicReference<Pair>(Pair.of(null, Collections.emptyList()));
    private SQLQueryCompletionProposalContext proposalContext;

    public SQLQueryCompletionAnalyzer(@NotNull Function<DBRProgressMonitor, SQLQueryCompletionContext> completionContextSupplier, @NotNull SQLCompletionRequest request, @NotNull Supplier<Integer> currentCompletionOffsetSupplier) {
        this.completionContextSupplier = completionContextSupplier;
        this.request = request;
        this.currentCompletionOffsetSupplier = currentCompletionOffsetSupplier;
    }

    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Pair result;
        SQLQueryCompletionContext completionContext = this.completionContextSupplier.apply(monitor);
        if (completionContext != null && this.request.getContext().getDataSource() != null) {
            this.proposalContext = this.createProposalContext(completionContext);
            List<SQLQueryCompletionProposal> proposals = this.prepareContextfulCompletion(monitor, completionContext);
            result = Pair.of((Object)completionContext.getRequestOffset(), proposals);
        } else {
            int completionRequestPosition = completionContext != null ? completionContext.getRequestOffset() : this.currentCompletionOffsetSupplier.get().intValue();
            result = Pair.of((Object)completionRequestPosition, Collections.emptyList());
        }
        this.result.set((Pair<Integer, List<SQLQueryCompletionProposal>>)result);
    }

    @NotNull
    protected SQLQueryCompletionProposalContext createProposalContext(@NotNull SQLQueryCompletionContext completionContext) {
        return new SQLQueryCompletionProposalContext(this.request, completionContext.getRequestOffset());
    }

    private String getTextFragmentAt(int offset, int length) {
        if (offset >= 0 && offset + length <= this.request.getDocument().getLength()) {
            try {
                return this.request.getDocument().get(offset, length);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return null;
    }

    private List<SQLQueryCompletionProposal> prepareContextfulCompletion(DBRProgressMonitor monitor, SQLQueryCompletionContext completionContext) {
        Collection<SQLQueryCompletionSet> completionSets = completionContext.prepareProposal(monitor, this.request);
        SQLQueryCompletionTextProvider textProvider = new SQLQueryCompletionTextProvider(this.request, completionContext, monitor);
        LinkedList<SQLQueryCompletionProposal> proposals = new LinkedList<SQLQueryCompletionProposal>();
        HashSet<String> texts = new HashSet<String>();
        for (SQLQueryCompletionSet completionSet : completionSets) {
            for (SQLQueryCompletionItem sQLQueryCompletionItem : completionSet.getItems()) {
                DBSObject object = SQLQueryDummyDataSourceContext.isDummyObject(sQLQueryCompletionItem.getObject()) ? null : sQLQueryCompletionItem.getObject();
                String text = sQLQueryCompletionItem.apply(textProvider);
                if (!texts.add(text)) continue;
                String decoration = sQLQueryCompletionItem.apply(SQLQueryCompletionExtraTextProvider.INSTANCE);
                String description = sQLQueryCompletionItem.apply(SQLQueryCompletionDescriptionProvider.INSTANCE);
                String replacementString = this.prepareReplacementString(sQLQueryCompletionItem, text, completionContext);
                proposals.add(this.createProposal(sQLQueryCompletionItem.getKind(), object, this.prepareProposalImage(sQLQueryCompletionItem), text, decoration, description, replacementString, completionSet.getReplacementPosition(), completionSet.getReplacementLength(), sQLQueryCompletionItem.getFilterInfo(), sQLQueryCompletionItem.getScore()));
            }
        }
        return proposals;
    }

    protected SQLQueryCompletionProposal createProposal(@NotNull SQLQueryCompletionItemKind itemKind, @Nullable DBSObject object, @Nullable DBPImage image, @Nullable String displayString, @Nullable String decorationString, @NotNull String description, @NotNull String replacementString, int replacementOffset, int replacementLength, @Nullable SQLQueryWordEntry filterString, int proposalScore) {
        return new SQLQueryCompletionProposal(this.proposalContext, itemKind, object, image, displayString, decorationString, description, replacementString, replacementOffset, replacementLength, filterString, proposalScore);
    }

    @NotNull
    private String prepareReplacementString(@NotNull SQLQueryCompletionItem item, @NotNull String text, @NotNull SQLQueryCompletionContext completionContext) {
        LSMInspections.SyntaxInspectionResult inspectionResult = completionContext.getInspectionResult();
        boolean whitespaceNeeded = item.getKind() == SQLQueryCompletionItemKind.RESERVED || !text.endsWith(" ") && this.proposalContext.isInsertSpaceAfterProposal() && (inspectionResult.expectingTableReference() && item.getKind().isTableName || (inspectionResult.expectingColumnReference() || inspectionResult.expectingColumnName()) && item.getKind().isColumnName);
        return whitespaceNeeded ? text + " " : text;
    }

    @NotNull
    public List<? extends SQLQueryCompletionProposal> getResult() {
        return (List)this.result.get().getSecond();
    }

    public Integer getActualContextOffset() {
        return (Integer)this.result.get().getFirst();
    }

    @Nullable
    protected DBPImage prepareProposalImage(@NotNull SQLQueryCompletionItem item) {
        return null;
    }
}

