/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.struct.rdb.DBSTrigger;

public class SQLQueryDummyDataSourceContext
extends SQLQueryDataContext {
    private final SQLDialect dialect;
    private final DummyDbObject dummyDataSource;
    private final DummyDbObject defaultDummyCatalog;
    private final DummyDbObject defaultDummySchema;
    private final DummyDbObject defaultDummyTable;
    private final Set<String> knownColumnNames;
    private final Set<String> knownTableNames;
    private final Set<String> knownSchemaNames;
    private final Set<String> knownCatalogNames;

    public static boolean isDummyObject(@Nullable Object obj) {
        return obj instanceof DummyDbObject;
    }

    public SQLQueryDummyDataSourceContext(@NotNull SQLDialect dialect, @NotNull Set<String> knownColumnNames, @NotNull Set<List<String>> knownTableNames) {
        this.dialect = dialect;
        this.knownColumnNames = knownColumnNames;
        this.knownTableNames = new HashSet<String>();
        this.knownSchemaNames = new HashSet<String>();
        this.knownCatalogNames = new HashSet<String>();
        for (List<String> name : knownTableNames) {
            this.knownTableNames.add(name.get(name.size() - 1));
            if (name.size() <= 1) continue;
            this.knownSchemaNames.add(name.get(name.size() - 2));
            if (name.size() <= 2) continue;
            this.knownCatalogNames.add(name.get(name.size() - 3));
        }
        if (this.knownCatalogNames.isEmpty()) {
            this.knownCatalogNames.add("dummyCatalog");
        }
        if (this.knownSchemaNames.isEmpty()) {
            this.knownSchemaNames.add("dummySchema");
        }
        this.dummyDataSource = this.prepareDataSource();
        this.defaultDummyCatalog = this.dummyDataSource.getChildrenMapImpl().values().stream().findFirst().get();
        this.defaultDummySchema = this.defaultDummyCatalog.getChildrenMapImpl().values().stream().findFirst().get();
        this.defaultDummyTable = this.prepareTable(this.defaultDummySchema, "", -1);
    }

    private DummyDbObject prepareDataSource() {
        return new DummyDbObject(null, (DBPImage)DBIcon.TREE_FOLDER_DATABASE, "DummyDataSource", "Dummy data source for purposes of static query semantic analysis", 0, this.knownCatalogNames, this::prepareCatalog);
    }

    private DummyDbObject prepareCatalog(DummyDbObject parent, String name, int index) {
        return new DummyDbObject(parent, (DBPImage)DBIcon.TREE_DATABASE, name, "Dummy catalog for purposes of static query semantic analysis", index, this.knownSchemaNames, this::prepareSchema);
    }

    private DummyDbObject prepareSchema(DummyDbObject parent, String name, int index) {
        return new DummyDbObject(parent, (DBPImage)DBIcon.TREE_SCHEMA, name, "Dummy schema for purposes of static query semantic analysis", index, this.knownTableNames, this::prepareTable);
    }

    private DummyDbObject prepareTable(DummyDbObject parent, String name, int index) {
        return new DummyDbObject(parent, (DBPImage)DBIcon.TREE_TABLE, name, "Dummy table for purposes of static query semantic analysis", index, this.knownColumnNames, this::prepareColumn);
    }

    private DummyDbObject prepareColumn(DummyDbObject parent, String name, int index) {
        return new DummyDbObject(parent, (DBPImage)DBIcon.TYPE_STRING, name, "Dummy column for purposes of static query semantic analysis", index, Collections.emptySet(), null);
    }

    @Override
    @NotNull
    public List<SQLQueryResultColumn> getColumnsList() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasUnresolvedSource() {
        return false;
    }

    @Override
    @NotNull
    public List<SQLQueryResultPseudoColumn> getPseudoColumnsList() {
        return Collections.emptyList();
    }

    @Override
    public DBSEntity findRealTable(@NotNull DBRProgressMonitor monitor, @NotNull List<String> tableName) {
        List<String> rawTableName = tableName.stream().map(arg_0 -> ((SQLDialect)this.dialect).getUnquotedIdentifier(arg_0)).toList();
        DummyDbObject catalog = rawTableName.size() > 2 ? this.dummyDataSource.getChildrenMapImpl().get(rawTableName.get(rawTableName.size() - 3)) : this.defaultDummyCatalog;
        DummyDbObject schema = rawTableName.size() > 1 ? catalog.getChildrenMapImpl().get(rawTableName.get(rawTableName.size() - 2)) : this.defaultDummySchema;
        return (DBSEntity)schema.getChildrenMapImpl().get(rawTableName.get(rawTableName.size() - 1));
    }

    @Override
    public SQLQueryRowsSourceModel findRealSource(@NotNull DBSEntity table) {
        return null;
    }

    @Override
    @Nullable
    public DBSObject findRealObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectType objectType, @NotNull List<String> objectName) {
        return objectType.isCompatibleWith(RelationalObjectType.TYPE_TABLE) || objectType.isCompatibleWith(RelationalObjectType.TYPE_VIEW) ? this.findRealTable(monitor, objectName) : null;
    }

    @Override
    public SQLQueryResultColumn resolveColumn(@NotNull DBRProgressMonitor monitor, @NotNull String simpleName) {
        return null;
    }

    @Override
    @Nullable
    public SQLQueryResultPseudoColumn resolvePseudoColumn(DBRProgressMonitor monitor, @NotNull String name) {
        return null;
    }

    @Override
    @Nullable
    public SQLQueryResultPseudoColumn resolveGlobalPseudoColumn(DBRProgressMonitor monitor, @NotNull String name) {
        return null;
    }

    @Override
    @NotNull
    public SQLDialect getDialect() {
        return this.dialect;
    }

    @Override
    protected void collectKnownSourcesImpl(@NotNull SQLQueryDataContext.KnownSourcesInfo result) {
    }

    @Override
    protected List<SQLQueryResultPseudoColumn> prepareRowsetPseudoColumns(@NotNull SQLQueryRowsSourceModel source) {
        return Collections.emptyList();
    }

    private class DummyDbObject
    implements DBSEntityAttribute,
    DBSTable,
    DBSSchema,
    DBSCatalog,
    DBPDataSource,
    DBPImageProvider {
        private final DummyDbObject container;
        private final DBPImage image;
        private final String name;
        private final String description;
        private final int position;
        private final Set<String> childrenNames;
        private final DummyObjectCtor childCtor;
        private Map<String, DummyDbObject> childrenByName = null;
        private List<DummyDbObject> children = null;

        public DummyDbObject(@NotNull DummyDbObject container, @NotNull DBPImage image, @NotNull String name, String description, @NotNull int position, @Nullable Set<String> childrenNames, DummyObjectCtor childCtor) {
            this.container = container;
            this.image = image;
            this.name = name;
            this.description = description;
            this.position = position;
            this.childrenNames = childrenNames;
            this.childCtor = childCtor;
        }

        private Map<String, DummyDbObject> getChildrenMapImpl() {
            if (this.childrenByName == null) {
                if (this.childCtor == null) {
                    this.childrenByName = Collections.emptyMap();
                } else {
                    this.childrenByName = new HashMap<String, DummyDbObject>();
                    int i = 0;
                    for (String name : this.childrenNames) {
                        this.childrenByName.put(name, this.childCtor.apply(this, name, i++));
                    }
                }
            }
            return this.childrenByName;
        }

        private List<DummyDbObject> getChildrenListImpl() {
            return this.children != null ? this.children : (this.children = new ArrayList<DummyDbObject>(this.getChildrenMapImpl().values()));
        }

        @NotNull
        public DBSEntity getParentObject() {
            return this.container;
        }

        public DBPDataSource getDataSource() {
            return SQLQueryDummyDataSourceContext.this.dummyDataSource;
        }

        public DBPImage getObjectImage() {
            return this.image;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isPersisted() {
            return true;
        }

        public int getOrdinalPosition() {
            return this.position;
        }

        public boolean isRequired() {
            return true;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        @NotNull
        public String getTypeName() {
            return null;
        }

        @NotNull
        public String getFullTypeName() {
            return null;
        }

        public int getTypeID() {
            return 0;
        }

        @NotNull
        public DBPDataKind getDataKind() {
            return DBPDataKind.STRING;
        }

        public Integer getScale() {
            return null;
        }

        @Nullable
        public Integer getPrecision() {
            return null;
        }

        public long getMaxLength() {
            return 0L;
        }

        public long getTypeModifiers() {
            return 0L;
        }

        public String getDefaultValue() {
            return null;
        }

        @NotNull
        public DBSEntityType getEntityType() {
            return DBSEntityType.TABLE;
        }

        public List<? extends DBSEntityAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
            return this.getChildrenListImpl();
        }

        public DBSEntityAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
            return this.getChildrenMapImpl().get(attributeName);
        }

        public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
            return Collections.emptyList();
        }

        public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
            return null;
        }

        @NotNull
        public String getFullyQualifiedName(DBPEvaluationContext context) {
            if (this.container == SQLQueryDummyDataSourceContext.this.defaultDummySchema || this.container == SQLQueryDummyDataSourceContext.this.defaultDummyCatalog || this.container == SQLQueryDummyDataSourceContext.this.dummyDataSource) {
                return this.name;
            }
            return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.container, this});
        }

        public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
            return this.getChildrenListImpl();
        }

        public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
            return (DBSObject)this.getChildrenMapImpl().get(childName);
        }

        @NotNull
        public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
            return DummyDbObject.class;
        }

        public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        }

        @Nullable
        public DBSInstance getDefaultInstance() {
            return null;
        }

        @NotNull
        public Collection<? extends DBSInstance> getAvailableInstances() {
            return Collections.emptyList();
        }

        public void shutdown(@NotNull DBRProgressMonitor monitor) {
        }

        public Map<String, ?> getContextAttributes() {
            return Collections.emptyMap();
        }

        public <T> T getContextAttribute(String attributeName) {
            return null;
        }

        public <T> void setContextAttribute(String attributeName, T attributeValue) {
        }

        public void removeContextAttribute(String attributeName) {
        }

        @NotNull
        public DBPDataSourceContainer getContainer() {
            return null;
        }

        @NotNull
        public DBPDataSourceInfo getInfo() {
            return null;
        }

        public Object getDataSourceFeature(String featureId) {
            return null;
        }

        @NotNull
        public SQLDialect getSQLDialect() {
            return SQLQueryDummyDataSourceContext.this.dialect;
        }

        public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        }

        public boolean isView() {
            return false;
        }

        public Collection<? extends DBSTableIndex> getIndexes(@NotNull DBRProgressMonitor monitor) throws DBException {
            return Collections.emptyList();
        }

        public Collection<? extends DBSTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
            return Collections.emptyList();
        }

        public List<? extends DBSTrigger> getTriggers(@NotNull DBRProgressMonitor monitor) throws DBException {
            return Collections.emptyList();
        }
    }

    @FunctionalInterface
    private static interface DummyObjectCtor {
        public DummyDbObject apply(DummyDbObject var1, String var2, int var3);
    }

    public class DummyTableRowsSource
    extends SQLQueryRowsTableDataModel {
        public DummyTableRowsSource(STMTreeNode syntaxNode) {
            super(syntaxNode, new SQLQueryQualifiedName(syntaxNode, Collections.emptyList(), new SQLQuerySymbolEntry(syntaxNode, "DummyTable", "DummyTable", null), 0, null), false);
        }

        @Override
        @NotNull
        public SQLQuerySymbolClass getSymbolClass() {
            return SQLQuerySymbolClass.TABLE;
        }

        @Override
        @NotNull
        protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
            try {
                List<? extends DBSEntityAttribute> attributes = SQLQueryDummyDataSourceContext.this.defaultDummyTable.getAttributes(statistics.getMonitor());
                if (attributes != null) {
                    context = context.overrideResultTuple(this, this.prepareResultColumnsList(this.getName().entityName, context, statistics, attributes));
                }
            }
            catch (DBException ex) {
                statistics.appendError(this.getName().entityName, "Failed to resolve table " + this.getName().toIdentifierString(), ex);
            }
            return context;
        }

        @Override
        protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T node) {
            return visitor.visitDummyTableRowsSource(this, node);
        }
    }
}

