/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.ddl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;

public class SQLQueryObjectDataModel
extends SQLQueryRowsSourceModel
implements SQLQuerySymbolDefinition {
    private static final Log log = Log.getLog(SQLQueryObjectDataModel.class);
    @NotNull
    private final SQLQueryQualifiedName name;
    @NotNull
    private DBSObjectType objectType;
    @NotNull
    private Set<DBSObjectType> objectContainerTypes;
    @Nullable
    private DBSObject object = null;
    private SQLQuerySymbolOrigin objectNameOrigin = null;

    public SQLQueryObjectDataModel(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryQualifiedName name, @NotNull DBSObjectType objectTypes, @NotNull Set<DBSObjectType> objectContainerTypes) {
        super(syntaxNode, new SQLQueryNodeModel[0]);
        this.name = name;
        this.objectType = objectTypes;
        this.objectContainerTypes = objectContainerTypes;
    }

    @NotNull
    public DBSObjectType getObjectType() {
        return this.objectType;
    }

    @NotNull
    public SQLQueryQualifiedName getName() {
        return this.name;
    }

    @Nullable
    public DBSObject getObject() {
        return this.object;
    }

    @Nullable
    public SQLQuerySymbolOrigin getObjectNameOrigin() {
        return this.objectNameOrigin;
    }

    @Override
    @NotNull
    public SQLQuerySymbolClass getSymbolClass() {
        return this.object instanceof DBSTable || this.object instanceof DBSView ? SQLQuerySymbolClass.TABLE : (this.object != null ? SQLQuerySymbolClass.OBJECT : SQLQuerySymbolClass.ERROR);
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        HashSet<DBSObjectType> scopeMemberTypes = new HashSet<DBSObjectType>();
        scopeMemberTypes.addAll(this.objectContainerTypes);
        scopeMemberTypes.add(this.objectType);
        this.objectNameOrigin = new SQLQuerySymbolOrigin.DbObjectFromContext(context, scopeMemberTypes, false);
        if (this.name.isNotClassified()) {
            List<String> nameStrings = this.name.toListOfStrings();
            this.object = context.findRealObject(statistics.getMonitor(), this.objectType, nameStrings);
            if (this.object != null) {
                this.name.setDefinition(this.object, this.objectNameOrigin);
                if (!this.objectType.getTypeClass().isAssignableFrom(this.object.getClass())) {
                    statistics.appendError(this.getSyntaxNode(), DBUtils.getObjectTypeName((DBSObject)this.object) + " found while expecting " + this.objectType.getTypeName());
                }
            } else {
                SQLQueryQualifiedName.performPartialResolution(context, statistics, this.name, this.objectNameOrigin, scopeMemberTypes, SQLQuerySymbolClass.ERROR);
                statistics.appendError(this.getSyntaxNode(), "Object " + this.name.toIdentifierString() + " not found in the database");
            }
        }
        return context;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitObjectReference(this, arg);
    }
}

