/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.expressions;

import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryMemberAccessEntry;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueColumnReferenceExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryValueMemberExpression
extends SQLQueryValueExpression {
    private static final Log log = Log.getLog(SQLQueryValueMemberExpression.class);
    @NotNull
    private final SQLQueryValueExpression owner;
    @Nullable
    private final SQLQuerySymbolEntry identifier;
    @Nullable
    private final SQLQueryMemberAccessEntry memberAccessEntry;

    public SQLQueryValueMemberExpression(@NotNull Interval range, @NotNull STMTreeNode syntaxNode, @NotNull SQLQueryValueExpression owner, @Nullable SQLQuerySymbolEntry identifier, @Nullable SQLQueryMemberAccessEntry memberAccessEntry) {
        super(range, syntaxNode, owner);
        this.owner = owner;
        this.identifier = identifier;
        this.memberAccessEntry = memberAccessEntry;
    }

    @NotNull
    public SQLQueryValueExpression getMemberOwner() {
        return this.owner;
    }

    @Nullable
    public SQLQuerySymbolEntry getMemberIdentifier() {
        return this.identifier;
    }

    @Override
    @Nullable
    public SQLQuerySymbol getColumnNameIfTrivialExpression() {
        return this.identifier == null ? null : this.identifier.getSymbol();
    }

    @Override
    protected void propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        this.owner.propagateContext(context, statistics);
        SQLQuerySymbolOrigin.MemberOfType memberOrigin = new SQLQuerySymbolOrigin.MemberOfType(this.owner.getValueType());
        if (this.identifier == null) {
            this.type = SQLQueryExprType.UNKNOWN;
            if (this.memberAccessEntry != null) {
                SQLQuerySymbolDefinition sQLQuerySymbolDefinition;
                SQLQueryValueColumnReferenceExpression c;
                SQLQueryValueExpression sQLQueryValueExpression = this.owner;
                if (sQLQueryValueExpression instanceof SQLQueryValueColumnReferenceExpression && (c = (SQLQueryValueColumnReferenceExpression)sQLQueryValueExpression).getColumnName() != null && (sQLQuerySymbolDefinition = c.getColumnName().getDefinition()) instanceof SQLQuerySymbolByDbObjectDefinition) {
                    SQLQuerySymbolByDbObjectDefinition dbObj = (SQLQuerySymbolByDbObjectDefinition)sQLQuerySymbolDefinition;
                    this.memberAccessEntry.setOrigin(new SQLQuerySymbolOrigin.DbObjectFromDbObject(dbObj.getDbObject(), RelationalObjectType.TYPE_UNKNOWN));
                } else {
                    this.memberAccessEntry.setOrigin(memberOrigin);
                }
            }
        } else if (this.identifier.isNotClassified()) {
            SQLQueryExprType type = SQLQueryValueMemberExpression.tryResolveMemberReference(statistics, this.owner.getValueType(), this.identifier, memberOrigin);
            this.type = type != null ? type : SQLQueryExprType.UNKNOWN;
        }
    }

    @Nullable
    public static SQLQueryExprType tryResolveMemberReference(@NotNull SQLQueryRecognitionContext statistics, @NotNull SQLQueryExprType valueType, @NotNull SQLQuerySymbolEntry identifier, @NotNull SQLQuerySymbolOrigin memberOrigin) {
        SQLQueryExprType type;
        identifier.setOrigin(memberOrigin);
        try {
            type = valueType.findNamedMemberType(statistics.getMonitor(), identifier.getName());
            if (type != null) {
                identifier.setDefinition(type.getDeclaratorDefinition());
            } else {
                identifier.getSymbol().setSymbolClass(SQLQuerySymbolClass.ERROR);
                statistics.appendError(identifier, "Failed to resolve member reference " + identifier.getName() + " for " + valueType.getDisplayName());
            }
        }
        catch (DBException e) {
            log.debug((Object)e);
            statistics.appendError(identifier, "Failed to resolve member reference " + identifier.getName() + " for " + valueType.getDisplayName(), e);
            type = null;
        }
        return type;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitValueMemberReferenceExpr(this, arg);
    }

    public String toString() {
        return "ValueMember[(" + String.valueOf(this.owner) + ")." + (this.identifier == null ? "<NULL>" : this.identifier.getName()) + ":" + String.valueOf(this.type) + "]";
    }
}

