/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryTupleRefEntry;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueTupleReferenceExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsProjectionModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQuerySelectionResultColumnSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQuerySelectionResultCompleteTupleSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQuerySelectionResultSublistSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQuerySelectionResultTupleSpec;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQuerySelectionResultModel
extends SQLQueryNodeModel {
    @NotNull
    private final List<SQLQuerySelectionResultSublistSpec> sublists;
    @Nullable
    private SQLQueryDataContext dataContext = null;

    public SQLQuerySelectionResultModel(@NotNull STMTreeNode syntaxNode, int capacity) {
        super(syntaxNode.getRealInterval(), syntaxNode, new SQLQueryNodeModel[0]);
        this.sublists = new ArrayList<SQLQuerySelectionResultSublistSpec>(capacity);
    }

    @NotNull
    public List<SQLQuerySelectionResultSublistSpec> getSublists() {
        return this.sublists;
    }

    @Override
    @Nullable
    public SQLQueryDataContext getGivenDataContext() {
        return this.dataContext;
    }

    @Override
    @Nullable
    public SQLQueryDataContext getResultDataContext() {
        return this.dataContext;
    }

    private void registerSublist(SQLQuerySelectionResultSublistSpec sublist) {
        this.sublists.add(sublist);
        super.registerSubnode(sublist);
    }

    public void addColumnSpec(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryValueExpression valueExpression) {
        this.registerSublist(new SQLQuerySelectionResultColumnSpec(this, syntaxNode, valueExpression));
    }

    public void addColumnSpec(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryValueExpression valueExpression, @Nullable SQLQuerySymbolEntry alias) {
        this.registerSublist(new SQLQuerySelectionResultColumnSpec(this, syntaxNode, valueExpression, alias));
    }

    public void addTupleSpec(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryValueTupleReferenceExpression tupleRef) {
        this.registerSublist(new SQLQuerySelectionResultTupleSpec(this, syntaxNode, tupleRef));
    }

    public void addCompleteTupleSpec(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryTupleRefEntry tupleRefEntry) {
        this.registerSublist(new SQLQuerySelectionResultCompleteTupleSpec(this, syntaxNode, tupleRefEntry));
    }

    @NotNull
    public List<SQLQueryResultColumn> expandColumns(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRowsProjectionModel rowsSourceModel, @NotNull SQLQueryRecognitionContext statistics) {
        this.dataContext = context;
        LinkedList<SQLQueryResultColumn> resultColumns = new LinkedList<SQLQueryResultColumn>();
        for (SQLQuerySelectionResultSublistSpec sublist : this.sublists) {
            sublist.collectColumns(context, rowsSourceModel, statistics, resultColumns);
        }
        return List.copyOf(resultColumns);
    }

    @Override
    @Nullable
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T node) {
        return visitor.visitSelectionResult(this, node);
    }
}

