/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.DB2Messages;
import org.jkiss.dbeaver.ext.db2.DB2Utils;
import org.jkiss.dbeaver.ext.db2.editors.DB2DDLFormat;
import org.jkiss.dbeaver.ext.db2.editors.DB2SourceObject;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Object;
import org.jkiss.dbeaver.ext.db2.model.DB2RoutineParm;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2RoutineParmsCache;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2OwnerType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2RoutineLanguage;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2RoutineOrigin;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2RoutineType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2RoutineValidType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2YesNo;
import org.jkiss.dbeaver.ext.db2.model.module.DB2Module;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class DB2Routine
extends DB2Object<DBSObject>
implements DBSProcedure,
DB2SourceObject,
DBPRefreshableObject,
DBPImageProvider {
    private final DB2RoutineParmsCache parmsCache = new DB2RoutineParmsCache();
    private String fullyQualifiedName;
    private DB2Schema db2Schema;
    private DB2RoutineType type;
    @Nullable
    private String specificName;
    private Integer routineId;
    private DB2RoutineOrigin origin;
    private DB2RoutineLanguage language;
    private String dialect;
    private String owner;
    private DB2OwnerType ownerType;
    private String text;
    private String remarks;
    private Timestamp createTime;
    private Timestamp alterTime;
    private Timestamp lastRegenTime;
    private Integer resultSets;
    private String parameterStyle;
    private Boolean deterministic;
    private String externalName;
    private String debugMode;
    private String jarId;
    private String jarSchema;
    private String jarSignature;
    private String javaClass;
    private DB2RoutineValidType valid;
    private FunctionType functionType;

    public DB2Routine(DBSObject owner, ResultSet dbResult) {
        super(owner, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROUTINENAME"), true);
        DB2DataSource db2DataSource = (DB2DataSource)owner.getDataSource();
        this.specificName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SPECIFICNAME");
        this.routineId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"ROUTINEID");
        this.type = (DB2RoutineType)CommonUtils.valueOf(DB2RoutineType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROUTINETYPE"));
        this.origin = (DB2RoutineOrigin)CommonUtils.valueOf(DB2RoutineOrigin.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ORIGIN"));
        this.language = (DB2RoutineLanguage)CommonUtils.valueOf(DB2RoutineLanguage.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"LANGUAGE"));
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.alterTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"ALTER_TIME");
        this.lastRegenTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_REGEN_TIME");
        this.text = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TEXT");
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        this.resultSets = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"RESULT_SETS");
        this.parameterStyle = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARAMETER_STYLE");
        this.deterministic = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"DETERMINISTIC", (String)DB2YesNo.Y.name());
        this.externalName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"IMPLEMENTATION");
        this.debugMode = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEBUG_MODE");
        this.jarId = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"JAR_ID");
        this.jarSchema = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"JARSCHEMA");
        this.jarSignature = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"JAR_SIGNATURE");
        this.javaClass = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CLASS");
        this.valid = (DB2RoutineValidType)CommonUtils.valueOf(DB2RoutineValidType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VALID"));
        if (db2DataSource.isAtLeastV9_5()) {
            this.ownerType = (DB2OwnerType)CommonUtils.valueOf(DB2OwnerType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNERTYPE"));
        }
        if (db2DataSource.isAtLeastV9_7()) {
            this.dialect = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DIALECT");
            if (this.type == DB2RoutineType.F) {
                this.functionType = (FunctionType)CommonUtils.valueOf(FunctionType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FUNCTIONTYPE"));
            }
        }
        this.db2Schema = owner instanceof DB2Schema ? (DB2Schema)owner : ((DB2Module)owner).getSchema();
        this.fullyQualifiedName = DBUtils.getFullQualifiedName((DBPDataSource)db2DataSource, (DBPNamedObject[])new DBPNamedObject[]{owner, this});
    }

    public DB2RoutineType getType() {
        return this.type;
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.valid == DB2RoutineValidType.Y ? DBSObjectState.NORMAL : DBSObjectState.UNKNOWN;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.parmsCache.clearCache();
        return this;
    }

    @Property(viewable=true, order=7)
    public DBSProcedureType getProcedureType() {
        return this.type.getProcedureType();
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return this.fullyQualifiedName;
    }

    public DBSObjectContainer getContainer() {
        if (this.parent instanceof DBSObjectContainer) {
            return (DBSObjectContainer)this.parent;
        }
        return this.db2Schema;
    }

    @Nullable
    public Collection<DB2RoutineParm> getParameters(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.parmsCache.getAllObjects(monitor, this);
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.language != null && this.language.equals((Object)DB2RoutineLanguage.SQL)) {
            if (DB2DDLFormat.getCurrentFormat(this.getDataSource()).needsFormatting()) {
                return DB2Utils.formatSQLProcedureDDL(this.getDataSource(), this.text);
            }
            return this.text;
        }
        return DB2Messages.no_ddl_for_nonsql_routines;
    }

    @Override
    @Property(viewable=true, order=2)
    public DB2Schema getSchema() {
        return this.db2Schema;
    }

    @Property(viewable=true, order=3)
    @Nullable
    public String getSpecificName() {
        return this.specificName;
    }

    @Property(viewable=true, order=5, category="Date & Time")
    public DB2RoutineLanguage getLanguage() {
        return this.language;
    }

    @Property(viewable=true, order=6)
    public Integer getRoutineId() {
        return this.routineId;
    }

    @Property(viewable=false, order=10)
    public DB2RoutineValidType getValid() {
        return this.valid;
    }

    @Property(viewable=false, order=11, category="Code")
    public String getDialect() {
        return this.dialect;
    }

    @Property(viewable=false, order=12, category="Code")
    public String getParameterStyle() {
        return this.parameterStyle;
    }

    @Property(viewable=false, order=13, category="Code")
    public Boolean getDeterministic() {
        return this.deterministic;
    }

    @Property(viewable=false, order=14, category="Code")
    public Integer getResultSets() {
        return this.resultSets;
    }

    @Property(viewable=false, order=15, category="Code")
    public String getDebugMode() {
        return this.debugMode;
    }

    @Property(viewable=false, order=20, category="Code")
    public DB2RoutineOrigin getOrigin() {
        return this.origin;
    }

    @Property(viewable=false, order=21, category="Code")
    public String getExternalName() {
        return this.externalName;
    }

    @Property(viewable=false, order=22, category="Code")
    public String getJavaClass() {
        return this.javaClass;
    }

    @Property(viewable=false, order=23, category="Code")
    public String getJarId() {
        return this.jarId;
    }

    @Property(viewable=false, order=24, category="Code")
    public String getJarSchema() {
        return this.jarSchema;
    }

    @Property(viewable=false, order=25, category="Code")
    public String getJarSignature() {
        return this.jarSignature;
    }

    @Property(viewable=false, category="Date & Time")
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=false, category="Date & Time")
    public Timestamp getAlterTime() {
        return this.alterTime;
    }

    @Property(viewable=false, category="Date & Time")
    public Timestamp getLastRegenTime() {
        return this.lastRegenTime;
    }

    @Property(viewable=false, category="Owner")
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=false, category="Owner")
    public DB2OwnerType getOwnerType() {
        return this.ownerType;
    }

    @Override
    @Property(viewable=false, length=PropertyLength.MULTILINE)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    public FunctionType getFunctionType() {
        return this.functionType;
    }

    @Nullable
    public DBPImage getObjectImage() {
        if (this.type == DB2RoutineType.F) {
            return DBIcon.TREE_FUNCTION;
        }
        return DBIcon.TREE_PROCEDURE;
    }

    public static enum FunctionType {
        C("Column or aggregate"),
        R("Row"),
        S("Scalar"),
        T("Table");


        private FunctionType(String type) {
        }
    }
}

