/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.snowflake.model;

import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLDollarQuoteRule;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLMultiWordRule;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPRuleProvider;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.dbeaver.model.text.parser.TPTokenType;
import org.jkiss.utils.CommonUtils;

public class SnowflakeSQLDialect
extends GenericSQLDialect
implements TPRuleProvider {
    private static final String[][] SNOWFLAKE_BEGIN_END_BLOCK = new String[][]{{"BEGIN", "END"}, {"IF", "END"}};
    private static final String[] SNOWFLAKE_NUMERIC_FUNCTIONS = new String[]{"ABS", "ACOS", "ACOSH", "ASIN", "ASINH", "ATAN", "ATAN2", "ATANH", "CBRT", "CEIL", "COS", "COSH", "COT", "DEGREES", "EXP", "FACTORIAL", "FLOOR", "LN", "LOG", "MOD", "PI", "RADIANS", "ROUND", "SIGN", "SIN", "SINH", "SQRT", "TAN", "TANH", "WIDTH_BUCKET"};
    private static final String[] SNOWFLAKE_DATE_AND_TIME_FUNCTIONS = new String[]{"ADD_MONTHS", "DATE_PART", "DATE_TRUNC", "DATEADD", "DATEDIFF", "DAYNAME", "EXTRACT", "LAST_DAY", "MONTHNAME", "MONTHS_BETWEEN", "NEXT_DAY", "TIMEDIFF", "TIMESTAMPADD", "TIMESTAMPDIFF", "TRUNC"};
    private static final String[] SNOWFLAKE_CONTEXT_FUNCTIONS = new String[]{"CURRENT_DATABASE", "CURRENT_DATE", "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURRENT_VERSION", "SYSDATE"};
    private static final String[] SNOWFLAKE_AGGREGATE_AND_WINDOW_FUNCTIONS = new String[]{"ANY_VALUE", "APPROX_COUNT_DISTINCT", "APPROX_PERCENTILE", "APPROX_TOP_K", "AVG", "CORR", "COUNT", "COUNT_IF", "COVAR_POP", "COVAR_SAMP", "KURTOSIS", "LISTAGG", "MAX", "MEDIAN", "MIN", "MODE", "PERCENTILE_CONT", "PERCENTILE_DISC", "REGR_AVGX", "REGR_AVGY", "REGR_COUNT", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXX", "REGR_SXY", "REGR_SYY", "STDDEV", "STDDEV_POP", "STDDEV_SAMP", "SUM", "VAR_POP", "VAR_SAMP", "ARRAY_AGG", "GROUPING", "GROUPING_ID", "MAX_BY", "MIN_BY", "CUME_DIST", "DENSE_RANK", "FIRST_VALUE", "LAG", "LAST_VALUE", "LEAD", "NTH_VALUE", "NTILE", "PERCENT_RANK", "RANK", "RATIO_TO_REPORT", "ROW_NUMBER"};
    private static final String[] SNOWFLAKE_STRUCTURED_DATA_FUNCTIONS = new String[]{"ARRAY_CONTAINS", "ARRAY_DISTINCT", "ARRAY_EXCEPT", "ARRAY_MAX", "ARRAY_MIN", "ARRAY_POSITION", "ARRAY_REMOVE", "ARRAY_SIZE", "ARRAY_SORT", "ARRAYS_OVERLAP", "GET", "IS_BOOLEAN", "MAP_CONTAINS_KEY", "MAP_KEYS", "TYPEOF"};
    private static final String[] SNOWFLAKE_STRING_AND_BINARY_FUNCTIONS = new String[]{"ASCII", "BASE64_ENCODE", "BIT_LENGTH", "CHARINDEX", "COLLATION", "COMPRESS", "CONCAT_WS", "CONTAINS", "ENDSWITH", "HEX_ENCODE", "INITCAP", "INSERT", "LEFT", "LOWER", "LPAD", "LTRIM", "OCTET_LENGTH", "PARSE_URL", "POSITION", "REPEAT", "REPLACE", "REVERSE", "RIGHT", "RPAD", "RTRIM", "SOUNDEX", "SPACE", "SPLIT", "SPLIT_PART", "STARTSWITH", "TRANSLATE", "TRIM", "UNICODE", "UPPER", "REGEXP", "REGEXP_COUNT", "REGEXP_INSTR", "REGEXP_LIKE", "REGEXP_REPLACE", "REGEXP_SUBSTR", "RLIKE"};
    private static final String[] SNOWFLAKE_CONDITIONAL_FUNCTIONS = new String[]{"COALESCE", "DECODE", "EQUAL_NULL", "GREATEST", "IFF", "IFNULL", "LEAST", "NULLIF", "NULLIFZERO", "NVL", "NVL2", "ZEROIFNULL"};
    private static final String[] SNOWFLAKE_BITWISE_FUNCTIONS = new String[]{"BITAND", "BITNOT", "BITOR", "BITXOR", "GETBIT"};
    private static final String[] SNOWFLAKE_CONVERSION_FUNCTIONS = new String[]{"TO_BINARY", "TO_BOOLEAN", "TO_DOUBLE", "TRY_CAST", "TRY_TO_BINARY"};
    private static final String[] SNOWFLAKE_GEOSPATIAL_FUNCTIONS = new String[]{"ST_BUFFER", "ST_CENTROID", "ST_CONTAINS", "ST_DIFFERENCE", "ST_DIMENSION", "ST_DISJOINT", "ST_DISTANCE", "ST_ENDPOINT", "ST_ENVELOPE", "ST_LENGTH", "ST_POINTN", "ST_SETSRID", "ST_STARTPOINT", "ST_SYMDIFFERENCE", "ST_TRANSFORM", "ST_UNION", "ST_WITHIN", "ST_X", "ST_Y"};
    private static final String[] SNOWFLAKE_OTHER_FUNCTIONS = new String[]{"ENCRYPT", "FLATTEN", "HASH", "RANDOM", "TO_JSON"};

    public SnowflakeSQLDialect() {
        super("Snowflake", "snowflake");
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        this.addSQLKeywords(Arrays.asList("QUALIFY", "ILIKE", "PACKAGE", "PIPE", "STAGE", "STREAM", "TAG", "TASK"));
        this.removeSQLKeyword("VIEWS");
        this.addFunctions(Arrays.asList(SNOWFLAKE_AGGREGATE_AND_WINDOW_FUNCTIONS));
        this.addFunctions(Arrays.asList(SNOWFLAKE_BITWISE_FUNCTIONS));
        this.addFunctions(Arrays.asList(SNOWFLAKE_CONDITIONAL_FUNCTIONS));
        this.addFunctions(Arrays.asList(SNOWFLAKE_CONTEXT_FUNCTIONS));
        this.addFunctions(Arrays.asList(SNOWFLAKE_CONVERSION_FUNCTIONS));
        this.addFunctions(Arrays.asList(SNOWFLAKE_NUMERIC_FUNCTIONS));
        this.addFunctions(Arrays.asList(SNOWFLAKE_STRING_AND_BINARY_FUNCTIONS));
        this.addFunctions(Arrays.asList(SNOWFLAKE_STRUCTURED_DATA_FUNCTIONS));
        this.addFunctions(Arrays.asList(SNOWFLAKE_GEOSPATIAL_FUNCTIONS));
        this.addFunctions(Arrays.asList(SNOWFLAKE_DATE_AND_TIME_FUNCTIONS));
        this.addFunctions(Arrays.asList(SNOWFLAKE_OTHER_FUNCTIONS));
    }

    @NotNull
    public TPRule[] extendRules(@Nullable DBPDataSourceContainer dataSource, @NotNull TPRuleProvider.RulePosition position) {
        if (position == TPRuleProvider.RulePosition.INITIAL || position == TPRuleProvider.RulePosition.PARTITION) {
            boolean useDollarQuoteRule = dataSource == null || CommonUtils.getBoolean((String)dataSource.getConnectionConfiguration().getProviderProperty("ddString"), (boolean)dataSource.getPreferenceStore().getBoolean("ddString"));
            return new TPRule[]{new SQLDollarQuoteRule(position == TPRuleProvider.RulePosition.PARTITION, false, false, useDollarQuoteRule)};
        }
        if (position == TPRuleProvider.RulePosition.KEYWORDS) {
            TPTokenDefault keywordToken = new TPTokenDefault((TPTokenType)SQLTokenType.T_KEYWORD);
            return new TPRule[]{new SQLMultiWordRule(new String[]{"BEGIN", "TRANSACTION"}, (TPToken)keywordToken), new SQLMultiWordRule(new String[]{"IF", "EXISTS"}, (TPToken)keywordToken), new SQLMultiWordRule(new String[]{"IF", "NOT", "EXISTS"}, (TPToken)keywordToken)};
        }
        return new TPRule[0];
    }

    public String[][] getBlockBoundStrings() {
        return SNOWFLAKE_BEGIN_END_BLOCK;
    }

    @NotNull
    public String getSearchStringEscape() {
        return "\\";
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getDefaultMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
    }

    public String getColumnTypeModifiers(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        switch (typeName) {
            case "DECIMAL": 
            case "NUMBER": 
            case "NUMERIC": {
                DBSDataType dataType = DBUtils.getDataType((DBSTypedObject)column);
                Integer scale = column.getScale();
                int precision = CommonUtils.toInt((Object)column.getPrecision());
                if (precision == 0 && dataType != null && scale != null && scale.intValue() == dataType.getMinScale()) {
                    return "";
                }
                if (precision == 0 || precision > 38) {
                    precision = 38;
                }
                if (scale == null && precision <= 0) break;
                return "(" + (precision > 0 ? precision : 38) + (String)(scale != null && scale > 0 ? "," + String.valueOf(scale) : "") + ")";
            }
            case "INTEGER": 
            case "INT": 
            case "REAL": 
            case "FLOAT": 
            case "DOUBLE PRECISION": 
            case "BIGINT": 
            case "DOUBLE": {
                return null;
            }
        }
        return super.getColumnTypeModifiers(dataSource, column, typeName, dataKind);
    }

    public boolean validIdentifierStart(char c) {
        return SQLUtils.isLatinLetter((int)c) || c == '_';
    }

    public boolean validIdentifierPart(char c, boolean quoted) {
        return SQLUtils.isLatinLetter((int)c) || Character.isDigit(c) || c == '_' || quoted && this.validCharacters.indexOf(c) != -1 || c == '$';
    }

    public boolean mustBeQuoted(@NotNull String str, boolean forceCaseSensitive) {
        if (str.isBlank()) {
            return true;
        }
        return super.mustBeQuoted(str, forceCaseSensitive);
    }

    public String[] getSingleLineComments() {
        return new String[]{"--", "//"};
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public boolean isEscapeBackslash() {
        return true;
    }
}

