/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.controls;

import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferEventProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.ui.IDataTransferEventProcessorConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class EventProcessorComposite<T extends IDataTransferConsumerSettings>
extends Composite {
    private final Runnable propertyChangeListener;
    private final DataTransferEventProcessorDescriptor descriptor;
    private final IDataTransferEventProcessorConfigurator<T> configurator;
    private final T settings;
    private final Button enabledCheckbox;
    private Link configureLink;
    private Map<String, Object> rawSettings;

    public EventProcessorComposite(final @NotNull Runnable propertyChangeListener, @NotNull Composite parent, @NotNull T settings, @NotNull DataTransferEventProcessorDescriptor descriptor, final @Nullable IDataTransferEventProcessorConfigurator<T> configurator) {
        super(parent, 0);
        this.propertyChangeListener = propertyChangeListener;
        this.descriptor = descriptor;
        this.configurator = configurator;
        this.settings = settings;
        boolean hasControl = configurator != null && configurator.hasControl();
        this.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(hasControl ? 2 : 1).create());
        this.enabledCheckbox = UIUtils.createCheckbox((Composite)this, (String)descriptor.getLabel(), (String)descriptor.getDescription(), (boolean)false, (int)1);
        this.enabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventProcessorComposite.this.setProcessorEnabled(EventProcessorComposite.this.enabledCheckbox.getSelection());
            }
        });
        if (hasControl) {
            this.configureLink = UIUtils.createLink((Composite)this, (String)DTMessages.data_transfer_wizard_output_event_processor_configure, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConfigureDialog dialog;
                    if (EventProcessorComposite.this.rawSettings != null) {
                        configurator.loadSettings(EventProcessorComposite.this.rawSettings);
                        EventProcessorComposite.this.rawSettings = null;
                    }
                    if ((dialog = new ConfigureDialog(EventProcessorComposite.this.getShell())).open() == 0) {
                        propertyChangeListener.run();
                    }
                }
            });
        }
    }

    public void loadSettings(@NotNull Map<String, Object> settings) {
        if (this.isProcessorEnabled()) {
            this.configurator.loadSettings(settings);
        } else {
            this.rawSettings = settings;
        }
    }

    public void saveSettings(@NotNull Map<String, Object> settings) {
        this.configurator.saveSettings(settings);
    }

    public boolean isProcessorEnabled() {
        return this.enabledCheckbox.getEnabled() && this.enabledCheckbox.getSelection();
    }

    public boolean isProcessorApplicable() {
        return this.configurator != null && this.configurator.isApplicable(this.settings);
    }

    public boolean isProcessorComplete() {
        return this.configurator.isComplete();
    }

    @NotNull
    public DataTransferEventProcessorDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setProcessorAvailable(boolean available) {
        this.setProcessorEnabled(this.enabledCheckbox.getSelection(), available);
    }

    public void setProcessorEnabled(boolean enabled) {
        this.setProcessorEnabled(enabled, this.enabledCheckbox.getEnabled());
    }

    private void setProcessorEnabled(boolean enabled, boolean available) {
        this.enabledCheckbox.setSelection(enabled);
        this.enabledCheckbox.setEnabled(available);
        if (this.configurator.hasControl()) {
            this.configureLink.setEnabled(enabled && available);
        }
        if (enabled && available) {
            this.settings.addEventProcessor(this.descriptor);
        } else {
            this.settings.removeEventProcessor(this.descriptor);
        }
        this.propertyChangeListener.run();
    }

    private class ConfigureDialog
    extends BaseDialog {
        public ConfigureDialog(Shell shell) {
            super(shell, NLS.bind((String)DTMessages.data_transfer_wizard_output_event_processor_configure_title, (Object)EventProcessorComposite.this.descriptor.getLabel()), null);
            this.setShellStyle(67696);
        }

        protected Composite createDialogArea(Composite parent) {
            Composite composite = super.createDialogArea(parent);
            EventProcessorComposite.this.configurator.createControl(composite, EventProcessorComposite.this.settings, this::updateCompletion);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.updateCompletion();
        }

        private void updateCompletion() {
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(EventProcessorComposite.this.configurator.isComplete());
            }
        }
    }
}

