/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleGrantee;
import org.jkiss.dbeaver.ext.oracle.model.OraclePrivRole;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablespace;
import org.jkiss.dbeaver.ext.oracle.model.OracleUserProfile;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;

public class OracleUser
extends OracleGrantee
implements DBAUser,
DBSObjectLazy<OracleDataSource>,
DBPSaveableObject,
DBPRefreshableObject {
    private static final Log log = Log.getLog(OracleUser.class);
    private long id;
    private String name;
    private String externalName;
    private String status;
    private Timestamp createDate;
    private Timestamp lockDate;
    private Timestamp expiryDate;
    private Object defaultTablespace;
    private Object tempTablespace;
    private Object profile;
    private String consumerGroup;
    protected transient String password;
    protected transient String confirmPassword;
    private boolean persisted;

    public OracleUser(OracleDataSource dataSource) {
        super(dataSource);
    }

    public OracleUser(OracleDataSource dataSource, ResultSet resultSet) {
        super(dataSource);
        if (resultSet != null) {
            this.id = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"USER_ID");
            this.name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"USERNAME");
            this.externalName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"EXTERNAL_NAME");
            this.status = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"ACCOUNT_STATUS");
            this.createDate = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CREATED");
            this.lockDate = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"LOCK_DATE");
            this.expiryDate = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"EXPIRY_DATE");
            this.defaultTablespace = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"DEFAULT_TABLESPACE");
            this.tempTablespace = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TEMPORARY_TABLESPACE");
            this.profile = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PROFILE");
            this.consumerGroup = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"INITIAL_RSRC_CONSUMER_GROUP");
            this.persisted = true;
        } else {
            this.persisted = false;
        }
    }

    @Property(order=1)
    public long getId() {
        return this.id;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Property(order=3)
    public String getExternalName() {
        return this.externalName;
    }

    @Property(viewable=true, order=4)
    public String getStatus() {
        return this.status;
    }

    @Property(viewable=true, order=5)
    public Timestamp getCreateDate() {
        return this.createDate;
    }

    @Property(order=6)
    public Timestamp getLockDate() {
        return this.lockDate;
    }

    @Property(order=7)
    public Timestamp getExpiryDate() {
        return this.expiryDate;
    }

    @Property(order=8)
    @LazyProperty(cacheValidator=OracleTablespace.TablespaceReferenceValidator.class)
    public Object getDefaultTablespace(DBRProgressMonitor monitor) throws DBException {
        return OracleTablespace.resolveTablespaceReference(monitor, this, "defaultTablespace");
    }

    @Property(order=9)
    @LazyProperty(cacheValidator=OracleTablespace.TablespaceReferenceValidator.class)
    public Object getTempTablespace(DBRProgressMonitor monitor) throws DBException {
        return OracleTablespace.resolveTablespaceReference(monitor, this, "tempTablespace");
    }

    @Nullable
    public Object getLazyReference(Object propertyId) {
        if ("defaultTablespace".equals(propertyId)) {
            return this.defaultTablespace;
        }
        if ("tempTablespace".equals(propertyId)) {
            return this.tempTablespace;
        }
        if ("profile".equals(propertyId)) {
            return this.profile;
        }
        return null;
    }

    @Property(order=10)
    @LazyProperty(cacheValidator=ProfileReferenceValidator.class)
    public Object getProfile(DBRProgressMonitor monitor) throws DBException {
        return OracleUtils.resolveLazyReference(monitor, this.getDataSource(), this.getDataSource().profileCache, this, "profile");
    }

    @Property(order=11)
    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    @Property(visibleIf=OracleUserPasswordValueValidator.class, editable=true, updatable=true, order=12, password=true)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Property(visibleIf=OracleUserPasswordValueValidator.class, editable=true, updatable=true, order=13, password=true)
    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    @Override
    @Association
    public Collection<OraclePrivRole> getRolePrivs(DBRProgressMonitor monitor) throws DBException {
        return this.rolePrivCache.getAllObjects(monitor, this);
    }

    @Override
    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.refreshObject(monitor);
    }

    @Override
    public boolean isPersisted() {
        return this.persisted;
    }

    @Override
    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public static class OracleUserPasswordValueValidator
    implements IPropertyValueValidator<OracleUser, Object> {
        public boolean isValidValue(OracleUser object, Object value) throws IllegalArgumentException {
            return object.getDataSource().supportsUserPasswordEdit();
        }
    }

    public static class ProfileReferenceValidator
    implements IPropertyCacheValidator<OracleUser> {
        public boolean isPropertyCached(OracleUser object, Object propertyId) {
            return object.getLazyReference(propertyId) instanceof OracleUserProfile || object.getLazyReference(propertyId) == null || object.getDataSource().profileCache.isFullyCached();
        }
    }
}

