/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core;

import java.awt.Desktop;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jkiss.awt.injector.ProxyInjector;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.core.CoreFeatures;
import org.jkiss.dbeaver.core.DesktopPlatform;
import org.jkiss.dbeaver.core.DesktopUI;
import org.jkiss.dbeaver.model.impl.preferences.BundlePreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.features.DBRFeatureRegistry;
import org.jkiss.dbeaver.ui.ConnectionFeatures;
import org.jkiss.dbeaver.ui.browser.BrowsePeerMethods;
import org.jkiss.utils.ArrayUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DBeaverActivator
extends AbstractUIPlugin {
    private static DBeaverActivator instance;
    private ResourceBundle pluginResourceBundle;
    private ResourceBundle coreResourceBundle;
    private PrintStream debugWriter;
    private DBPPreferenceStore preferences;

    public static DBeaverActivator getInstance() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        Bundle bundle = this.getBundle();
        ModelPreferences.setMainBundle((Bundle)bundle);
        this.preferences = new BundlePreferenceStore(bundle);
        DBRFeatureRegistry.getInstance().registerFeatures(CoreFeatures.class);
        DBRFeatureRegistry.getInstance().registerFeatures(ConnectionFeatures.class);
        try {
            this.coreResourceBundle = ResourceBundle.getBundle("org.jkiss.dbeaver.core.CoreResources");
            this.pluginResourceBundle = Platform.getResourceBundle((Bundle)bundle);
        }
        catch (MissingResourceException missingResourceException) {
            this.coreResourceBundle = null;
        }
        if (this.getPreferenceStore().getBoolean("ui.use.redirect.auth")) {
            try {
                if (Desktop.isDesktopSupported()) {
                    this.injectProxyPeer();
                } else {
                    this.getLog().warn("Desktop interface not available");
                    this.getPreferenceStore().setValue("ui.use.redirect.auth", false);
                }
            }
            catch (Throwable e) {
                this.getLog().warn(e.getMessage());
                this.getPreferenceStore().setValue("ui.use.redirect.auth", false);
            }
        }
        try {
            DBeaverActivator.injectSvgFileFormat();
        }
        catch (Throwable e) {
            this.getLog().error("Unable to inject SVG file format support", e);
        }
    }

    private void injectProxyPeer() throws NoSuchFieldException, IllegalAccessException {
        ProxyInjector proxyInjector = new ProxyInjector();
        proxyInjector.injectBrowseInteraction(BrowsePeerMethods::canBrowseInSWTBrowser, BrowsePeerMethods::browseInSWTBrowser);
    }

    private static void injectSvgFileFormat() throws Throwable {
        Field FileFormat_formats = FileFormat.class.getDeclaredField("FORMATS");
        FileFormat_formats.setAccessible(true);
        Object[] formats = (String[])FileFormat_formats.get(null);
        String[] patched = (String[])ArrayUtils.add(String.class, (Object[])formats, (Object)"SVG");
        Class<?> Unsafe2 = Class.forName("sun.misc.Unsafe");
        Method Unsafe_staticFieldBase = Unsafe2.getDeclaredMethod("staticFieldBase", Field.class);
        Method Unsafe_staticFieldOffset = Unsafe2.getDeclaredMethod("staticFieldOffset", Field.class);
        Method Unsafe_putObject = Unsafe2.getDeclaredMethod("putObject", Object.class, Long.TYPE, Object.class);
        Field theUnsafe = Unsafe2.getDeclaredField("theUnsafe");
        theUnsafe.setAccessible(true);
        Object unsafe = theUnsafe.get(null);
        Unsafe_putObject.invoke(unsafe, Unsafe_staticFieldBase.invoke(unsafe, FileFormat_formats), Unsafe_staticFieldOffset.invoke(unsafe, FileFormat_formats), patched);
    }

    public void stop(BundleContext context) throws Exception {
        this.shutdownUI();
        this.shutdownCore();
        if (this.debugWriter != null) {
            this.debugWriter.close();
            this.debugWriter = null;
        }
        instance = null;
        super.stop(context);
    }

    private void shutdownUI() {
        DesktopUI.disposeUI();
    }

    public static ResourceBundle getCoreResourceBundle() {
        return DBeaverActivator.getInstance().coreResourceBundle;
    }

    public static ResourceBundle getPluginResourceBundle() {
        return DBeaverActivator.getInstance().pluginResourceBundle;
    }

    public DBPPreferenceStore getPreferences() {
        return this.preferences;
    }

    private void shutdownCore() {
        try {
            if (DesktopPlatform.instance != null) {
                DesktopPlatform.instance.dispose();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("Internal error after shutdown process:" + e.getMessage());
        }
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return DBeaverActivator.imageDescriptorFromPlugin((String)"org.jkiss.dbeaver.core", (String)path);
    }
}

