/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import jakarta.annotation.PostConstruct;
import java.util.function.Consumer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LocalCacheProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.AbstractPartListener;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractPageListener;
import org.jkiss.dbeaver.ui.controls.breadcrumb.BreadcrumbViewer;
import org.jkiss.dbeaver.ui.editors.ILazyEditorInput;
import org.jkiss.dbeaver.ui.editors.INavigatorEditorInput;
import org.jkiss.utils.ArrayUtils;

public class BreadcrumbTrim {
    private static final Log log = Log.getLog(BreadcrumbTrim.class);
    private static final String BREADCRUMBS_ID = "org.jkiss.dbeaver.core.ui.Breadcrumb";
    private static final String BOTTOM_TRIM_ID = "org.eclipse.ui.trim.status";

    @PostConstruct
    public void createControls(Composite parent) {
        BreadcrumbViewer breadcrumb = new BreadcrumbViewer(parent){

            protected void configureDropDownViewer(@NotNull TreeViewer viewer, @NotNull Object input) {
                viewer.setContentProvider((IContentProvider)new BreadcrumbNodeContentProvider(true));
                viewer.setLabelProvider((IBaseLabelProvider)new BreadcrumbNodeLabelProvider());
            }
        };
        breadcrumb.setLabelProvider((IBaseLabelProvider)new BreadcrumbNodeLabelProvider());
        breadcrumb.setContentProvider((IContentProvider)new BreadcrumbNodeContentProvider(false));
        breadcrumb.addOpenListener(e -> BreadcrumbTrim.openEditor(e.getSelection()));
        breadcrumb.addDoubleClickListener(e -> BreadcrumbTrim.openEditor(e.getSelection()));
        BreadcrumbTrim.installListeners(breadcrumb);
        BreadcrumbTrim.updateElementVisibility();
    }

    private static void updateElementVisibility() {
        IWorkbenchWindow[] iWorkbenchWindowArray = Workbench.getInstance().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            if (window instanceof WorkbenchWindow) {
                WorkbenchWindow workbenchWindow = (WorkbenchWindow)window;
                BreadcrumbTrim.updateElementVisibility(workbenchWindow);
            }
            ++n2;
        }
    }

    private static void updateElementVisibility(@NotNull WorkbenchWindow window) {
        Object object;
        MUIElement element;
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        MWindow model = window.getModel();
        EModelService modelService = (EModelService)window.getService(EModelService.class);
        boolean dirty = false;
        MUIElement breadcrumbsElement = modelService.find(BREADCRUMBS_ID, (MUIElement)model);
        boolean breadcrumbsVisible = store.getBoolean("ui.statusBar.show.breadcrumbs");
        if (breadcrumbsElement != null && breadcrumbsElement.isToBeRendered() != breadcrumbsVisible) {
            breadcrumbsElement.setToBeRendered(breadcrumbsVisible);
            dirty = true;
        }
        MUIElement statusLineElement = modelService.find("org.eclipse.ui.StatusLine", (MUIElement)model);
        boolean statusLineVisible = store.getBoolean("ui.statusBar.show.statusLine");
        if (statusLineElement != null && statusLineElement.isToBeRendered() != statusLineVisible) {
            statusLineElement.setToBeRendered(statusLineVisible);
            dirty = true;
        }
        if (dirty && (element = modelService.find(BOTTOM_TRIM_ID, (MUIElement)model)) != null && (object = element.getWidget()) instanceof Composite) {
            Composite composite = (Composite)object;
            composite.layout(true, true);
        }
    }

    private static void openEditor(@NotNull ISelection selection) {
        IStructuredSelection ss;
        Object object;
        if (selection instanceof IStructuredSelection && (object = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof DBNNode) {
            DBNNode node = (DBNNode)object;
            DBWorkbench.getPlatformUI().openEntityEditor(node, null);
        }
    }

    private static void installListeners(final @NotNull BreadcrumbViewer viewer) {
        IPropertyListener propertyListener = new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId != 258 && propId != 257) {
                    return;
                }
                if (source instanceof IEditorPart) {
                    IEditorPart editorPart = (IEditorPart)source;
                    BreadcrumbTrim.setInput(viewer, editorPart.getEditorInput());
                }
            }
        };
        AbstractPartListener partListener = new AbstractPartListener(propertyListener){
            IEditorPart lastEditorPart;
            private final /* synthetic */ 2 val$propertyListener;
            {
                this.val$propertyListener = var2_2;
            }

            public void partActivated(IWorkbenchPart part) {
                if (part instanceof IEditorPart) {
                    IEditorPart editorPart = (IEditorPart)part;
                    this.setLastEditorPart(editorPart);
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
                if (part instanceof IEditorPart) {
                    IEditorPart editorPart = (IEditorPart)part;
                    this.setLastEditorPart(editorPart);
                }
            }

            public void partClosed(IWorkbenchPart part) {
                if (part instanceof IEditorPart && part == this.lastEditorPart) {
                    this.setLastEditorPart(null);
                }
            }

            private void setLastEditorPart(@Nullable IEditorPart part) {
                if (this.lastEditorPart == part || viewer.getControl() == null || viewer.getControl().isDisposed()) {
                    return;
                }
                if (this.lastEditorPart != null) {
                    this.lastEditorPart.removePropertyListener((IPropertyListener)this.val$propertyListener);
                    this.lastEditorPart = null;
                    viewer.setInput(null);
                }
                if (part != null) {
                    this.lastEditorPart = part;
                    this.lastEditorPart.addPropertyListener((IPropertyListener)this.val$propertyListener);
                    BreadcrumbTrim.setInput(viewer, part.getEditorInput());
                }
            }
        };
        AbstractPageListener pageListener = new AbstractPageListener(partListener){
            private final /* synthetic */ 3 val$partListener;
            {
                this.val$partListener = var1_1;
            }

            public void pageOpened(IWorkbenchPage page) {
                page.addPartListener((IPartListener)this.val$partListener);
            }

            public void pageClosed(IWorkbenchPage page) {
                page.removePartListener((IPartListener)this.val$partListener);
            }
        };
        IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
        window.addPageListener((IPageListener)pageListener);
        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            page.addPartListener((IPartListener)partListener);
            ++n2;
        }
        DBWorkbench.getPlatform().getPreferenceStore().addPropertyChangeListener(event -> {
            switch (event.getProperty()) {
                case "ui.statusBar.show.breadcrumbs": 
                case "ui.statusBar.show.statusLine": {
                    BreadcrumbTrim.updateElementVisibility();
                    break;
                }
            }
        });
    }

    private static void setInput(@NotNull BreadcrumbViewer viewer, @NotNull IEditorInput input) {
        if (!BreadcrumbTrim.tryExtractNode(input, arg_0 -> ((BreadcrumbViewer)viewer).setInput(arg_0))) {
            viewer.setInput(null);
        }
    }

    private static boolean tryExtractNode(@NotNull IEditorInput input, @NotNull Consumer<? super DBNNode> consumer) {
        INavigatorEditorInput navigatorEditorInput;
        DBNNode node;
        if (input instanceof ILazyEditorInput) {
            ILazyEditorInput lazyEditorInput = (ILazyEditorInput)input;
            if (input instanceof DBPDataSourceContainerProvider) {
                DBNDatabaseNode node2;
                DBPDataSourceContainerProvider provider = (DBPDataSourceContainerProvider)input;
                DBPProject project = lazyEditorInput.getProject();
                if (project == null || !project.isOpen() || !project.isRegistryLoaded()) {
                    return false;
                }
                DBNModel navigatorModel = project.getNavigatorModel();
                if (navigatorModel != null && (node2 = navigatorModel.findNode((DBSObject)provider.getDataSourceContainer())) != null) {
                    consumer.accept((DBNNode)node2);
                    return true;
                }
            }
        }
        if (input instanceof INavigatorEditorInput && (node = (navigatorEditorInput = (INavigatorEditorInput)input).getNavigatorNode()) != null) {
            consumer.accept((DBNNode)node);
            return true;
        }
        return false;
    }

    private record BreadcrumbNodeContentProvider(boolean allowFoldersOnly) implements ITreeContentProvider
    {
        public Object[] getElements(Object inputElement) {
            DBNNode child = (DBNNode)inputElement;
            DBNNode parent = child.getParentNode();
            if (parent != null) {
                return this.getChildren(parent);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            DBNNode child = (DBNNode)element;
            if (child instanceof DBNDataSource) {
                return null;
            }
            DBNNode parent = child.getParentNode();
            while (parent instanceof DBNDatabaseFolder) {
                parent = parent.getParentNode();
            }
            return parent;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = BreadcrumbNodeContentProvider.getCachedChildren((DBNNode)parentElement);
            if (children != null) {
                return children;
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            if (!this.allowFoldersOnly || element instanceof DBNLocalFolder) {
                return !ArrayUtils.isEmpty((Object[])BreadcrumbNodeContentProvider.getCachedChildren((DBNNode)element));
            }
            return false;
        }

        @Nullable
        private static DBNNode[] getCachedChildren(@NotNull DBNNode parent) {
            try {
                return parent.getChildren((DBRProgressMonitor)new LocalCacheProgressMonitor((DBRProgressMonitor)new VoidProgressMonitor()));
            }
            catch (DBException e) {
                log.error((Object)"Error getting children", (Throwable)e);
                return null;
            }
        }
    }

    private static class BreadcrumbNodeLabelProvider
    extends LabelProvider {
        private BreadcrumbNodeLabelProvider() {
        }

        public Image getImage(Object element) {
            return DBeaverIcons.getImage((DBPImage)((DBNNode)element).getNodeIconDefault());
        }

        public String getText(Object element) {
            return ((DBNNode)element).getNodeDisplayName();
        }
    }
}

