/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.BaseThemeSettings;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IActiveWorkbenchPart;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorAccessibleAdapter;
import org.jkiss.dbeaver.ui.screenreaders.ScreenReader;
import org.jkiss.utils.CommonUtils;

public abstract class MultiPageAbstractEditor
extends MultiPageEditorPart {
    private ImageDescriptor curTitleImage;
    private final List<Image> oldImages = new ArrayList<Image>();
    private int activePageIndex = -1;
    private final List<CTabItem> tabsList = new ArrayList<CTabItem>();

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (this.getEditorInput() == null) {
            super.init(site, input);
        } else {
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(input);
            this.firePropertyChange(258);
        }
        this.setPartName(input.getName());
        this.setTitleImage(input.getImageDescriptor());
    }

    protected CTabItem createItem(int index, Control control) {
        CTabItem item = super.createItem(index, control);
        item.getControl().getAccessible().addAccessibleListener((AccessibleListener)new EditorAccessibleAdapter(item.getControl()));
        this.tabsList.add(item);
        return item;
    }

    protected void setTitleImage(ImageDescriptor titleImage) {
        if (this.getContainer() != null && this.getContainer().isDisposed()) {
            return;
        }
        if (CommonUtils.equalObjects((Object)this.curTitleImage, (Object)titleImage)) {
            return;
        }
        this.curTitleImage = titleImage;
        Image editorImage = titleImage.createImage();
        this.oldImages.add(editorImage);
        super.setTitleImage(editorImage);
    }

    public void dispose() {
        for (Image img : this.oldImages) {
            UIUtils.dispose((Resource)img);
        }
        this.oldImages.clear();
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void createPages() {
        this.setContainerStyles();
    }

    protected CTabFolder createContainer(Composite parent) {
        CTabFolder container = super.createContainer(parent);
        parent.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 2, 0).create());
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        BaseThemeSettings.instance.addPropertyListener("org.jkiss.dbeaver.dbeaver.ui.fonts.main", s -> container.setFont(BaseThemeSettings.instance.baseFont), (Control)container);
        return container;
    }

    protected void setContainerStyles() {
        Composite pageContainer = this.getContainer();
        if (pageContainer instanceof CTabFolder) {
            CTabFolder tabFolder = (CTabFolder)pageContainer;
            if (!pageContainer.isDisposed()) {
                tabFolder.setFont(BaseThemeSettings.instance.baseFont);
                tabFolder.setSimple(true);
                tabFolder.setMRUVisible(true);
                tabFolder.setTabPosition(128);
                Control topRight = this.createTopRightControl((Composite)tabFolder);
                if (topRight != null) {
                    Point trSize = topRight.computeSize(-1, -1);
                    tabFolder.setTabHeight(trSize.y);
                    tabFolder.setTopRight(topRight, 131136);
                } else {
                    ToolBar toolBar = new ToolBar((Composite)tabFolder, 0x820000);
                    new ToolItem(toolBar, 8).setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SEPARATOR_V));
                    tabFolder.setTabHeight(toolBar.computeSize((int)-1, (int)-1).y);
                    toolBar.dispose();
                }
            }
        }
    }

    protected void setPageToolTip(int index, String toolTip) {
        CTabFolder tabFolder;
        Composite pageContainer = this.getContainer();
        if (pageContainer instanceof CTabFolder && index < (tabFolder = (CTabFolder)pageContainer).getItemCount()) {
            tabFolder.getItem(index).setToolTipText(toolTip);
        }
    }

    protected void pageChange(int newPageIndex) {
        this.deactivateEditor();
        this.activePageIndex = newPageIndex;
        super.pageChange(newPageIndex);
        this.activateEditor();
    }

    protected final void deactivateEditor() {
        IEditorPart part;
        if (this.activePageIndex >= 0 && this.getEditorCount() > this.activePageIndex && (part = this.getEditor(this.activePageIndex)) instanceof IActiveWorkbenchPart) {
            ((IActiveWorkbenchPart)part).deactivatePart();
        }
    }

    protected final void activateEditor() {
        int pageIndex = this.getActivePage();
        IEditorPart part = this.getEditor(pageIndex);
        if (part instanceof IActiveWorkbenchPart) {
            ((IActiveWorkbenchPart)part).activatePart();
        }
    }

    public IEditorPart getActiveEditor() {
        if (this.getContainer().isDisposed()) {
            return null;
        }
        return super.getActiveEditor();
    }

    protected IEditorPart getEditor(int pageIndex) {
        Object data;
        CTabItem item = ((CTabFolder)this.getContainer()).getItem(pageIndex);
        if (item != null && !item.isDisposed() && (data = item.getData()) instanceof IEditorPart) {
            return (IEditorPart)data;
        }
        return null;
    }

    protected int getEditorCount() {
        return ((CTabFolder)this.getContainer()).getItemCount();
    }

    protected Control createTopRightControl(Composite composite) {
        return null;
    }

    public void recreatePages() {
        int pageCount;
        int i = pageCount = this.getPageCount();
        while (i > 0) {
            this.removePage(i - 1);
            --i;
        }
        this.createPages();
    }

    public void setFocus() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        String storedScreenReader = store.getString("screen.reader.accessibility");
        ScreenReader screenReader = ScreenReader.getScreenReader((String)storedScreenReader);
        switch (screenReader) {
            case JAWS: {
                CTabItem tabItem;
                if (this.activePageIndex == -1 || (tabItem = this.tabsList.get(this.activePageIndex)) == null || tabItem.isDisposed() || tabItem.getControl() == null || tabItem.getControl().isDisposed()) break;
                tabItem.getControl().setFocus();
                tabItem.getParent().forceFocus();
                break;
            }
            case NVDA: 
            case NARRATOR: 
            case OTHER: {
                Control control;
                CTabItem tabItem;
                if (this.activePageIndex == -1 || (tabItem = this.tabsList.get(this.activePageIndex)) == null || tabItem.isDisposed() || tabItem == null || tabItem.isDisposed() || (control = tabItem.getControl()) == null || control.isDisposed()) break;
                control.forceFocus();
                break;
            }
            case DEFAULT: {
                super.setFocus();
            }
        }
    }
}

