/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTrigger;
import org.jkiss.dbeaver.ext.generic.edit.GenericTriggerManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CubridTriggerManager
extends GenericTriggerManager<CubridTrigger> {
    public static final String BASE_TRIGGER_NAME = "new_trigger";

    public boolean canCreateObject(Object container) {
        return container instanceof GenericTableBase;
    }

    protected CubridTrigger createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        return new CubridTrigger((GenericTableBase)container, BASE_TRIGGER_NAME, monitor);
    }

    public void createTrigger(CubridTrigger trigger, StringBuilder sb) {
        sb.append("\n" + trigger.getActionTime() + " ");
        if (trigger.getEvent().equals("COMMIT") || trigger.getEvent().equals("ROLLBACK")) {
            sb.append(trigger.getEvent());
        } else {
            sb.append(trigger.getEvent());
            sb.append(" ON ").append(trigger.getTable().getUniqueName());
            if (trigger.getEvent().contains("UPDATE") && trigger.getTargetColumn() != null) {
                sb.append("(" + trigger.getTargetColumn() + ")");
            }
            if (trigger.getCondition() != null) {
                sb.append("\nIF ").append(trigger.getCondition());
            }
        }
        sb.append("\nEXECUTE ");
        if (trigger.getActionType().equals("REJECT") || trigger.getActionType().equals("INVALIDATE_TRANSACTION")) {
            sb.append(trigger.getActionType());
        } else if (trigger.getActionType().equals("PRINT")) {
            sb.append(trigger.getActionType() + " ");
            sb.append(trigger.getActionDefinition() == null ? "" : SQLUtils.quoteString((DBSObject)trigger, (String)trigger.getActionDefinition()));
        } else {
            sb.append(trigger.getActionDefinition() == null ? "" : trigger.getActionDefinition());
        }
    }

    protected void createOrReplaceTriggerQuery(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull CubridTrigger trigger, boolean create) {
        StringBuilder sb = new StringBuilder();
        sb.append(create ? "CREATE TRIGGER" : "ALTER TRIGGER ");
        sb.append(trigger.getFullyQualifiedName(DBPEvaluationContext.DDL));
        sb.append(trigger.getActive() ? "\nSTATUS ACTIVE" : "\nSTATUS INACTIVE");
        sb.append("\nPRIORITY ").append(trigger.getPriority());
        if (create) {
            this.createTrigger(trigger, sb);
        }
        if (trigger.getDescription() != null) {
            sb.append("\nCOMMENT ").append(SQLUtils.quoteString((DBSObject)trigger, (String)trigger.getDescription()));
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create and Alter Trigger", sb.toString()));
    }
}

