/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.Functions;

public class FunctionLibrary
implements Functions {
    private final List allFunctions = new ArrayList();
    private Map byNamespace;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFunctions(Functions functions) {
        this.allFunctions.add(functions);
        FunctionLibrary functionLibrary = this;
        synchronized (functionLibrary) {
            this.byNamespace = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFunctions(Functions functions) {
        this.allFunctions.remove(functions);
        FunctionLibrary functionLibrary = this;
        synchronized (functionLibrary) {
            this.byNamespace = null;
        }
    }

    @Override
    public Set getUsedNamespaces() {
        return this.functionCache().keySet();
    }

    @Override
    public Function getFunction(String namespace, String name, Object[] parameters) {
        Object candidates = this.functionCache().get(namespace);
        if (candidates instanceof Functions) {
            return ((Functions)candidates).getFunction(namespace, name, parameters);
        }
        if (candidates instanceof List) {
            List list = (List)candidates;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                Function function = ((Functions)list.get(i)).getFunction(namespace, name, parameters);
                if (function == null) continue;
                return function;
            }
        }
        return null;
    }

    private synchronized Map functionCache() {
        if (this.byNamespace == null) {
            this.byNamespace = new HashMap();
            int count = this.allFunctions.size();
            for (int i = 0; i < count; ++i) {
                Functions funcs = (Functions)this.allFunctions.get(i);
                Set namespaces = funcs.getUsedNamespaces();
                for (String ns : namespaces) {
                    Object candidates = this.byNamespace.get(ns);
                    if (candidates == null) {
                        this.byNamespace.put(ns, funcs);
                        continue;
                    }
                    if (candidates instanceof Functions) {
                        ArrayList<Object> lst = new ArrayList<Object>();
                        lst.add(candidates);
                        lst.add(funcs);
                        this.byNamespace.put(ns, lst);
                        continue;
                    }
                    ((List)candidates).add(funcs);
                }
            }
        }
        return this.byNamespace;
    }
}

