/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.connection;

import java.io.File;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class LocalNativeClientLocation
implements DBPNativeClientLocation {
    private final String id;
    private final File path;
    private final String displayName;

    public LocalNativeClientLocation(String id, File path, String displayName) {
        this.id = id;
        this.path = path;
        this.displayName = displayName;
    }

    public LocalNativeClientLocation(String id, String path, String displayName) {
        this(id, new File(path != null ? path : id), displayName);
    }

    private LocalNativeClientLocation(String id, @NotNull File path) {
        this(id, path, path.getAbsolutePath());
    }

    public LocalNativeClientLocation(String id, String path) {
        this(id, new File(path != null ? path : id));
    }

    @Override
    @NotNull
    public String getName() {
        return this.id;
    }

    @Override
    @NotNull
    public File getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean validateFilesPresence(DBRProgressMonitor progressMonitor) {
        return true;
    }

    public String toString() {
        File path = this.getPath();
        return "Local: " + path.getAbsolutePath();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBPNativeClientLocation) {
            DBPNativeClientLocation otherNativeClientLocation = (DBPNativeClientLocation)obj;
            return this.path.equals(otherNativeClientLocation.getPath());
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

