/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.virtual.DBVContainer;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.utils.CommonUtils;

public abstract class DBVObject
implements DBSObject {
    static final Log log = Log.getLog(DBVObject.class);
    private DBVTransformSettings transformSettings;
    private Map<String, Object> properties;

    @Override
    public abstract DBVContainer getParentObject();

    @Override
    public boolean isPersisted() {
        return true;
    }

    public DBVTransformSettings getTransformSettings() {
        return this.transformSettings;
    }

    public void setTransformSettings(DBVTransformSettings transformSettings) {
        this.transformSettings = transformSettings;
    }

    public abstract boolean hasValuableData();

    @Nullable
    public <T> T getProperty(@NotNull String name) {
        return (T)(CommonUtils.isEmpty(this.properties) ? null : this.properties.get(name));
    }

    public void setProperty(String name, @Nullable Object value) {
        if (this.properties == null) {
            if (value == null) {
                return;
            }
            this.properties = new LinkedHashMap<String, Object>();
        }
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    @NotNull
    public Map<String, Object> getProperties() {
        return this.properties == null ? Collections.emptyMap() : this.properties;
    }

    protected void clearProperties() {
        this.properties = null;
    }

    protected void copyFrom(@NotNull DBVObject src) {
        if (!CommonUtils.isEmpty(src.properties)) {
            this.properties = new LinkedHashMap<String, Object>(src.properties);
        }
    }

    protected void loadPropertiesFrom(@NotNull Map<String, Object> map, String elemName) {
        this.properties = JSONUtils.deserializeProperties(map, elemName);
    }

    public void persistConfiguration() {
        DBPDataSourceContainer dataSource = this.getDataSourceContainer();
        if (dataSource != null) {
            dataSource.persistConfiguration();
        }
    }

    @Nullable
    public DBPDataSourceContainer getDataSourceContainer() {
        DBVContainer parentObject = this.getParentObject();
        return parentObject == null ? null : parentObject.getDataSourceContainer();
    }

    public DBPProject getProject() {
        DBPDataSourceContainer ds = this.getDataSourceContainer();
        return ds == null ? null : ds.getProject();
    }
}

