/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.breadcrumb;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.DoubleClickMouseAdapter;
import org.jkiss.dbeaver.ui.controls.breadcrumb.BreadcrumbViewer;
import org.jkiss.utils.CommonUtils;

final class BreadcrumbItem
extends Item {
    private static final int DROP_DOWN_MIN_WIDTH = 250;
    private static final int DROP_DOWN_MAX_WIDTH = 500;
    private static final int DROP_DOWN_MIN_HEIGHT = 10;
    private final BreadcrumbViewer viewer;
    private final Composite container;
    private final Label elementArrow;
    private final Label elementImage;
    private final Label elementText;
    private final Composite detailComposite;
    private final Composite imageComposite;
    private final Composite textComposite;
    private ILabelProvider labelProvider;
    private ITreeContentProvider contentProvider;
    private ILabelProvider toolTipLabelProvider;
    private Shell menuShell;
    private TreeViewer menuViewer;
    private boolean showText = true;

    public BreadcrumbItem(@NotNull BreadcrumbViewer viewer, @NotNull Composite parent) {
        super((Widget)parent, 0);
        this.viewer = viewer;
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        this.container.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).create());
        this.elementArrow = new Label(this.container, 0);
        this.elementArrow.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.elementArrow.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.TREE_EXPAND));
        this.detailComposite = new Composite(this.container, 0);
        this.detailComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.detailComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).create());
        this.imageComposite = new Composite(this.detailComposite, 0);
        this.imageComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.imageComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(2, 1).create());
        this.textComposite = new Composite(this.detailComposite, 0);
        this.textComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(2, 2).create());
        this.elementImage = new Label(this.imageComposite, 0);
        this.elementImage.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.elementText = new Label(this.textComposite, 0);
        this.elementText.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.addElementListener((Control)this.detailComposite);
        this.addElementListener((Control)this.imageComposite);
        this.addElementListener((Control)this.textComposite);
        this.addElementListener((Control)this.elementImage);
        this.addElementListener((Control)this.elementText);
    }

    public void dispose() {
        super.dispose();
        this.container.dispose();
    }

    public void refresh() {
        Object input = this.getData();
        this.setText(this.labelProvider.getText(input));
        this.setImage(this.labelProvider.getImage(input));
        this.setToolTipText(this.toolTipLabelProvider.getText(input));
        this.setArrowVisible(this.contentProvider.getParent(this.getData()) != null);
    }

    @NotNull
    public BreadcrumbViewer getViewer() {
        return this.viewer;
    }

    @NotNull
    public Composite getContainer() {
        return this.container;
    }

    @NotNull
    public Rectangle getBounds() {
        return this.container.getBounds();
    }

    public void setLabelProvider(@NotNull ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void setContentProvider(@NotNull ITreeContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void setToolTipLabelProvider(@NotNull ILabelProvider toolTipLabelProvider) {
        this.toolTipLabelProvider = toolTipLabelProvider;
    }

    public void setImage(@Nullable Image image) {
        if (image != this.elementImage.getImage()) {
            this.elementImage.setImage(image);
        }
    }

    public void setText(@Nullable String text) {
        if (text == null) {
            text = "";
        }
        if (!text.equals(this.elementText.getText())) {
            this.elementText.setText(text);
        }
    }

    public void setToolTipText(@Nullable String toolTipText) {
        this.textComposite.setToolTipText(toolTipText);
        this.elementText.setToolTipText(toolTipText);
        this.elementImage.setToolTipText(toolTipText);
    }

    public void setTrailing(boolean trailing) {
        ((GridData)this.container.getLayoutData()).grabExcessHorizontalSpace = trailing;
    }

    public boolean isShowText() {
        return this.showText;
    }

    public void setShowText(boolean showText) {
        if (this.showText == showText) {
            return;
        }
        this.showText = showText;
        UIUtils.setControlVisible((Control)this.textComposite, showText);
        if (showText) {
            this.detailComposite.setTabList(new Control[]{this.textComposite});
        } else {
            this.detailComposite.setTabList(new Control[]{this.imageComposite});
        }
    }

    public int computeWidth() {
        return this.container.computeSize((int)-1, (int)-1).x;
    }

    private void setArrowVisible(boolean visible) {
        UIUtils.setControlVisible((Control)this.elementArrow, visible);
    }

    private void showMenu() {
        this.menuShell = new Shell(this.container.getShell(), 16404);
        this.menuShell.setLayout((Layout)new FillLayout());
        Object input = this.getData();
        this.menuViewer = new TreeViewer((Composite)this.menuShell, 772);
        this.menuViewer.addOpenListener(e -> {
            IStructuredSelection selection;
            Object element;
            ISelection iSelection = e.getSelection();
            if (iSelection instanceof IStructuredSelection && (element = (selection = (IStructuredSelection)iSelection).getFirstElement()) != null) {
                this.openElement(element);
            }
        });
        this.menuViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button != 1 || (OpenStrategy.getOpenMethod() & 1) != 0) {
                    return;
                }
                Tree tree = (Tree)e.widget;
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                if (item != null) {
                    BreadcrumbItem.this.openElement(item.getData());
                }
            }
        });
        this.viewer.configureDropDownViewer(this.menuViewer, input);
        this.menuViewer.setInput(input);
        this.configureShellBounds(this.menuShell);
        this.configureShellCloser(this.menuShell);
        this.menuShell.setVisible(true);
        this.menuShell.setFocus();
    }

    private void openElement(@NotNull Object element) {
        this.viewer.fireMenuSelection(element);
        if (this.menuShell != null) {
            this.menuShell.dispose();
        }
    }

    private void addElementListener(@NotNull Control control) {
        control.addMenuDetectListener(e -> this.showMenu());
        control.addMouseListener((MouseListener)new DoubleClickMouseAdapter(){

            @Override
            public void onMouseSingleClick(@NotNull MouseEvent e) {
                BreadcrumbItem.this.showMenu();
            }

            @Override
            public void onMouseDoubleClick(@NotNull MouseEvent e) {
                BreadcrumbViewer viewer = BreadcrumbItem.this.getViewer();
                viewer.selectItem(BreadcrumbItem.this);
                viewer.fireDoubleClick();
            }
        });
    }

    private void configureShellBounds(@NotNull Shell shell) {
        shell.pack();
        IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
        Point windowSize = window.getShell().getSize();
        Point shellSize = shell.getSize();
        int width = CommonUtils.clamp((int)shellSize.x, (int)250, (int)500);
        int height = CommonUtils.clamp((int)shellSize.y, (int)10, (int)(windowSize.y / 2));
        Rectangle itemBounds = this.container.getBounds();
        Rectangle trimBounds = shell.computeTrim(0, 0, width, height);
        Point location = new Point(0, 0);
        location.x = trimBounds.x + this.elementArrow.getSize().x;
        location.y -= height + trimBounds.y + itemBounds.y;
        shell.setLocation(this.container.toDisplay(location));
        shell.setSize(width, height);
    }

    private void configureShellCloser(final @NotNull Shell shell) {
        Listener focusListener = e -> {
            switch (e.type) {
                case 15: {
                    Control control;
                    boolean isFocusWidgetParentShell;
                    Tree tree;
                    Widget focusElement = e.widget;
                    boolean isFocusBreadcrumbTreeFocusWidget = focusElement == shell || focusElement instanceof Tree && (tree = (Tree)focusElement).getShell() == shell;
                    boolean bl = isFocusWidgetParentShell = focusElement instanceof Control && (control = (Control)focusElement).getShell().getParent() == shell;
                    if (isFocusBreadcrumbTreeFocusWidget || isFocusWidgetParentShell) break;
                    shell.close();
                    break;
                }
                case 16: {
                    if (e.display.getActiveShell() != null) break;
                    shell.close();
                }
            }
        };
        Display display = shell.getDisplay();
        display.addFilter(15, focusListener);
        display.addFilter(16, focusListener);
        ControlListener controlListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
                shell.close();
            }

            public void controlResized(ControlEvent e) {
                shell.close();
            }
        };
        this.container.addControlListener(controlListener);
        shell.addDisposeListener(e -> {
            display.removeFilter(15, focusListener);
            display.removeFilter(16, focusListener);
            if (!this.container.isDisposed()) {
                this.container.removeControlListener(controlListener);
            }
        });
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                BreadcrumbItem.this.menuShell = null;
                BreadcrumbItem.this.menuViewer = null;
            }
        });
    }
}

