/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.view;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.IViewDescriptor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainerExt;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.dialogs.EditTextDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

class ErrorDetailsPart {
    private final Composite parent;
    private final IStatus reason;
    private final IResultSetContainerExt resultSetContainer;

    ErrorDetailsPart(Composite parent, IStatus reason_, @Nullable IResultSetContainerExt resultSetContainer) {
        int margins;
        this.parent = parent;
        this.resultSetContainer = resultSetContainer;
        Color bgColor = parent.getDisplay().getSystemColor(25);
        Color fgColor = parent.getDisplay().getSystemColor(24);
        parent.setBackground(bgColor);
        parent.setForeground(fgColor);
        this.reason = reason_;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        int spacing = 8;
        layout.marginBottom = margins = 8;
        layout.marginTop = margins;
        layout.marginLeft = margins;
        layout.marginRight = margins;
        layout.horizontalSpacing = spacing;
        layout.verticalSpacing = spacing;
        parent.setLayout((Layout)layout);
        Label imageLabel = new Label(parent, 0);
        imageLabel.setBackground(bgColor);
        Image image = this.getImage();
        if (image != null) {
            image.setBackground(bgColor);
            imageLabel.setImage(image);
            GridData gridData = new GridData(66);
            imageLabel.setLayoutData((Object)gridData);
        }
        Text text = new Text(parent, 586);
        text.setBackground(bgColor);
        text.setForeground(fgColor);
        text.setLayoutData((Object)new GridData(1808));
        text.setText(GeneralUtils.normalizeLineSeparators((String)this.reason.getMessage()));
        text.setFont(UIUtils.getMonospaceFont());
        text.addListener(11, e -> {
            Point size = text.getSize();
            if (size.y > 100) {
                ((GridData)text.getLayoutData()).heightHint = 100;
                parent.layout(true);
            }
        });
        Composite buttonParent = new Composite(parent, 0);
        GridData gd = new GridData(2);
        gd.horizontalSpan = 2;
        buttonParent.setLayoutData((Object)gd);
        buttonParent.setBackground(parent.getBackground());
        GridLayout buttonsLayout = new GridLayout();
        buttonsLayout.numColumns = 3;
        buttonsLayout.marginHeight = 0;
        buttonsLayout.marginWidth = 0;
        buttonsLayout.horizontalSpacing = 0;
        buttonParent.setLayout((Layout)buttonsLayout);
        this.createGoToErrorButton(buttonParent);
        this.createShowLogButton(buttonParent);
        Button detailsButton = new Button(buttonParent, 8);
        detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        detailsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.showDetails()));
        detailsButton.setLayoutData((Object)new GridData(1, 4, false, false));
        detailsButton.setVisible(this.reason.getException() != null);
    }

    private Image getImage() {
        return switch (this.reason.getSeverity()) {
            case 4 -> DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_ERROR);
            case 2 -> DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_WARNING);
            default -> DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_INFO);
        };
    }

    private void showDetails() {
        EditTextDialog dialog = new EditTextDialog(this.parent.getShell(), "Error details", this.getDetails(this.reason), true);
        dialog.setMonospaceFont(true);
        dialog.setAutoSize(true);
        dialog.open();
    }

    private String getDetails(IStatus status) {
        if (status.getException() != null) {
            return GeneralUtils.normalizeLineSeparators((String)this.getStackTrace(status.getException()));
        }
        return "";
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter swriter = new StringWriter();
        Throwable throwable2 = null;
        Object var4_5 = null;
        try (PrintWriter pwriter = new PrintWriter(swriter);){
            throwable.printStackTrace(pwriter);
            pwriter.flush();
        }
        catch (Throwable throwable3) {
            if (throwable2 == null) {
                throwable2 = throwable3;
            } else if (throwable2 != throwable3) {
                throwable2.addSuppressed(throwable3);
            }
            throw throwable2;
        }
        return swriter.toString();
    }

    private void createShowLogButton(Composite parent) {
        IViewDescriptor descriptor = PlatformUI.getWorkbench().getViewRegistry().find("org.eclipse.pde.runtime.LogView");
        if (descriptor == null) {
            return;
        }
        Button button = new Button(parent, 8);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.pde.runtime.LogView");
            }
            catch (CoreException ce) {
                StatusManager.getManager().handle(ce, WorkbenchPlugin.PI_WORKBENCH);
            }
        }));
        Image image = descriptor.getImageDescriptor().createImage();
        button.setImage(image);
        button.setToolTipText(WorkbenchMessages.ErrorLogUtil_ShowErrorLogTooltip);
        button.addDisposeListener(e -> image.dispose());
        button.setText("Show log");
    }

    private void createGoToErrorButton(@NotNull Composite parent) {
        Button button = new Button(parent, 8);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String message = this.reason.getMessage();
            if (CommonUtils.isNotEmpty((String)message)) {
                this.resultSetContainer.showCurrentError();
            }
        }));
        button.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.BUTTON_GO_TO_ERROR));
        button.setToolTipText(ResultSetMessages.error_part_button_go_to_error);
        button.setVisible(this.reason.getException() != null && this.resultSetContainer != null);
        button.setText("Go to Error");
    }
}

