/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.sqlite.model;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteAffinity;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteDataSourceInfo;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteSQLDialect;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteTable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SQLiteDataSource
extends GenericDataSource {
    public SQLiteDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new SQLiteSQLDialect());
    }

    public SQLiteDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull GenericMetaModel metaModel, @NotNull SQLDialect dialect) throws DBException {
        super(monitor, container, metaModel, dialect);
    }

    protected DBPDataSourceInfo createDataSourceInfo(DBRProgressMonitor monitor, @NotNull JDBCDatabaseMetaData metaData) {
        return new SQLiteDataSourceInfo(this.container.getDriver(), metaData);
    }

    protected boolean isPopulateClientAppName() {
        return false;
    }

    public DBSDataType getLocalDataType(@Nullable String typeName) {
        if (typeName == null) {
            return super.getLocalDataType(SQLiteDataSource.defaultAffinity().name());
        }
        SQLiteAffinity affinity = (typeName = typeName.toUpperCase(Locale.ENGLISH)).startsWith("INT") ? SQLiteAffinity.INTEGER : (typeName.contains("CHAR") || typeName.contains("CLOB") || typeName.contains("TEXT") || typeName.startsWith("DATE") || typeName.startsWith("TIME") ? SQLiteAffinity.TEXT : (typeName.contains("BLOB") || typeName.contains("GUID") ? SQLiteAffinity.BLOB : (typeName.startsWith("REAL") || typeName.startsWith("FLOA") || typeName.startsWith("DOUB") ? SQLiteAffinity.REAL : (typeName.contains("INT") || typeName.contains("NUMERIC") || typeName.contains("DECIMAL") || typeName.contains("BOOL") ? SQLiteAffinity.NUMERIC : SQLiteDataSource.defaultAffinity()))));
        return super.getLocalDataType(affinity.name());
    }

    private static SQLiteAffinity defaultAffinity() {
        return SQLiteAffinity.TEXT;
    }

    protected boolean isConnectionReadOnlyBroken() {
        return true;
    }

    protected Map<String, String> getInternalConnectionProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBPDriver driver, @NotNull JDBCExecutionContext context, @NotNull String purpose, @NotNull DBPConnectionConfiguration connectionInfo) throws DBCException {
        HashMap<String, String> connectionsProps = new HashMap<String, String>();
        if (this.getContainer().isConnectionReadOnly()) {
            connectionsProps.put("open_mode", "1");
        }
        connectionsProps.put("enable_load_extension", String.valueOf(true));
        return connectionsProps;
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return SQLiteTable.class;
    }

    public DBPErrorAssistant.ErrorType discoverErrorType(@NotNull Throwable error) {
        if (error instanceof SQLException && ((SQLException)error).getErrorCode() == 19) {
            return DBPErrorAssistant.ErrorType.UNIQUE_KEY_VIOLATION;
        }
        return super.discoverErrorType(error);
    }
}

