/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptorSerializer;
import org.jkiss.utils.CommonUtils;

public class DriverDescriptorSerializerModern
extends DriverDescriptorSerializer {
    private static final Log log = Log.getLog(DriverDescriptorSerializerModern.class);
    public static final String DRIVERS_FILE_NAME = "drivers-configuration.json";

    @Override
    void serializeDrivers(OutputStream os, List<DataSourceProviderDescriptor> providers) throws IOException {
    }

    public void serializeDriver(JsonWriter json, DriverDescriptor driver, boolean export) throws IOException {
        Map<String, String> pathSubstitutions = this.getPathSubstitutions();
        json.name(driver.getId());
        json.beginObject();
        if (export) {
            JSONUtils.fieldNE((JsonWriter)json, (String)"provider", (String)driver.getProviderDescriptor().getId());
        }
        JSONUtils.field((JsonWriter)json, (String)"id", (String)driver.getId());
        JSONUtils.field((JsonWriter)json, (String)"name", (String)driver.getName());
        JSONUtils.field((JsonWriter)json, (String)"class", (String)driver.getDriverClassName());
        JSONUtils.fieldNE((JsonWriter)json, (String)"url", (String)driver.getSampleURL());
        JSONUtils.fieldNE((JsonWriter)json, (String)"port", (String)driver.getDefaultPort());
        JSONUtils.fieldNE((JsonWriter)json, (String)"description", (String)driver.getDescription());
        JSONUtils.fieldNE((JsonWriter)json, (String)"categories", (String)String.join((CharSequence)",", driver.getCategories()));
        JSONUtils.field((JsonWriter)json, (String)"custom", (boolean)driver.isCustom());
        JSONUtils.field((JsonWriter)json, (String)"embedded", (boolean)driver.isEmbedded());
        JSONUtils.field((JsonWriter)json, (String)"propagateDriverProperties", (boolean)driver.isPropagateDriverProperties());
        JSONUtils.field((JsonWriter)json, (String)"anonymous", (boolean)driver.isAnonymousAccess());
        JSONUtils.field((JsonWriter)json, (String)"allowsEmptyPassword", (boolean)driver.isAnonymousAccess());
        JSONUtils.field((JsonWriter)json, (String)"instantiable", (boolean)driver.isInstantiable());
        if (driver.isCustomDriverLoader()) {
            JSONUtils.field((JsonWriter)json, (String)"customDriverLoader", (boolean)driver.isCustomDriverLoader());
        }
        if (driver.isDisabled()) {
            JSONUtils.field((JsonWriter)json, (String)"disabled", (boolean)true);
        }
        if (!CommonUtils.isEmpty((String)driver.getCategory())) {
            JSONUtils.fieldNE((JsonWriter)json, (String)"category", (String)driver.getCategory());
        }
        if (!CommonUtils.isEmpty(driver.getDriverLibraries())) {
            json.name("libraries");
            json.beginObject();
            for (DBPDriverLibrary dBPDriverLibrary : driver.getDriverLibraries()) {
                List<DriverDescriptor.DriverFileInfo> files;
                if (export && !dBPDriverLibrary.isDisabled()) continue;
                json.name(DriverDescriptorSerializerModern.substitutePathVariables(pathSubstitutions, dBPDriverLibrary.getPath()));
                json.beginObject();
                JSONUtils.fieldNE((JsonWriter)json, (String)"type", (String)dBPDriverLibrary.getType().name());
                JSONUtils.field((JsonWriter)json, (String)"custom", (boolean)dBPDriverLibrary.isCustom());
                if (dBPDriverLibrary.isEmbedded()) {
                    JSONUtils.field((JsonWriter)json, (String)"embedded", (boolean)true);
                }
                if (dBPDriverLibrary.isDisabled()) {
                    JSONUtils.field((JsonWriter)json, (String)"disabled", (boolean)true);
                }
                if (!CommonUtils.isEmpty((String)dBPDriverLibrary.getPreferredVersion())) {
                    JSONUtils.field((JsonWriter)json, (String)"version", (String)dBPDriverLibrary.getPreferredVersion());
                }
                if (!export && !CommonUtils.isEmpty(files = driver.getResolvedFiles().get(dBPDriverLibrary))) {
                    json.name("files");
                    json.beginObject();
                    for (DriverDescriptor.DriverFileInfo file : files) {
                        if (file.getFile() == null) {
                            log.warn((Object)("File missing in " + file.getId()));
                            continue;
                        }
                        json.name(file.getId());
                        json.beginObject();
                        if (!CommonUtils.isEmpty((String)file.getVersion())) {
                            JSONUtils.field((JsonWriter)json, (String)"version", (String)file.getVersion());
                        }
                        JSONUtils.field((JsonWriter)json, (String)"path", (String)DriverDescriptorSerializerModern.substitutePathVariables(pathSubstitutions, file.getFile().toAbsolutePath().toString()));
                        json.endObject();
                    }
                    json.endObject();
                }
                json.endObject();
            }
            json.endObject();
        }
        if (!CommonUtils.isEmpty(driver.getNativeClientHomes())) {
            json.name("native-clients");
            json.beginObject();
            for (DBPNativeClientLocation dBPNativeClientLocation : driver.getNativeClientHomes()) {
                json.name(dBPNativeClientLocation.getName());
                json.beginObject();
                if (dBPNativeClientLocation.getPath() != null) {
                    JSONUtils.fieldNE((JsonWriter)json, (String)"path", (String)dBPNativeClientLocation.getPath().getAbsolutePath());
                }
                json.endObject();
            }
            json.endObject();
        }
        if (!CommonUtils.isEmpty(driver.getCustomParameters())) {
            json.name("driver-parameters");
            json.beginObject();
            for (Map.Entry entry : driver.getCustomParameters().entrySet()) {
                if (!driver.isCustom() && CommonUtils.equalObjects(entry.getValue(), (Object)driver.getDefaultParameters().get(entry.getKey()))) continue;
                json.name((String)entry.getKey());
                json.value(CommonUtils.toString(entry.getValue()));
            }
            json.endObject();
        }
        if (!CommonUtils.isEmpty(driver.getConnectionProperties())) {
            json.name("connection-properties");
            json.beginObject();
            for (Map.Entry entry : driver.getConnectionProperties().entrySet()) {
                if (CommonUtils.equalObjects(entry.getValue(), (Object)driver.getDefaultConnectionProperties().get(entry.getKey()))) continue;
                json.name(CommonUtils.toString(entry.getKey()));
                json.value(CommonUtils.toString(entry.getValue()));
            }
            json.endObject();
        }
        json.endObject();
    }
}

