/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverLibraryLocal;
import org.jkiss.dbeaver.registry.driver.DriverLibraryMavenArtifact;
import org.jkiss.dbeaver.registry.driver.DriverLibraryRemote;
import org.jkiss.dbeaver.registry.driver.DriverLibraryRepository;
import org.jkiss.dbeaver.registry.driver.DriverUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.WebUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.SecurityUtils;

public abstract class DriverLibraryAbstract
implements DBPDriverLibrary {
    private static final Log log = Log.getLog(DriverLibraryAbstract.class);
    protected final DriverDescriptor driver;
    protected final DBPDriverLibrary.FileType type;
    protected final OSDescriptor system;
    protected String path;
    private boolean optional;
    protected boolean custom;
    protected boolean embedded;
    protected boolean disabled;
    protected long fileCRC;

    public static DriverLibraryAbstract createFromPath(DriverDescriptor driver, DBPDriverLibrary.FileType type, String path, String preferredVersion) {
        if (path.startsWith("repo:/")) {
            return new DriverLibraryRepository(driver, type, path);
        }
        if (path.startsWith("maven:/")) {
            return new DriverLibraryMavenArtifact(driver, type, path, preferredVersion);
        }
        if (DriverLibraryRemote.supportsURL(path)) {
            return new DriverLibraryRemote(driver, type, path);
        }
        return new DriverLibraryLocal(driver, type, path);
    }

    public static DriverLibraryAbstract createFromConfig(DriverDescriptor driver, IConfigurationElement config) {
        String path = config.getAttribute("path");
        if (CommonUtils.isEmpty((String)path)) {
            log.error((Object)"Bad file path");
            return null;
        }
        if (!DriverUtils.matchesBundle(config)) {
            return null;
        }
        if (path.startsWith("repo:/")) {
            return new DriverLibraryRepository(driver, config);
        }
        if (path.startsWith("maven:/")) {
            return new DriverLibraryMavenArtifact(driver, config);
        }
        if (DriverLibraryRemote.supportsURL(path)) {
            return new DriverLibraryRemote(driver, config);
        }
        return new DriverLibraryLocal(driver, config);
    }

    protected DriverLibraryAbstract(DriverDescriptor driverDescriptor, DriverLibraryAbstract copyFrom) {
        this.driver = driverDescriptor;
        this.type = copyFrom.type;
        this.system = copyFrom.system;
        this.path = copyFrom.path;
        this.embedded = copyFrom.embedded;
        this.optional = copyFrom.optional;
        this.custom = copyFrom.custom;
        this.disabled = copyFrom.disabled;
    }

    protected DriverLibraryAbstract(DriverDescriptor driver, DBPDriverLibrary.FileType type, String path) {
        this.driver = driver;
        this.type = type;
        this.system = null;
        this.path = path;
        this.custom = true;
    }

    protected DriverLibraryAbstract(DriverDescriptor driver, IConfigurationElement config) {
        this.driver = driver;
        String typeStr = config.getAttribute("type");
        if ("zip".equalsIgnoreCase(typeStr)) {
            typeStr = DBPDriverLibrary.FileType.jar.name();
        }
        this.type = DBPDriverLibrary.FileType.valueOf((String)typeStr);
        String osName = config.getAttribute("os");
        this.system = osName == null ? null : new OSDescriptor(osName, config.getAttribute("arch"));
        this.path = config.getAttribute("path");
        this.embedded = CommonUtils.getBoolean((String)config.getAttribute("embedded"), (boolean)false);
        this.optional = CommonUtils.getBoolean((String)config.getAttribute("optional"), (boolean)false);
        this.custom = false;
    }

    public DriverDescriptor getDriver() {
        return this.driver;
    }

    public String getVersion() {
        return null;
    }

    @NotNull
    public Collection<String> getAvailableVersions(@NotNull DBRProgressMonitor monitor) throws IOException {
        return Collections.emptyList();
    }

    public String getPreferredVersion() {
        return null;
    }

    public void setPreferredVersion(@NotNull String version) {
    }

    public boolean isInvalidLibrary() {
        return false;
    }

    @NotNull
    public DBPDriverLibrary.FileType getType() {
        return this.type;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDescription() {
        return null;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public void setCustom(boolean custom) {
        this.custom = custom;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public long getFileCRC() {
        return this.fileCRC;
    }

    public boolean matchesCurrentPlatform() {
        return this.system == null || this.system.matches(DBWorkbench.getPlatform().getLocalSystem());
    }

    public void downloadLibraryFile(@NotNull DBRProgressMonitor monitor, boolean forceUpdate, String taskName) throws IOException, InterruptedException {
        block10: {
            String externalURL;
            Path localFile = this.getLocalFile();
            if (localFile == null) {
                throw new IOException("No target file for '" + this.getPath() + "'");
            }
            if (!forceUpdate && Files.exists(localFile, new LinkOption[0]) && Files.size(localFile) > 0L) {
                return;
            }
            Path localDir = localFile.getParent();
            if (!Files.exists(localDir, new LinkOption[0])) {
                Files.createDirectories(localDir, new FileAttribute[0]);
            }
            if ((externalURL = this.getExternalURL(monitor)) == null) {
                throw new IOException("Unresolved file reference: " + this.getPath());
            }
            Path tempFolder = DBWorkbench.getPlatform().getTempFolder(monitor, "driver-files");
            Path tempFile = tempFolder.resolve(SecurityUtils.makeDigest((String)localFile.toString()));
            WebUtils.downloadRemoteFile((DBRProgressMonitor)monitor, (String)taskName, (String)externalURL, (Path)tempFile, (DBPAuthInfo)this.getAuthInfo(monitor));
            this.fileCRC = DriverDescriptor.calculateFileCRC(tempFile);
            if (DBWorkbench.isDistributed()) {
                try {
                    try {
                        byte[] fileData = Files.readAllBytes(tempFile);
                        DBWorkbench.getPlatform().getFileController().saveFileData("libraries", DriverUtils.getDistributedLibraryPath(localFile), fileData);
                        break block10;
                    }
                    catch (DBException e) {
                        throw new IOException(e.getMessage());
                    }
                }
                finally {
                    Files.delete(tempFile);
                }
            }
            DBFUtils.move((Path)tempFile, (Path)localFile);
        }
    }

    @Nullable
    protected DBPAuthInfo getAuthInfo(DBRProgressMonitor monitor) {
        return null;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object obj) {
        return obj instanceof DriverLibraryAbstract && ((DriverLibraryAbstract)obj).getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public abstract DBPDriverLibrary copyLibrary(DriverDescriptor var1);
}

