/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.judr.crypt.sm4;

import com.gbasedbt.judr.crypt.sm4.SM4;
import com.gbasedbt.judr.crypt.sm4.SM4_Context;
import com.gbasedbt.judr.crypt.sm4.Util;
import com.gbasedbt.judr.hex.HexStr;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

public class SM4Utils {
    private static String DEFAULT_CHARSET = "UTF-8";
    private static String DEFAULT_SECRETKEY = "GBase123GBase123";
    public String secretKey = "";
    public String iv = "";
    public boolean hexString = false;

    public String encryptData_ECB(String plainText) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = Util.hexStringToBytes(this.secretKey);
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_ecb(ctx, plainText.getBytes(DEFAULT_CHARSET));
            return Util.byteToHex(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String decryptData_ECB(String cipherText) {
        try {
            byte[] encrypted = Util.hexToByte(cipherText);
            cipherText = Base64.encodeBase64String(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = this.hexString ? Util.hexStringToBytes(this.secretKey) : this.secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_ecb(ctx, Base64.decodeBase64(cipherText));
            return new String(decrypted, DEFAULT_CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String sm4_encrypt(String plainText, String keyText) throws IOException {
        SM4Utils sm4 = new SM4Utils();
        sm4.secretKey = HexStr.encodeHex(keyText, DEFAULT_CHARSET);
        sm4.hexString = true;
        if (sm4.secretKey.length() != 32) {
            return null;
        }
        return sm4.encryptData_ECB(plainText);
    }

    public static String sm4_encrypt(String plainText) throws IOException {
        return SM4Utils.sm4_encrypt(plainText, DEFAULT_SECRETKEY);
    }

    public static String sm4_decrypt(String cipherText, String keyText) throws IOException {
        SM4Utils sm4 = new SM4Utils();
        sm4.secretKey = HexStr.encodeHex(keyText, DEFAULT_CHARSET);
        sm4.hexString = true;
        if (sm4.secretKey.length() != 32) {
            return null;
        }
        return sm4.decryptData_ECB(cipherText);
    }

    public static String sm4_decrypt(String cipherText) throws IOException {
        return SM4Utils.sm4_decrypt(cipherText, DEFAULT_SECRETKEY);
    }
}

