/*
 * Decompiled with CFR 0.152.
 */
package gbase.hibernate.dialect;

import java.sql.SQLException;
import org.hibernate.Hibernate;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.ViolatedConstraintNameExtracter;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class GBaseDialect
extends Dialect {
    private static ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        public String extractConstraintName(SQLException sqle) {
            int i;
            String constraintName = null;
            int errorCode = JDBCExceptionHelper.extractErrorCode((SQLException)sqle);
            if (errorCode == -268) {
                constraintName = this.extractUsingTemplate("Unique constraint (", ") violated.", sqle.getMessage());
            } else if (errorCode == -691) {
                constraintName = this.extractUsingTemplate("Missing key in referenced table for referential constraint (", ").", sqle.getMessage());
            } else if (errorCode == -692) {
                constraintName = this.extractUsingTemplate("Key value for constraint (", ") is still being referenced.", sqle.getMessage());
            }
            if (constraintName != null && (i = constraintName.indexOf(46)) != -1) {
                constraintName = constraintName.substring(i + 1);
            }
            return constraintName;
        }
    };

    public GBaseDialect() {
        this.registerKeyword("to");
        this.registerColumnType(-5, "int8");
        this.registerColumnType(-2, "byte");
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(1, "char($l)");
        this.registerColumnType(91, "date");
        this.registerColumnType(3, "decimal");
        this.registerColumnType(8, "float");
        this.registerColumnType(6, "smallfloat");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-4, "blob");
        this.registerColumnType(-1, "clob");
        this.registerColumnType(2, "decimal");
        this.registerColumnType(7, "smallfloat");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(93, "datetime year to fraction(5)");
        this.registerColumnType(92, "datetime hour to second");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(-3, "byte");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(12, 255, "varchar($l)");
        this.registerColumnType(12, 32739, "lvarchar($l)");
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)Hibernate.STRING, "(", "||", ")"));
        this.registerHibernateType(1, Hibernate.STRING.getName());
        this.registerHibernateType(-1, Hibernate.STRING.getName());
        this.registerFunction("month", (SQLFunction)new SQLFunctionTemplate((Type)Hibernate.INTEGER, "extract(month from ?1)"));
        this.registerFunction("year", (SQLFunction)new SQLFunctionTemplate((Type)Hibernate.INTEGER, "extend(?1,year to year)"));
    }

    public String getAddColumnString() {
        return "add";
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentitySelectString(String table, String column, int type) throws MappingException {
        return type == -5 ? "select dbinfo('serial8') from systables where tabid=1" : "select dbinfo('sqlca.sqlerrd1') from systables where tabid=1";
    }

    public String getIdentityColumnString(int type) throws MappingException {
        return type == -5 ? "serial8 not null" : "serial not null";
    }

    public boolean hasDataTypeInIdentityColumn() {
        return false;
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        StringBuffer result = new StringBuffer(30);
        result.append(" add constraint ").append(" foreign key (").append(StringHelper.join((String)", ", (String[])foreignKey)).append(") references ").append(referencedTable);
        if (!referencesPrimaryKey) {
            result.append(" (").append(StringHelper.join((String)", ", (String[])primaryKey)).append(')');
        }
        result.append(" constraint ").append(constraintName);
        return result.toString();
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " add constraint primary key constraint " + constraintName + " ";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select " + this.getSelectSequenceNextValString(sequenceName) + " from systables where tabid=1";
    }

    public String getSelectSequenceNextValString(String sequenceName) {
        return String.valueOf(sequenceName) + ".nextval";
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return false;
    }

    public String getLimitString(String querySelect, int offset, int limit) {
        if (offset > 0) {
            throw new UnsupportedOperationException("gbasedbt has no offset");
        }
        return new StringBuffer(querySelect.length() + 8).append(querySelect).insert(querySelect.toLowerCase().indexOf("select") + 6, " first " + limit).toString();
    }

    public boolean supportsVariableLimit() {
        return false;
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "select distinct current timestamp from gbasedbt.systables";
    }
}

