/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.InformixDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.dialect.unique.InformixUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class GBasedbtDialect
extends InformixDialect {
    private final UniqueDelegate uniqueDelegate;

    public GBasedbtDialect() {
        this.registerColumnType(-5, "int8");
        this.registerColumnType(-2, "byte");
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(1, "char($l)");
        this.registerColumnType(91, "date");
        this.registerColumnType(3, "decimal");
        this.registerColumnType(8, "float");
        this.registerColumnType(6, "smallfloat");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-4, "blob");
        this.registerColumnType(-1, "clob");
        this.registerColumnType(2, "decimal");
        this.registerColumnType(7, "smallfloat");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(93, "datetime year to fraction(5)");
        this.registerColumnType(92, "datetime hour to second");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(-3, "byte");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(12, 255L, "varchar($l)");
        this.registerColumnType(12, 32739L, "lvarchar($l)");
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)StandardBasicTypes.STRING, "(", "||", ")"));
        this.uniqueDelegate = new InformixUniqueDelegate((Dialect)this);
    }

    public String getIdentitySelectString(String table, String column, int type) throws MappingException {
        return type == -5 ? "select dbinfo('bigserial') from dual" : "select dbinfo('sqlca.sqlerrd1') from dual";
    }

    public String getIdentityColumnString(int type) throws MappingException {
        return type == -5 ? "bigserial not null" : "serial not null";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select " + this.getSelectSequenceNextValString(sequenceName) + " from dual";
    }

    public String getQuerySequencesString() {
        return "select tabname from systables where tabtype='Q'";
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String getLimitString(String querySelect, int offset, int limit) {
        int first_value = limit < 0 ? 0 : limit - offset;
        return new StringBuilder(querySelect.length() + 36).append(querySelect).insert(querySelect.toLowerCase().indexOf("select") + 6, " skip " + offset + " first " + first_value).toString();
    }

    public String getCurrentTimestampSelectString() {
        return "select current year to fraction(5) as timestamp from dual";
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }
}

