/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import java.util.Locale;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.spi.RowSelection;

public class GBasedbtLimitHandler
extends AbstractLimitHandler {
    public static final GBasedbtLimitHandler INSTANCE = new GBasedbtLimitHandler();

    private GBasedbtLimitHandler() {
    }

    public String processSql(String sql, RowSelection selection) {
        boolean hasOffset = LimitHelper.hasFirstRow((RowSelection)selection);
        String sqlOffset = hasOffset ? " SKIP " + selection.getFirstRow() : "";
        String sqlLimit = " FIRST " + this.getMaxOrLimit(selection);
        String sqlOffsetLimit = String.valueOf(sqlOffset) + sqlLimit;
        String result = new StringBuilder(sql.length() + 10).append(sql).insert(sql.toLowerCase(Locale.ROOT).indexOf("select") + 6, sqlOffsetLimit).toString();
        return result;
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean bindLimitParametersFirst() {
        return true;
    }

    public boolean useMaxForLimit() {
        return false;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public boolean supportsVariableLimit() {
        return false;
    }
}

