/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.InformixDialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.NvlFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.dialect.pagination.Informix10LimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.unique.InformixUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class GBasedbtDialect
extends InformixDialect {
    private final UniqueDelegate uniqueDelegate;

    public GBasedbtDialect() {
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(-2, "byte");
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(1, "char($l)");
        this.registerColumnType(91, "date");
        this.registerColumnType(3, "decimal");
        this.registerColumnType(8, "float");
        this.registerColumnType(6, "smallfloat");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-4, "blob");
        this.registerColumnType(-1, "clob");
        this.registerColumnType(2, "decimal");
        this.registerColumnType(7, "smallfloat");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(93, "datetime year to fraction(5)");
        this.registerColumnType(92, "datetime hour to second");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(-3, "byte");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(12, 255L, "varchar($l)");
        this.registerColumnType(12, 32739L, "lvarchar($l)");
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)StandardBasicTypes.STRING, "(", "||", ")"));
        this.registerFunction("substring", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "substring(?1 FROM ?2 FOR ?3)"));
        this.registerFunction("substr", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "substr(?1, ?2, ?3)"));
        this.registerFunction("coalesce", (SQLFunction)new NvlFunction());
        this.registerFunction("nvl", (SQLFunction)new NvlFunction());
        this.registerFunction("current_timestamp", (SQLFunction)new NoArgSQLFunction("current year to fraction(5)", (Type)StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("current_date", (SQLFunction)new NoArgSQLFunction("today", (Type)StandardBasicTypes.DATE, false));
        this.uniqueDelegate = new InformixUniqueDelegate((Dialect)this);
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select " + this.getSelectSequenceNextValString(sequenceName) + " from dual";
    }

    public String getCurrentTimestampSelectString() {
        return "select current year to fraction(5) as timestamp from dual";
    }

    public LimitHandler getLimitHandler() {
        return Informix10LimitHandler.INSTANCE;
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }
}

