/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.SQLException;
import org.hibernate.Hibernate;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.ViolatedConstraintNameExtracter;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class GBasedbtDialect
extends Dialect {
    private static ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        public String extractConstraintName(SQLException sqle) {
            int i;
            String constraintName = null;
            int errorCode = JDBCExceptionHelper.extractErrorCode((SQLException)sqle);
            if (errorCode == -268) {
                constraintName = this.extractUsingTemplate("Unique constraint (", ") violated.", sqle.getMessage());
            } else if (errorCode == -691) {
                constraintName = this.extractUsingTemplate("Missing key in referenced table for referential constraint (", ").", sqle.getMessage());
            } else if (errorCode == -692) {
                constraintName = this.extractUsingTemplate("Key value for constraint (", ") is still being referenced.", sqle.getMessage());
            }
            if (constraintName != null && (i = constraintName.indexOf(46)) != -1) {
                constraintName = constraintName.substring(i + 1);
            }
            return constraintName;
        }
    };

    public GBasedbtDialect() {
        this.registerHibernateType(16, Hibernate.BOOLEAN.getName());
        this.registerHibernateType(-16, Hibernate.STRING.getName());
        this.registerHibernateType(-4, Hibernate.BINARY.getName());
        this.registerHibernateType(-1, Hibernate.STRING.getName());
        this.registerHibernateType(-15, Hibernate.STRING.getName());
        this.registerHibernateType(0, Hibernate.STRING.getName());
        this.registerHibernateType(-9, Hibernate.STRING.getName());
        this.registerColumnType(-5, "int8");
        this.registerColumnType(-2, "byte");
        this.registerColumnType(2004, "clob");
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(1, "char($l)");
        this.registerColumnType(2005, "clob");
        this.registerColumnType(91, "date");
        this.registerColumnType(3, "decimal");
        this.registerColumnType(8, "float");
        this.registerColumnType(6, "smallfloat");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-4, "blob");
        this.registerColumnType(-1, 32765, "varchar($1)");
        this.registerColumnType(-1, "clob");
        this.registerColumnType(2, "decimal");
        this.registerColumnType(7, "smallfloat");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(93, "datetime year to fraction(5)");
        this.registerColumnType(92, "datetime hour to second");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(-3, "byte");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(12, 4000, "varchar($l)");
        this.registerFunction("coalesce", (SQLFunction)new StandardSQLFunction("coalesce"));
        this.registerFunction("abs", (SQLFunction)new StandardSQLFunction("abs"));
        this.registerFunction("sign", (SQLFunction)new StandardSQLFunction("sign", (Type)Hibernate.INTEGER));
        this.registerFunction("acos", (SQLFunction)new StandardSQLFunction("acos", (Type)Hibernate.DOUBLE));
        this.registerFunction("asin", (SQLFunction)new StandardSQLFunction("asin", (Type)Hibernate.DOUBLE));
        this.registerFunction("atan", (SQLFunction)new StandardSQLFunction("atan", (Type)Hibernate.DOUBLE));
        this.registerFunction("cos", (SQLFunction)new StandardSQLFunction("cos", (Type)Hibernate.DOUBLE));
        this.registerFunction("cosh", (SQLFunction)new StandardSQLFunction("cosh", (Type)Hibernate.DOUBLE));
        this.registerFunction("exp", (SQLFunction)new StandardSQLFunction("exp", (Type)Hibernate.DOUBLE));
        this.registerFunction("ln", (SQLFunction)new StandardSQLFunction("ln", (Type)Hibernate.DOUBLE));
        this.registerFunction("sin", (SQLFunction)new StandardSQLFunction("sin", (Type)Hibernate.DOUBLE));
        this.registerFunction("sinh", (SQLFunction)new StandardSQLFunction("sinh", (Type)Hibernate.DOUBLE));
        this.registerFunction("sqrt", (SQLFunction)new StandardSQLFunction("sqrt", (Type)Hibernate.DOUBLE));
        this.registerFunction("tan", (SQLFunction)new StandardSQLFunction("tan", (Type)Hibernate.DOUBLE));
        this.registerFunction("tanh", (SQLFunction)new StandardSQLFunction("tanh", (Type)Hibernate.DOUBLE));
        this.registerFunction("variance", (SQLFunction)new StandardSQLFunction("variance", (Type)Hibernate.DOUBLE));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round"));
        this.registerFunction("trunc", (SQLFunction)new StandardSQLFunction("trunc"));
        this.registerFunction("ceil", (SQLFunction)new StandardSQLFunction("ceil"));
        this.registerFunction("floor", (SQLFunction)new StandardSQLFunction("floor"));
        this.registerFunction("chr", (SQLFunction)new StandardSQLFunction("chr", (Type)Hibernate.CHARACTER));
        this.registerFunction("initcap", (SQLFunction)new StandardSQLFunction("initcap"));
        this.registerFunction("lower", (SQLFunction)new StandardSQLFunction("lower"));
        this.registerFunction("ltrim", (SQLFunction)new StandardSQLFunction("ltrim"));
        this.registerFunction("rtrim", (SQLFunction)new StandardSQLFunction("rtrim"));
        this.registerFunction("upper", (SQLFunction)new StandardSQLFunction("upper"));
        this.registerFunction("ascii", (SQLFunction)new StandardSQLFunction("ascii", (Type)Hibernate.INTEGER));
        this.registerFunction("to_char", (SQLFunction)new StandardSQLFunction("to_char", (Type)Hibernate.STRING));
        this.registerFunction("to_date", (SQLFunction)new StandardSQLFunction("to_date", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("sysdate", (SQLFunction)new NoArgSQLFunction("sysdate", (Type)Hibernate.DATE, false));
        this.registerFunction("current_timestamp", (SQLFunction)new NoArgSQLFunction("current year to fraction(5)", (Type)Hibernate.TIMESTAMP, false));
        this.registerFunction("current_date", (SQLFunction)new NoArgSQLFunction("today", (Type)Hibernate.DATE, false));
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)Hibernate.STRING, "", "||", ""));
        this.registerFunction("instr", (SQLFunction)new StandardSQLFunction("instr", (Type)Hibernate.INTEGER));
        this.registerFunction("lpad", (SQLFunction)new StandardSQLFunction("lpad", (Type)Hibernate.STRING));
        this.registerFunction("replace", (SQLFunction)new StandardSQLFunction("replace", (Type)Hibernate.STRING));
        this.registerFunction("rpad", (SQLFunction)new StandardSQLFunction("rpad", (Type)Hibernate.STRING));
        this.registerFunction("substr", (SQLFunction)new StandardSQLFunction("substr", (Type)Hibernate.STRING));
        this.registerFunction("substrb", (SQLFunction)new StandardSQLFunction("substrb", (Type)Hibernate.STRING));
        this.registerFunction("translate", (SQLFunction)new StandardSQLFunction("translate", (Type)Hibernate.STRING));
        this.registerFunction("substring", (SQLFunction)new StandardSQLFunction("substring", (Type)Hibernate.STRING));
        this.registerFunction("atan2", (SQLFunction)new StandardSQLFunction("atan2", (Type)Hibernate.FLOAT));
        this.registerFunction("log", (SQLFunction)new StandardSQLFunction("log", (Type)Hibernate.INTEGER));
        this.registerFunction("mod", (SQLFunction)new StandardSQLFunction("mod", (Type)Hibernate.INTEGER));
        this.registerFunction("nvl", (SQLFunction)new StandardSQLFunction("nvl"));
        this.registerFunction("nvl2", (SQLFunction)new StandardSQLFunction("nvl2"));
        this.registerFunction("power", (SQLFunction)new StandardSQLFunction("power", (Type)Hibernate.FLOAT));
    }

    public String getAddColumnString() {
        return "add";
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentitySelectString(String table, String column, int type) throws MappingException {
        return type == -5 ? "select dbinfo('serial8') from dual" : "select dbinfo('sqlca.sqlerrd1')dual";
    }

    public String getIdentityColumnString(int type) throws MappingException {
        return type == -5 ? "serial8 not null" : "serial not null";
    }

    public boolean hasDataTypeInIdentityColumn() {
        return false;
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        StringBuffer result = new StringBuffer(30);
        result.append(" add constraint ").append(" foreign key (").append(StringHelper.join((String)", ", (String[])foreignKey)).append(") references ").append(referencedTable);
        if (!referencesPrimaryKey) {
            result.append(" (").append(StringHelper.join((String)", ", (String[])primaryKey)).append(')');
        }
        result.append(" constraint ").append(constraintName);
        return result.toString();
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " add constraint primary key constraint " + constraintName + " ";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName + " restrict";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select " + this.getSelectSequenceNextValString(sequenceName) + " from dual";
    }

    public String getSelectSequenceNextValString(String sequenceName) {
        return sequenceName + ".nextval";
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String getLimitString(String querySelect, int offset, int limit) {
        return new StringBuffer(querySelect.length() + 8).append(querySelect).insert(querySelect.toLowerCase().indexOf("select") + 6, " skip " + offset + " first " + limit).toString();
    }

    public boolean supportsVariableLimit() {
        return false;
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "select current year to fraction(5) as timestamp from dual";
    }
}

