/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.InformixDialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.dialect.identity.GBasedbtIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.Informix10LimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.unique.GBasedbtUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class GBasedbtDialect
extends InformixDialect {
    private final UniqueDelegate uniqueDelegate;

    public GBasedbtDialect() {
        this.registerColumnType(-5, "int8");
        this.registerColumnType(-2, "byte");
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(1, "char($l)");
        this.registerColumnType(91, "date");
        this.registerColumnType(3, "decimal");
        this.registerColumnType(8, "float");
        this.registerColumnType(6, "smallfloat");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-4, "blob");
        this.registerColumnType(-1, "clob");
        this.registerColumnType(2, "decimal");
        this.registerColumnType(-5, "decimal($p,0)");
        this.registerColumnType(7, "smallfloat");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(93, "datetime year to fraction(5)");
        this.registerColumnType(92, "datetime hour to second");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(-3, "byte");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(12, 4000L, "varchar($l)");
        this.registerColumnType(63, "varchar2($l)");
        this.registerColumnType(63, 4000L, "varchar2($l)");
        this.registerFunction("coalesce", (SQLFunction)new StandardSQLFunction("coalesce"));
        this.registerFunction("abs", (SQLFunction)new StandardSQLFunction("abs"));
        this.registerFunction("sign", (SQLFunction)new StandardSQLFunction("sign", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("acos", (SQLFunction)new StandardSQLFunction("acos", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("asin", (SQLFunction)new StandardSQLFunction("asin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("atan", (SQLFunction)new StandardSQLFunction("atan", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("cos", (SQLFunction)new StandardSQLFunction("cos", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("cosh", (SQLFunction)new StandardSQLFunction("cosh", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("exp", (SQLFunction)new StandardSQLFunction("exp", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ln", (SQLFunction)new StandardSQLFunction("ln", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("sin", (SQLFunction)new StandardSQLFunction("sin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("sinh", (SQLFunction)new StandardSQLFunction("sinh", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("sqrt", (SQLFunction)new StandardSQLFunction("sqrt", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("tan", (SQLFunction)new StandardSQLFunction("tan", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("tanh", (SQLFunction)new StandardSQLFunction("tanh", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("variance", (SQLFunction)new StandardSQLFunction("variance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round"));
        this.registerFunction("trunc", (SQLFunction)new StandardSQLFunction("trunc"));
        this.registerFunction("ceil", (SQLFunction)new StandardSQLFunction("ceil"));
        this.registerFunction("floor", (SQLFunction)new StandardSQLFunction("floor"));
        this.registerFunction("chr", (SQLFunction)new StandardSQLFunction("chr", (Type)StandardBasicTypes.CHARACTER));
        this.registerFunction("initcap", (SQLFunction)new StandardSQLFunction("initcap"));
        this.registerFunction("lower", (SQLFunction)new StandardSQLFunction("lower"));
        this.registerFunction("ltrim", (SQLFunction)new StandardSQLFunction("ltrim"));
        this.registerFunction("rtrim", (SQLFunction)new StandardSQLFunction("rtrim"));
        this.registerFunction("upper", (SQLFunction)new StandardSQLFunction("upper"));
        this.registerFunction("ascii", (SQLFunction)new StandardSQLFunction("ascii", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("to_char", (SQLFunction)new StandardSQLFunction("to_char", (Type)StandardBasicTypes.STRING));
        this.registerFunction("to_date", (SQLFunction)new StandardSQLFunction("to_date", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("sysdate", (SQLFunction)new NoArgSQLFunction("sysdate", (Type)StandardBasicTypes.DATE, false));
        this.registerFunction("current_timestamp", (SQLFunction)new NoArgSQLFunction("current year to fraction(5)", (Type)StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("current_date", (SQLFunction)new NoArgSQLFunction("today", (Type)StandardBasicTypes.DATE, false));
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)StandardBasicTypes.STRING, "", "||", ""));
        this.registerFunction("instr", (SQLFunction)new StandardSQLFunction("instr", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("lpad", (SQLFunction)new StandardSQLFunction("lpad", (Type)StandardBasicTypes.STRING));
        this.registerFunction("replace", (SQLFunction)new StandardSQLFunction("replace", (Type)StandardBasicTypes.STRING));
        this.registerFunction("rpad", (SQLFunction)new StandardSQLFunction("rpad", (Type)StandardBasicTypes.STRING));
        this.registerFunction("substr", (SQLFunction)new StandardSQLFunction("substr", (Type)StandardBasicTypes.STRING));
        this.registerFunction("substrb", (SQLFunction)new StandardSQLFunction("substrb", (Type)StandardBasicTypes.STRING));
        this.registerFunction("translate", (SQLFunction)new StandardSQLFunction("translate", (Type)StandardBasicTypes.STRING));
        this.registerFunction("substring", (SQLFunction)new StandardSQLFunction("substring", (Type)StandardBasicTypes.STRING));
        this.registerFunction("atan2", (SQLFunction)new StandardSQLFunction("atan2", (Type)StandardBasicTypes.FLOAT));
        this.registerFunction("log", (SQLFunction)new StandardSQLFunction("log", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("mod", (SQLFunction)new StandardSQLFunction("mod", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("nvl", (SQLFunction)new StandardSQLFunction("nvl"));
        this.registerFunction("nvl2", (SQLFunction)new StandardSQLFunction("nvl2"));
        this.registerFunction("power", (SQLFunction)new StandardSQLFunction("power", (Type)StandardBasicTypes.FLOAT));
        this.registerFunction("second", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "gbase_to_char(?1,'%S')"));
        this.registerFunction("minute", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "gbase_to_char(?1,'%M')"));
        this.registerFunction("hour", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "gbase_to_char(?1,'%H')"));
        this.registerFunction("day", (SQLFunction)new StandardSQLFunction("day", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("month", (SQLFunction)new StandardSQLFunction("month", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("year", (SQLFunction)new StandardSQLFunction("year", (Type)StandardBasicTypes.INTEGER));
        this.uniqueDelegate = new GBasedbtUniqueDelegate((Dialect)this);
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select " + this.getSelectSequenceNextValString(sequenceName) + " from dual";
    }

    public String getAddColumnString() {
        return "add (";
    }

    public String getAddColumnSuffixString() {
        return ")";
    }

    public String getQuerySequencesString() {
        return "select tabname from systables where tabtype='Q'";
    }

    public String getCurrentTimestampSelectString() {
        return "select current year to fraction(5) as timestamp from dual";
    }

    public LimitHandler getLimitHandler() {
        return Informix10LimitHandler.INSTANCE;
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return new GBasedbtIdentityColumnSupport();
    }
}

