/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.unique;

import java.util.Iterator;
import org.hibernate.boot.Metadata;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.unique.DefaultUniqueDelegate;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.UniqueKey;

public class GBasedbtUniqueDelegate
extends DefaultUniqueDelegate {
    public GBasedbtUniqueDelegate(Dialect dialect) {
        super(dialect);
    }

    public String getAlterTableToAddUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata) {
        String tableName = metadata.getDatabase().getJdbcEnvironment().getQualifiedObjectNameFormatter().format(uniqueKey.getTable().getQualifiedTableName(), metadata.getDatabase().getJdbcEnvironment().getDialect());
        String constraintName = this.dialect.quote(uniqueKey.getName());
        return "create unique index " + constraintName + " on " + tableName + this.uniqueConstraintSql(uniqueKey);
    }

    protected String uniqueConstraintSql(UniqueKey uniqueKey) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Iterator columnIterator = uniqueKey.columnIterator();
        while (columnIterator.hasNext()) {
            Column column = (Column)columnIterator.next();
            sb.append(column.getQuotedName(this.dialect));
            if (uniqueKey.getColumnOrderMap().containsKey(column)) {
                sb.append(" ").append((String)uniqueKey.getColumnOrderMap().get(column));
            }
            if (!columnIterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.append(")").toString();
    }

    public String getAlterTableToDropUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata) {
        JdbcEnvironment jdbcEnvironment = metadata.getDatabase().getJdbcEnvironment();
        String tableName = jdbcEnvironment.getQualifiedObjectNameFormatter().format(uniqueKey.getTable().getQualifiedTableName(), this.dialect);
        StringBuilder buf = new StringBuilder();
        buf.append("drop index if exists ");
        buf.append(this.dialect.quote(uniqueKey.getName()));
        return buf.toString();
    }
}

