/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.SQLException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.GBasedbtSqlAstTranslator;
import org.hibernate.dialect.GBasedbtSqmToSqlAstConverter;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.function.CaseLeastGreatestEmulation;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.GBasedbtIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.SkipFirstLimitHandler;
import org.hibernate.dialect.sequence.GBasedbtSequenceSupport;
import org.hibernate.dialect.sequence.SequenceInformationExtractorGBasedbtDatabaseImpl;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.unique.GBasedbtUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.sql.StandardSqmTranslatorFactory;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class GBasedbtDialect
extends Dialect {
    private final UniqueDelegate uniqueDelegate = new GBasedbtUniqueDelegate(this);
    private final LimitHandler limitHandler = new SkipFirstLimitHandler(true);
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        String constraintName;
        switch (JdbcExceptionHelper.extractErrorCode((SQLException)sqle)) {
            case -268: {
                constraintName = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"Unique constraint (", (String)") violated.", (String)sqle.getMessage());
                break;
            }
            case -691: {
                constraintName = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"Missing key in referenced table for referential constraint (", (String)").", (String)sqle.getMessage());
                break;
            }
            case -692: {
                constraintName = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"Key value for constraint (", (String)") is still being referenced.", (String)sqle.getMessage());
                break;
            }
            default: {
                return null;
            }
        }
        int i = constraintName.indexOf(46);
        if (i != -1) {
            constraintName = constraintName.substring(i + 1);
        }
        return constraintName;
    });

    public GBasedbtDialect(DialectResolutionInfo info) {
        this(info.makeCopy());
        this.registerKeywords(info);
    }

    public GBasedbtDialect() {
        this(DatabaseVersion.make((Integer)8, (Integer)8));
    }

    public GBasedbtDialect(DatabaseVersion version) {
        super(version);
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -6: {
                return "smallint";
            }
            case -5: {
                return "bigint";
            }
            case 92: {
                return "datetime hour to second";
            }
            case 93: {
                return "datetime year to fraction($p)";
            }
            case 2014: {
                return "timestamp with time zone";
            }
            case -3: 
            case -2: 
            case 4003: {
                return "byte";
            }
            case 4001: 
            case 4002: {
                return "text";
            }
            case 12: {
                return "varchar($1)";
            }
            case -9: {
                return "nvarchar($l)";
            }
            case 63: {
                return "varchar2($1)";
            }
            case 64: {
                return "nvarchar2($1)";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)6, (String)"float($p)", (Dialect)this).withTypeCapacity(24L, "smallfloat").build());
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)12, (String)this.columnType(4001), (Dialect)this).withTypeCapacity(1024L, "varchar($l)").withTypeCapacity((long)this.getMaxVarcharLength(), this.columnType(12)).build());
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)-9, (String)this.columnType(4002), (Dialect)this).withTypeCapacity(1024L, "varchar($l)").withTypeCapacity((long)this.getMaxNVarcharLength(), this.columnType(-9)).build());
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)63, (String)this.columnType(4002), (Dialect)this).withTypeCapacity(1024L, "varchar2($l)").withTypeCapacity((long)this.getMaxNVarcharLength(), this.columnType(63)).build());
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)64, (String)this.columnType(4002), (Dialect)this).withTypeCapacity(1024L, "nvarchar2($l)").withTypeCapacity((long)this.getMaxNVarcharLength(), this.columnType(64)).build());
    }

    public boolean useMaterializedLobWhenCapacityExceeded() {
        return false;
    }

    public int getMaxVarbinaryLength() {
        return -1;
    }

    public int getMaxVarcharLength() {
        return 32739;
    }

    public int getDefaultDecimalPrecision() {
        return 32;
    }

    public int getDefaultTimestampPrecision() {
        return 5;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.substring_substr();
        functionFactory.trunc();
        functionFactory.trim2();
        functionFactory.space();
        functionFactory.reverse();
        functionFactory.octetLength();
        functionFactory.degrees();
        functionFactory.radians();
        functionFactory.sinh();
        functionFactory.tanh();
        functionFactory.cosh();
        functionFactory.moreHyperbolic();
        functionFactory.log10();
        functionFactory.initcap();
        functionFactory.yearMonthDay();
        functionFactory.ceiling_ceil();
        functionFactory.concat_pipeOperator();
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.addMonths();
        functionFactory.monthsBetween();
        functionFactory.stddev();
        functionFactory.variance();
        functionFactory.locate_positionSubstring();
        functionContributions.getFunctionRegistry().register("least", (SqmFunctionDescriptor)new CaseLeastGreatestEmulation(true));
        functionContributions.getFunctionRegistry().register("greatest", (SqmFunctionDescriptor)new CaseLeastGreatestEmulation(false));
        if (this.supportsWindowFunctions()) {
            functionFactory.windowFunctions();
        }
    }

    public SqmTranslatorFactory getSqmTranslatorFactory() {
        return new StandardSqmTranslatorFactory(){

            public SqmTranslator<SelectStatement> createSelectTranslator(SqmSelectStatement<?> sqmSelectStatement, QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings, LoadQueryInfluencers loadQueryInfluencers, SqlAstCreationContext creationContext, boolean deduplicateSelectionItems) {
                return new GBasedbtSqmToSqlAstConverter((SqmStatement<?>)sqmSelectStatement, queryOptions, domainParameterXref, domainParameterBindings, loadQueryInfluencers, creationContext, deduplicateSelectionItems);
            }
        };
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new GBasedbtSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case SECOND: {
                return "to_number(gbase_to_char(?2,'%S'))";
            }
            case MINUTE: {
                return "to_number(gbase_to_char(?2,'%M'))";
            }
            case HOUR: {
                return "to_number(gbase_to_char(?2,'%H'))";
            }
            case DAY_OF_WEEK: {
                return "(weekday(?2)+1)";
            }
            case DAY_OF_MONTH: {
                return "day(?2)";
            }
        }
        return "?1(?2)";
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        StringBuilder result = new StringBuilder(30).append(" add constraint ").append(" foreign key (").append(String.join((CharSequence)", ", foreignKey)).append(") references ").append(referencedTable);
        if (!referencesPrimaryKey) {
            result.append(" (").append(String.join((CharSequence)", ", primaryKey)).append(')');
        }
        result.append(" constraint ").append(constraintName);
        return result.toString();
    }

    public String getAddForeignKeyConstraintString(String constraintName, String foreignKeyDefinition) {
        return " add constraint " + foreignKeyDefinition + " constraint " + constraintName;
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " add constraint primary key constraint " + constraintName + " ";
    }

    public SequenceSupport getSequenceSupport() {
        return GBasedbtSequenceSupport.INSTANCE;
    }

    public String getQuerySequencesString() {
        return "select systables.tabname as sequence_name,syssequences.* from syssequences join systables on syssequences.tabid=systables.tabid where tabtype='Q'";
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorGBasedbtDatabaseImpl.INSTANCE;
    }

    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    public boolean supportsOrderByInSubquery() {
        return false;
    }

    public boolean supportsWindowFunctions() {
        return this.getVersion().isSameOrAfter(8, 8);
    }

    public boolean supportsLateral() {
        return this.getVersion().isSameOrAfter(8, 8);
    }

    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "select current timestamp from systables where tabid = 1";
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableMutationStrategy(TemporaryTable.createIdTable((EntityMappingType)rootEntityDescriptor, basename -> "HT_" + basename, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable((EntityMappingType)rootEntityDescriptor, name -> "HTE_" + name, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.LOCAL;
    }

    public String getTemporaryTableCreateOptions() {
        return "with no log";
    }

    public String getTemporaryTableCreateCommand() {
        return "create temp table";
    }

    public AfterUseAction getTemporaryTableAfterUseAction() {
        return AfterUseAction.NONE;
    }

    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return BeforeUseAction.CREATE;
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return GBasedbtIdentityColumnSupport.INSTANCE;
    }

    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool ? "'t'" : "'f'");
    }

    public String currentDate() {
        return "today";
    }

    public String currentTimestamp() {
        return "current";
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(GBasedbtDialect.datetimeFormat(format).result());
    }

    public static Replacer datetimeFormat(String format) {
        return new Replacer(format, "'", "").replace("%", "%%").replace("yyyy", "%Y").replace("yyy", "%Y").replace("yy", "%y").replace("y", "Y").replace("MMMM", "%B").replace("MMM", "%b").replace("MM", "%m").replace("M", "%c").replace("EEEE", "%A").replace("EEE", "%a").replace("ee", "%w").replace("e", "%w").replace("dd", "%d").replace("d", "%e").replace("a", "%p").replace("hh", "%I").replace("HH", "%H").replace("h", "%I").replace("H", "%H").replace("mm", "%M").replace("m", "%M").replace("ss", "%S").replace("s", "%S").replace("SSSSSS", "%F50").replace("SSSSS", "%F5").replace("SSSS", "%F4").replace("SSS", "%F3").replace("SS", "%F2").replace("S", "%F1");
    }
}

