/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.asf;

import com.gbasedbt.asf.IfxASFException;
import com.gbasedbt.lang.IfxToJavaType;
import com.gbasedbt.lang.Interval;
import com.gbasedbt.util.IfxErrMsg;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

public class IfxDataInputStream
extends FilterInputStream {
    private InputStream is;
    private final int one = 1;
    private boolean usestrenc = false;
    private byte[] smint_buf = new byte[2];
    private byte[] int_buf = new byte[4];
    private byte[] lgint_buf = new byte[10];
    private byte[] long_buf = new byte[8];
    private String ClientLocale = null;
    private IfxToJavaType ifxtojava = new IfxToJavaType();

    public IfxDataInputStream(InputStream inputStream) {
        super(inputStream);
        this.is = inputStream;
    }

    public IfxDataInputStream(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.is = inputStream;
        this.usestrenc = bl;
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.is.read(byArray);
    }

    public byte readByte() throws IOException {
        int n2 = this.is.read();
        return (byte)n2;
    }

    public int readFully(byte[] byArray) throws IOException {
        return this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.is.read(byArray, n2, n3);
    }

    public int readFully(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = 0;
        for (n4 = 0; n4 < n3; n4 += n5) {
            n5 = this.is.read(byArray, n2 + n4, n3 - n4);
            if (n5 >= 0) continue;
            throw new IOException();
        }
        return n4;
    }

    public int readPadded(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        n4 = this.readFully(byArray, n2, n3);
        if ((n3 & 1) >= 1) {
            this.read();
        }
        return n4;
    }

    public int readPadded(byte[] byArray) throws IOException {
        int n2 = this.readFully(byArray, 0, byArray.length);
        if ((byArray.length & 1) >= 1) {
            this.read();
        }
        return n2;
    }

    public int skipBytes(int n2) throws IOException {
        int n3 = 0;
        while ((n3 += (int)this.is.skip(n2 - n3)) < n2) {
        }
        return n2;
    }

    public int readInt() throws IOException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaInt(this.int_buf);
    }

    public String readChar() throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s2 = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (s2 < 0) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        byte[] byArray = new byte[s2];
        int n2 = 0;
        int n3 = 0;
        int n4 = byArray.length;
        n2 = this.readFully(byArray, n3, n4);
        n4 -= n2;
        n3 += n2;
        if ((byArray.length & 1) >= 1) {
            this.read();
        }
        return this.ifxtojava.IfxToJavaChar(byArray, this.usestrenc);
    }

    public String readChar(String string) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s2 = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (s2 < 0) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        byte[] byArray = new byte[s2];
        int n2 = 0;
        int n3 = 0;
        int n4 = byArray.length;
        n2 = this.readFully(byArray, n3, n4);
        n4 -= n2;
        n3 += n2;
        if ((byArray.length & 1) >= 1) {
            this.read();
        }
        return this.ifxtojava.IfxToJavaChar(byArray, string, this.usestrenc);
    }

    public Date readDate() throws IOException, IfxASFException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaDate(this.int_buf);
    }

    public Timestamp readDateTime(short s2) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s3 = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (s3 < 0) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        byte[] byArray = new byte[s3];
        this.readFully(byArray, 0, byArray.length);
        if ((s3 & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaDateTime(byArray, s2);
    }

    public byte[] readRawDateTime(short s2) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s3 = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (s3 < 0) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        byte[] byArray = new byte[s3];
        this.readFully(byArray, 0, byArray.length);
        if ((s3 & 1) >= 1) {
            this.read();
        }
        return byArray;
    }

    public Interval readInterval(short s2) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s3 = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (s3 < 0) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        byte[] byArray = new byte[s3];
        this.readFully(byArray, 0, byArray.length);
        if ((s3 & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaInterval(byArray, s2);
    }

    public BigDecimal readDecimal(short s2) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s3 = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (s3 < 0) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        byte[] byArray = new byte[s3];
        this.readFully(byArray, 0, byArray.length);
        if ((s3 & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaDecimal(byArray, s2);
    }

    public double readDouble(short s2) throws IOException, IfxASFException {
        this.readFully(this.long_buf, 0, this.long_buf.length);
        return IfxToJavaType.IfxToJavaDouble(this.long_buf);
    }

    public float readReal(short s2) throws IOException, IfxASFException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaReal(this.int_buf);
    }

    public short readSmallInt() throws IOException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        return IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
    }

    public short readShort() throws IOException {
        return this.readSmallInt();
    }

    public long readLongInt() throws IOException {
        this.readFully(this.lgint_buf, 0, this.lgint_buf.length);
        return IfxToJavaType.IfxToJavaLongInt(this.lgint_buf);
    }

    public long readLong() throws IOException {
        return this.readLongInt();
    }

    public void setClientLocale(String string) {
        this.ClientLocale = string;
    }

    public String getClientLocale() {
        return this.ClientLocale;
    }

    public long readLongBigint() throws IOException {
        this.readFully(this.long_buf, 0, this.long_buf.length);
        return IfxToJavaType.IfxToJavaLongBigInt(this.long_buf);
    }

    public void closeStream() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void clearTrace() {
    }
}

