/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxObject;
import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.lang.IfxToJavaType;
import com.gbasedbt.lang.JavaToIfxType;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.dateUtil;
import com.gbasedbt.util.memoryUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;

public class IfxDate
extends IfxObject {
    private Date h = null;
    public static final int IFX_DATE_NULL = Integer.MIN_VALUE;

    IfxDate() throws SQLException {
        this.setIfxType(7);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    IfxDate(Date date) throws SQLException {
        this.setIfxType(7);
        this.h = date;
        if (this.h == null) {
            this.nullify();
            if (IfxSqliConnect.b1 == 0) return;
        }
        this.unnullify();
    }

    public Date value() {
        return this.h;
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.h;
    }

    @Override
    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxDate(this.h);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] byArray = new byte[4];
            memoryUtil.byfill(byArray, (byte)0);
            byArray[0] = -128;
            return byArray;
        }
        return JavaToIfxType.JavaToIfxDate(this.h);
    }

    @Override
    public void fromIfx(byte[] byArray) {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n2, int n3) {
        block5: {
            block4: {
                this.h = IfxToJavaType.IfxToJavaDate(byArray, n2);
                if (this.h != null) break block4;
                this.nullify();
                if (IfxSqliConnect.b1 == 0) break block5;
            }
            this.unnullify();
        }
    }

    @Override
    public String toString() {
        String string = null;
        if (this.isNull()) {
            return null;
        }
        try {
            string = dateUtil.convertDateStr(this.h, this.conn);
        }
        catch (SQLException sQLException) {
            string = null;
            return null;
        }
        return string;
    }

    @Override
    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.nullify();
            return;
        }
        try {
            this.h = dateUtil.convertDateObj(string.trim(), this.conn);
            this.unnullify();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.nullify();
            throw IfxErrMsg.getSQLException(-79716, illegalArgumentException.toString(), this.conn);
        }
    }

    @Override
    public Timestamp toTimestamp() {
        if (this.isNull()) {
            return null;
        }
        return new Timestamp(this.h.getTime());
    }

    @Override
    public void fromTimestamp(Timestamp timestamp) {
        block5: {
            block4: {
                if (timestamp != null) break block4;
                this.nullify();
                if (IfxSqliConnect.b1 == 0) break block5;
            }
            this.h = new Date(timestamp.getTime());
            this.unnullify();
        }
    }

    @Override
    public Date toDate() {
        if (this.isNull()) {
            return null;
        }
        return this.h;
    }

    @Override
    public void fromDate(Date date) {
        block5: {
            block4: {
                if (date != null) break block4;
                this.nullify();
                if (IfxSqliConnect.b1 == 0) break block5;
            }
            this.h = date;
            this.unnullify();
        }
    }

    @Override
    public boolean equals(Object object) {
        block10: {
            block9: {
                if (this.isNull() || object == null) break block9;
                if (object instanceof IfxDate) break block10;
            }
            return false;
        }
        IfxDate ifxDate = (IfxDate)object;
        if (ifxDate.isNull()) {
            return false;
        }
        return this.h.equals(ifxDate.h);
    }

    @Override
    public String toUnloadString() {
        return this.toString();
    }
}

