/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jns;

import com.gbasedbt.jns.IfxJNSException;
import com.gbasedbt.jns.LdapSqlhosts;
import com.gbasedbt.jns.ServerGroup;
import com.gbasedbt.jns.ServerInfo;
import com.gbasedbt.util.IfxErrMsg;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class FileSqlhosts {
    final String bGroupOpt = "g";
    final String eGroupOpt = "e";
    final char cmtChar = (char)35;
    String fileName;
    Vector srvrVect = new Vector();
    Hashtable srvrList = new Hashtable();
    Hashtable grpList = new Hashtable();
    private String ClientLocale = null;

    public FileSqlhosts(Properties properties) throws IfxJNSException {
        Object object;
        this.ClientLocale = properties.getProperty("CLIENT_LOCALE");
        String string = properties.getProperty("SQLH_FILE");
        InputStreamReader inputStreamReader = null;
        try {
            object = new URL(string);
            inputStreamReader = new InputStreamReader(((URL)object).openStream());
        }
        catch (MalformedURLException malformedURLException) {
            try {
                inputStreamReader = new FileReader(string);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getLocIfxJNSException(-25553, this.ClientLocale);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getLocIfxJNSException(-25553, this.ClientLocale);
        }
        try {
            String string2;
            object = new BufferedReader(inputStreamReader);
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                if (this.isBlank(string2) || this.isComment(string2)) continue;
                ServerInfo serverInfo = this.parseToSrvrInfo(string2);
                this.srvrVect.addElement(serverInfo);
                this.srvrList.put(serverInfo.getSname(), serverInfo);
            }
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getLocIfxJNSException(-25553, this.ClientLocale);
        }
        this.collectGroups();
    }

    private void collectGroups() {
        int n2 = this.srvrVect.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ServerInfo serverInfo = (ServerInfo)this.srvrVect.elementAt(i2);
            if (!serverInfo.isGroupEntry()) continue;
            Vector<ServerInfo> vector = new Vector<ServerInfo>();
            String string = serverInfo.getSname();
            String string2 = serverInfo.getOption("e");
            boolean bl = string2 != null;
            for (int i3 = i2 + 1; i3 < n2; ++i3) {
                ServerInfo serverInfo2 = (ServerInfo)this.srvrVect.elementAt(i3);
                String string3 = serverInfo2.getSname();
                String string4 = serverInfo2.getOption("g");
                if (string.equalsIgnoreCase(string4)) {
                    vector.addElement(serverInfo2);
                }
                if (bl && string2.equalsIgnoreCase(string3) || !bl && !string.equalsIgnoreCase(string4)) break;
            }
            this.grpList.put(string, vector);
        }
    }

    public ServerInfo getServer(String string) throws IfxJNSException {
        ServerInfo serverInfo = (ServerInfo)this.srvrList.get(string);
        if (serverInfo != null) {
            return serverInfo;
        }
        throw IfxErrMsg.getLocIfxJNSException(-25555, this.ClientLocale);
    }

    public ServerGroup getServerGroup(String string) throws IfxJNSException {
        Vector vector = (Vector)this.grpList.get(string);
        Vector<String> vector2 = new Vector<String>();
        int n2 = vector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ServerInfo serverInfo = (ServerInfo)vector.elementAt(i2);
            vector2.addElement(serverInfo.getSname());
        }
        return new ServerGroup(vector2);
    }

    public ServerGroup listServers() throws IfxJNSException {
        Vector vector = new Vector();
        Enumeration enumeration = this.srvrList.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return new ServerGroup(vector);
    }

    void uploadToLdap(LdapSqlhosts ldapSqlhosts) throws IfxJNSException {
        try {
            Object object;
            int n2 = this.srvrVect.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                object = (ServerInfo)this.srvrVect.elementAt(i2);
                ldapSqlhosts.addServer((ServerInfo)object);
            }
            Enumeration enumeration = this.grpList.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                Vector vector = (Vector)this.grpList.get(object);
                for (int i3 = 0; i3 < vector.size(); ++i3) {
                    Properties properties = new Properties();
                    ServerInfo serverInfo = (ServerInfo)vector.elementAt(i3);
                    String string = serverInfo.getSname();
                    String string2 = "cn=" + string + "," + "cn=" + (String)object;
                    properties.put("cn", string);
                    properties.put("desc", "SqlHost Grp entry");
                    ldapSqlhosts.addEntry(string2, properties);
                }
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getLocIfxJNSException(-80284, this.ClientLocale);
        }
    }

    private boolean isBlank(String string) {
        String string2 = string.trim();
        return string2.length() == 0;
    }

    private boolean isComment(String string) {
        String string2 = string.trim();
        return string2.charAt(0) == '#';
    }

    private ServerInfo parseToSrvrInfo(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        string2 = stringTokenizer.nextToken();
        string3 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreElements()) {
            string4 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreElements()) {
            string5 = stringTokenizer.nextToken();
        }
        while (stringTokenizer.hasMoreElements()) {
            string6 = string6 + stringTokenizer.nextToken() + " ";
        }
        ServerInfo serverInfo = new ServerInfo(string2, string3, string4, string5, string6);
        return serverInfo;
    }
}

