/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.lang;

import com.gbasedbt.lang.Decimal;
import com.gbasedbt.lang.IfxToJavaType;
import com.gbasedbt.lang.Interval;
import com.gbasedbt.lang.IntervalDF;
import com.gbasedbt.lang.IntervalYM;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.memoryUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public final class JavaToIfxType {
    public static final int IFX_INT_SIZE = 4;
    public static final int BYTESHIFT = 8;
    public static final int BYTEMASK = 255;
    public static final int IFX_LGINT_SIZE = 10;
    public static final int IFX_SMINT_SIZE = 2;
    public static final int IFX_SMFLOAT_SIZE = 4;
    public static final int IFX_LONG_SIZE = 8;
    public static final int IFX_DOUBLE_SIZE = 8;
    public static final int DefDblScale = 10;
    public static final int DefFltScale = 10;
    static final String defaultEncoding = "ISO8859_1";
    CharsetEncoder enc = null;
    CharsetEncoder defenc = null;
    protected static final boolean TruncateFractSec = true;
    static final int NanosPerSecond = 1000000000;
    static final int MilliPerSecond = 1000;
    static final int SecondsPerMinute = 60;
    static final int SecondsPerHour = 3600;
    static final int SecondsPerDay = 86400;
    static final int MonthsPerYear = 12;
    public static byte[] DATETIME_PREC = new byte[2];
    public static short DP_SHORT;

    public static byte[] JavaToIfxInt(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 >> 24), (byte)(n2 >> 16), (byte)(n2 >> 8), (byte)n2};
        return byArray;
    }

    public byte[] JavaToIfxChar(String string, boolean bl) throws UnsupportedEncodingException, SQLException {
        int n2 = string.length();
        byte[] byArray = new byte[n2 + 2];
        byte[] byArray2 = this.getConvertedBytes(string, bl);
        byArray[0] = (byte)(n2 >> 8 & 0xFF);
        byArray[1] = (byte)(n2 & 0xFF);
        System.arraycopy(byArray2, 0, byArray, 2, n2);
        return byArray;
    }

    private byte[] getConvertedBytes(String string, boolean bl) throws SQLException {
        return this.getConvertedBytes(string, bl, defaultEncoding);
    }

    private byte[] getConvertedBytes(String string, boolean bl, String string2) throws SQLException {
        try {
            if (bl) {
                return string.getBytes(string2);
            }
            return this.doConversion(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw IfxErrMsg.getSQLException(-79783, null);
        }
    }

    public byte[] JavaToIfxChar(String string, String string2, boolean bl) throws UnsupportedEncodingException, SQLException {
        byte[] byArray = null;
        byArray = string2 != null ? (string2.equals("NOCODING") ? string.getBytes() : this.getConvertedBytes(string, bl, string2)) : this.getConvertedBytes(string, bl);
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 2];
        byArray2[0] = (byte)(n2 >> 8 & 0xFF);
        byArray2[1] = (byte)(n2 & 0xFF);
        System.arraycopy(byArray, 0, byArray2, 2, n2);
        return byArray2;
    }

    public byte[] JavaToIfx4BytesChar(String string, boolean bl) throws UnsupportedEncodingException, SQLException {
        int n2 = string.length();
        byte[] byArray = new byte[n2 + 4];
        byte[] byArray2 = this.getConvertedBytes(string, bl);
        byArray[0] = (byte)(n2 >> 24 & 0xFF);
        byArray[1] = (byte)(n2 >> 16 & 0xFF);
        byArray[2] = (byte)(n2 >> 8 & 0xFF);
        byArray[3] = (byte)(n2 & 0xFF);
        System.arraycopy(byArray2, 0, byArray, 4, n2);
        return byArray;
    }

    public byte[] JavaToIfx4BytesChar(String string, String string2, boolean bl) throws UnsupportedEncodingException, SQLException {
        byte[] byArray = null;
        byArray = string2 != null ? (string2.equals("NOCODING") ? string.getBytes() : this.getConvertedBytes(string, bl, string2)) : this.getConvertedBytes(string, bl);
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 4];
        byArray2[0] = (byte)(n2 >> 24 & 0xFF);
        byArray2[1] = (byte)(n2 >> 16 & 0xFF);
        byArray2[2] = (byte)(n2 >> 8 & 0xFF);
        byArray2[3] = (byte)(n2 & 0xFF);
        System.arraycopy(byArray, 0, byArray2, 4, n2);
        return byArray2;
    }

    public byte[] JavaToIfxVarChar(String string, String string2, int n2, boolean bl) throws UnsupportedEncodingException, SQLException {
        byte[] byArray = null;
        byArray = string2 != null ? this.getConvertedBytes(string, bl, string2) : this.getConvertedBytes(string, bl);
        byte[] byArray2 = new byte[n2 + 1];
        memoryUtil.byfill(byArray2, (byte)0);
        int n3 = byArray.length;
        int n4 = Math.min(n3, n2);
        byArray2[0] = (byte)(n4 & 0xFF);
        System.arraycopy(byArray, 0, byArray2, 1, n4);
        return byArray2;
    }

    public byte[] JavaToIfxLvarchar(String string, String string2, boolean bl) throws UnsupportedEncodingException, SQLException {
        byte[] byArray = null;
        byArray = string2 != null ? this.getConvertedBytes(string, bl, string2) : this.getConvertedBytes(string, bl);
        return byArray;
    }

    public static byte[] JavaToIfxDate(Date date) {
        int n2 = IfxToJavaType.convertDateToDays(date);
        return JavaToIfxType.JavaToIfxInt(n2);
    }

    public static String convertNanosToFract(int n2) {
        char[] cArray = new char[5];
        double d2 = (double)n2 / 10000.0 + 0.0;
        String string = Integer.toString((int)d2);
        Decimal.charfill(cArray, 0, 4, '0');
        int n3 = string.length() - 6;
        int n4 = 4;
        int n5 = string.length() - 1;
        while (n5 >= 0 && n5 >= n3) {
            cArray[n4] = string.charAt(n5);
            --n5;
            --n4;
        }
        return new String(cArray);
    }

    public static Decimal convertTimestampToDecimal(Timestamp timestamp) {
        return JavaToIfxType.convertTimestampToDecimal(timestamp, null);
    }

    public static Decimal convertTimestampToDecimal(Timestamp timestamp, Calendar calendar) {
        Calendar calendar2 = calendar;
        if (calendar2 == null) {
            calendar2 = Calendar.getInstance();
        }
        calendar2.setTime(timestamp);
        int n2 = calendar2.get(1);
        int n3 = calendar2.get(2) + 1;
        int n4 = calendar2.get(5);
        int n5 = calendar2.get(11);
        int n6 = calendar2.get(12);
        int n7 = calendar2.get(13);
        int n8 = timestamp.getNanos();
        return new Decimal(n2, n3, n4, n5, n6, n7, n8 / 10000);
    }

    public static Decimal convertTimeToDecimal(Time time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        int n2 = calendar.get(11);
        int n3 = calendar.get(12);
        int n4 = calendar.get(13);
        return new Decimal(0, 0, 0, n2, n3, n4, 0);
    }

    public static String convertIntervalToString(IntervalDF intervalDF) {
        StringBuffer stringBuffer = new StringBuffer();
        short s2 = intervalDF.getQualifier();
        int n2 = Interval.getStartCode(s2);
        byte by = Interval.getEndCode(s2);
        int n3 = intervalDF.getLength() - (by - n2);
        long l2 = intervalDF.getSeconds();
        long l3 = intervalDF.getNanoSeconds();
        if (l2 < 0L || l2 == 0L && l3 < 0L) {
            stringBuffer.append("-");
            l2 = -l2;
            l3 = -l3;
        }
        int n4 = n2;
        block6: while (by >= n4) {
            int n5;
            switch (n4) {
                case 4: {
                    n5 = (int)Math.floor(l2 / 86400L);
                    stringBuffer.append(JavaToIfxType.stringWithLFP(n5, n3));
                    l2 %= 86400L;
                    n4 += 2;
                    continue block6;
                }
                case 6: {
                    n5 = (int)Math.floor(l2 / 3600L);
                    if (n4 == n2) {
                        stringBuffer.append(JavaToIfxType.stringWithLFP(n5, n3));
                    } else {
                        if (n5 < 10 && n4 != n2) {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(String.valueOf(n5));
                    }
                    l2 %= 3600L;
                    n4 += 2;
                    continue block6;
                }
                case 8: {
                    n5 = (int)Math.floor(l2 / 60L);
                    if (n4 == n2) {
                        stringBuffer.append(JavaToIfxType.stringWithLFP(n5, n3));
                    } else {
                        if (n5 < 10 && n4 != n2) {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(String.valueOf(n5));
                    }
                    l2 %= 60L;
                    n4 += 2;
                    continue block6;
                }
                case 10: {
                    if (n4 == n2) {
                        stringBuffer.append(JavaToIfxType.stringWithLFP((int)l2, n3));
                    } else {
                        if (l2 < 10L && n4 != n2) {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(String.valueOf(l2));
                    }
                    ++n4;
                    continue block6;
                }
            }
            stringBuffer.append(".");
            n5 = 15 - by - 1 + 4;
            for (int i2 = 0; i2 <= n5; ++i2) {
                l3 /= 10L;
            }
            stringBuffer.append(String.valueOf(l3));
            ++n4;
        }
        return stringBuffer.toString();
    }

    public static Decimal convertIntervalToDecimal(IntervalDF intervalDF) {
        byte[] byArray = new byte[20];
        boolean bl = false;
        int n2 = 0;
        short s2 = intervalDF.getQualifier();
        int n3 = Interval.getStartCode(s2);
        int n4 = Interval.getEndCode(s2);
        int n5 = intervalDF.getLength() - (n4 - n3);
        long l2 = intervalDF.getSeconds();
        long l3 = intervalDF.getNanoSeconds();
        if (l2 < 0L || l2 == 0L && l3 < 0L) {
            bl = true;
            l2 = -l2;
            l3 = -l3;
        }
        if (n3 == 12) {
            n3 = 11;
        }
        int n6 = 0;
        for (int i2 = n3; n4 >= i2; i2 += n6) {
            int n7;
            int n8;
            int n9;
            switch (i2) {
                case 4: {
                    n9 = (int)(l2 / 86400L);
                    l2 %= 86400L;
                    n6 = 2;
                    break;
                }
                case 6: {
                    n9 = (int)(l2 / 3600L);
                    l2 %= 3600L;
                    n6 = 2;
                    break;
                }
                case 8: {
                    n9 = (int)(l2 / 60L);
                    l2 %= 60L;
                    n6 = 2;
                    break;
                }
                case 10: {
                    n9 = (int)l2;
                    n6 = 1;
                    break;
                }
                default: {
                    n9 = 15 - n4 - 1 + 4;
                    for (n8 = 0; n8 <= n9; ++n8) {
                        l3 /= 10L;
                    }
                    for (n9 = n4 - i2 + 1; n9 > 0; n9 -= 2) {
                        n8 = 1;
                        for (n7 = n9 - 2; n7 > 0; --n7) {
                            n8 *= 10;
                        }
                        if (n9 == 1) {
                            l3 *= 10L;
                        }
                        byArray[n2] = (byte)(l3 / (long)n8);
                        l3 %= (long)n8;
                        ++n2;
                    }
                    i2 += 10;
                }
            }
            if (i2 == n3) {
                if (n5 % 2 > 0) {
                    n8 = 1;
                    for (n7 = --n5; n7 > 0; --n7) {
                        n8 *= 10;
                    }
                    byArray[n2] = (byte)(n9 / n8);
                    n9 %= n8;
                    ++n2;
                }
                while (n5 > 0) {
                    n8 = 1;
                    for (n7 = n5 -= 2; n7 > 0; --n7) {
                        n8 *= 10;
                    }
                    byArray[n2] = (byte)(n9 / n8);
                    n9 %= n8;
                    ++n2;
                }
                continue;
            }
            if (i2 > n4) continue;
            byArray[n2] = (byte)n9;
            ++n2;
        }
        return new Decimal(bl, byArray, n2, intervalDF.getQualifier());
    }

    private static String stringWithLFP(int n2, int n3) {
        int n4;
        String string = "";
        String string2 = String.valueOf(n2);
        for (int i2 = n4 = n3 - string2.length(); i2 > 0; --i2) {
            string = string + "0";
        }
        string = string + string2;
        return string;
    }

    public static String convertIntervalToString(IntervalYM intervalYM) {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        short s2 = intervalYM.getQualifier();
        byte by = Interval.getStartCode(s2);
        byte by2 = Interval.getEndCode(s2);
        int n2 = intervalYM.getLength() - (by2 - by);
        long l2 = intervalYM.getMonths();
        if (l2 < 0L) {
            l2 = -l2;
            stringBuffer.append("-");
        }
        if (by == 2) {
            stringBuffer.append(JavaToIfxType.stringWithLFP((int)l2, n2));
        } else {
            int n3 = (int)(l2 / 12L);
            stringBuffer.append(JavaToIfxType.stringWithLFP(n3, n2));
            if (by2 == 2) {
                string = String.valueOf(l2 % 12L);
                if (string.length() == 1) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public static Decimal convertIntervalToDecimal(IntervalYM intervalYM) {
        byte[] byArray = new byte[20];
        boolean bl = false;
        int n2 = 0;
        short s2 = intervalYM.getQualifier();
        byte by = Interval.getStartCode(s2);
        byte by2 = Interval.getEndCode(s2);
        int n3 = intervalYM.getLength() - (by2 - by);
        long l2 = intervalYM.getMonths();
        if (l2 < 0L) {
            bl = true;
            l2 = -l2;
        }
        if (by == 2) {
            int n4;
            int n5;
            if (n3 % 2 > 0) {
                n5 = 1;
                for (n4 = --n3; n4 > 0; --n4) {
                    n5 *= 10;
                }
                byArray[n2] = (byte)(l2 / (long)n5);
                l2 %= (long)n5;
                ++n2;
            }
            while (n3 > 0) {
                n5 = 1;
                for (n4 = n3 -= 2; n4 > 0; --n4) {
                    n5 *= 10;
                }
                byArray[n2] = (byte)(l2 / (long)n5);
                l2 %= (long)n5;
                ++n2;
            }
        } else {
            int n6;
            int n7;
            int n8 = (int)(l2 / 12L);
            if (n3 % 2 > 0) {
                n7 = 1;
                for (n6 = --n3; n6 > 0; --n6) {
                    n7 *= 10;
                }
                byArray[n2] = (byte)(n8 / n7);
                n8 %= n7;
                ++n2;
            }
            while (n3 > 0) {
                n7 = 1;
                for (n6 = n3 -= 2; n6 > 0; --n6) {
                    n7 *= 10;
                }
                byArray[n2] = (byte)(n8 / n7);
                n8 %= n7;
                ++n2;
            }
            if (by2 == 2) {
                byArray[n2] = (byte)(l2 % 12L);
                ++n2;
            }
        }
        return new Decimal(bl, byArray, n2, intervalYM.getQualifier());
    }

    public static byte[] JavaToIfxDateTime(Timestamp timestamp) {
        return JavaToIfxType.JavaToIfxDateTime(timestamp, null);
    }

    public static byte[] JavaToIfxDateTime(Timestamp timestamp, Calendar calendar) {
        return JavaToIfxType.convertTimestampToDecimal(timestamp, calendar).javaToIfx();
    }

    public static byte[] JavaToIfxDateTime(Time time) {
        return JavaToIfxType.convertTimeToDecimal(time).javaToIfx();
    }

    public static byte[] JavaToIfxInterval(IntervalDF intervalDF) {
        byte[] byArray = JavaToIfxType.convertIntervalToDecimal(intervalDF).javaToIfx();
        return byArray;
    }

    public static byte[] JavaToIfxInterval(IntervalYM intervalYM) {
        byte[] byArray = JavaToIfxType.convertIntervalToDecimal(intervalYM).javaToIfx();
        return byArray;
    }

    public static final byte[] JavaToIfxDecimalNull(short s2) {
        byte by = (byte)(s2 >> 8 & 0xFF);
        byte by2 = (byte)(s2 & 0xF);
        byte by3 = (byte)((by + (by2 & 1) + 1) / 2);
        byte[] byArray = new byte[by3 + 1];
        memoryUtil.byfill(byArray, (byte)0);
        return byArray;
    }

    public static final byte[] JavaToIfxDecimal(BigDecimal bigDecimal) {
        Decimal decimal;
        byte[] byArray = new byte[18];
        if (bigDecimal == null) {
            for (int i2 = 0; i2 < 18; ++i2) {
                byArray[i2] = 0;
            }
            decimal = new Decimal(byArray);
        } else {
            decimal = new Decimal(bigDecimal);
        }
        return decimal.javaToIfx();
    }

    public static final byte[] JavaToIfxDouble(Double d2) {
        return JavaToIfxType.JavaToIfxDouble((double)d2);
    }

    public static final byte[] JavaToIfxDouble(double d2) {
        byte[] byArray = new byte[8];
        long l2 = Double.doubleToLongBits(d2);
        byArray[0] = (byte)(l2 >> 56 & 0xFFL);
        byArray[1] = (byte)(l2 >> 48 & 0xFFL);
        byArray[2] = (byte)(l2 >> 40 & 0xFFL);
        byArray[3] = (byte)(l2 >> 32 & 0xFFL);
        byArray[4] = (byte)(l2 >> 24 & 0xFFL);
        byArray[5] = (byte)(l2 >> 16 & 0xFFL);
        byArray[6] = (byte)(l2 >> 8 & 0xFFL);
        byArray[7] = (byte)(l2 & 0xFFL);
        return byArray;
    }

    public static final byte[] JavaToIfxReal(Float f2) {
        return JavaToIfxType.JavaToIfxReal(f2.floatValue());
    }

    public static byte[] JavaToIfxReal(float f2) {
        int n2 = Float.floatToIntBits(f2);
        return JavaToIfxType.JavaToIfxInt(n2);
    }

    public static byte[] JavaToIfxSmallInt(short s2) {
        byte[] byArray = new byte[]{(byte)(s2 >> 8), (byte)s2};
        return byArray;
    }

    public static byte[] JavaToIfxLongInt(long l2) {
        byte[] byArray = new byte[10];
        short s2 = 1;
        if (l2 < 0L) {
            s2 = -1;
            l2 = -l2;
        }
        byte[] byArray2 = JavaToIfxType.JavaToIfxSmallInt(s2);
        System.arraycopy(byArray2, 0, byArray, 0, 2);
        long l3 = l2 & 0xFFFFFFFFL;
        byte[] byArray3 = JavaToIfxType.JavaToIfxInt((int)l3);
        System.arraycopy(byArray3, 0, byArray, 2, 4);
        int n2 = (int)(l2 >> 32);
        byte[] byArray4 = JavaToIfxType.JavaToIfxInt(n2);
        System.arraycopy(byArray4, 0, byArray, 6, 4);
        return byArray;
    }

    private byte[] doConversion(String string, String string2) throws SQLException {
        byte[] byArray = null;
        CharsetEncoder charsetEncoder = null;
        if (!string2.equals(defaultEncoding)) {
            if (this.enc == null) {
                this.enc = Charset.forName(string2).newEncoder();
            }
            charsetEncoder = this.enc;
        } else {
            if (this.defenc == null) {
                this.defenc = Charset.forName(string2).newEncoder();
            }
            charsetEncoder = this.defenc;
        }
        charsetEncoder.reset();
        charsetEncoder.onMalformedInput(CodingErrorAction.REPORT);
        charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string));
            byArray = JavaToIfxType.copyToByteArray(byteBuffer.array(), byteBuffer.limit());
        }
        catch (CharacterCodingException characterCodingException) {
            throw IfxErrMsg.getSQLException(-23103, null);
        }
        return byArray;
    }

    private static byte[] copyToByteArray(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(n2, byArray.length));
        return byArray2;
    }

    protected static int compareJDKVer(String string) {
        boolean bl = false;
        String string2 = null;
        String string3 = System.getProperty("java.version");
        if (string3 != null && string != null) {
            int n2 = string3.length();
            int n3 = 0;
            while (!bl && n3 < n2) {
                char c2 = string3.charAt(n3);
                if (c2 >= '0' && c2 <= '9') {
                    bl = true;
                    continue;
                }
                ++n3;
            }
            string2 = string3.substring(n3);
            return string2.compareTo(string);
        }
        throw new Error("Error In Comparing JDK Versions");
    }

    public static byte[] JavaToIfxLongBigInt(long l2) {
        byte[] byArray = new byte[]{(byte)(l2 >> 56), (byte)(l2 >> 48), (byte)(l2 >> 40), (byte)(l2 >> 32), (byte)(l2 >> 24), (byte)(l2 >> 16), (byte)(l2 >> 8), (byte)l2};
        return byArray;
    }

    static {
        Decimal.encodeDateTimePrecision(DATETIME_PREC, (byte)0, (byte)15);
        DP_SHORT = (short)(DATETIME_PREC[0] * 256 + DATETIME_PREC[1]);
    }
}

