/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jns;

import com.gbasedbt.jns.FileSqlhosts;
import com.gbasedbt.jns.IfxJNSException;
import com.gbasedbt.jns.LdapSqlhosts;
import com.gbasedbt.jns.ServerGroup;
import com.gbasedbt.jns.ServerInfo;
import java.util.Properties;

public class Sqlhosts {
    static final int LDAP_SQLH = 0;
    static final int FILE_SQLH = 1;
    static final String SQH_DEFAULT = "LDAP";
    private LdapSqlhosts ldapSqlh;
    private FileSqlhosts fileSqlh;
    private int sqlhType;

    public Sqlhosts(Properties properties) throws IfxJNSException {
        String string = SQH_DEFAULT;
        string = properties.getProperty("SQLH_TYPE");
        if (string == null) {
            string = SQH_DEFAULT;
        }
        if (string.equalsIgnoreCase(SQH_DEFAULT)) {
            this.sqlhType = 0;
            this.ldapSqlh = new LdapSqlhosts(properties);
        }
        if (string.equalsIgnoreCase("FILE")) {
            this.sqlhType = 1;
            this.fileSqlh = new FileSqlhosts(properties);
        }
    }

    public ServerInfo getServer(String string) throws IfxJNSException {
        if (this.sqlhType == 1) {
            return this.fileSqlh.getServer(string);
        }
        return this.ldapSqlh.getServer(string);
    }

    public ServerGroup getServerGroup(String string) throws IfxJNSException {
        if (this.sqlhType == 1) {
            return this.fileSqlh.getServerGroup(string);
        }
        return this.ldapSqlh.getServerGroup(string);
    }

    public ServerGroup listServers() throws IfxJNSException {
        if (this.sqlhType == 1) {
            return this.fileSqlh.listServers();
        }
        return this.ldapSqlh.listServers();
    }
}

