/*
 * Decompiled with CFR 0.152.
 */
package org.bson.types;

import com.gbasedbt.jdbc.IfxObject;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.types.Code;

public class ObjectId
implements Comparable<ObjectId>,
Serializable {
    private static final long serialVersionUID = -4415279469780082174L;
    static final Logger a = Logger.getLogger("org.bson.ObjectId");
    final int b;
    final int c;
    final int d;
    boolean e;
    private static AtomicInteger f = new AtomicInteger(new Random().nextInt());
    private static final int g;

    public static ObjectId get() {
        return new ObjectId();
    }

    public static boolean isValid(String string) {
        char c2;
        block27: {
            int n2 = Code.b;
            if (string == null) {
                return false;
            }
            int n3 = string.length();
            if (n3 != 24) {
                return false;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                block30: {
                    char c3;
                    block29: {
                        block28: {
                            c3 = string.charAt(i2);
                            c2 = c3;
                            if (n2 != 0) break block27;
                            if (c2 < '0') break block28;
                            if (c3 > '9') break block28;
                            if (n2 == 0) continue;
                        }
                        if (c3 < 'a') break block29;
                        if (c3 > 'f') break block29;
                        if (n2 == 0) continue;
                    }
                    if (c3 < 'A') break block30;
                    if (c3 > 'F') break block30;
                    if (n2 == 0) continue;
                }
                return false;
            }
            c2 = '\u0001';
        }
        return c2 != '\u0000';
    }

    public static ObjectId massageToObjectId(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ObjectId) {
            return (ObjectId)object;
        }
        if (object instanceof String) {
            String string = object.toString();
            if (ObjectId.isValid(string)) {
                return new ObjectId(string);
            }
        }
        return null;
    }

    public ObjectId(Date date) {
        this(date, g, f.getAndIncrement());
    }

    public ObjectId(Date date, int n2) {
        this(date, g, n2);
    }

    public ObjectId(Date date, int n2, int n3) {
        this.b = (int)(date.getTime() / 1000L);
        this.c = n2;
        this.d = n3;
        this.e = false;
    }

    public ObjectId(String string) {
        this(string, false);
    }

    public ObjectId(String string, boolean bl) {
        byte[] byArray;
        block7: {
            int n2 = Code.b;
            if (!ObjectId.isValid(string)) {
                throw new IllegalArgumentException("invalid ObjectId [" + string + "]");
            }
            if (bl) {
                string = ObjectId.babbleToMongod(string);
            }
            byte[] byArray2 = new byte[12];
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                byArray = byArray2;
                if (n2 != 0) break block7;
                byArray[i2] = (byte)Integer.parseInt(string.substring(i2 * 2, i2 * 2 + 2), 16);
                if (n2 == 0) continue;
                boolean bl2 = !IfxObject.g;
                IfxObject.g = bl2;
                break;
            }
            byArray = byArray2;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.b = byteBuffer.getInt();
        this.c = byteBuffer.getInt();
        this.d = byteBuffer.getInt();
        this.e = false;
    }

    public ObjectId(byte[] byArray) {
        if (byArray.length != 12) {
            throw new IllegalArgumentException("need 12 bytes");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.b = byteBuffer.getInt();
        this.c = byteBuffer.getInt();
        this.d = byteBuffer.getInt();
        this.e = false;
    }

    public ObjectId(int n2, int n3, int n4) {
        this.b = n2;
        this.c = n3;
        this.d = n4;
        this.e = false;
    }

    public ObjectId() {
        this.b = (int)(System.currentTimeMillis() / 1000L);
        this.c = g;
        this.d = f.getAndIncrement();
        this.e = true;
    }

    public int hashCode() {
        int n2 = this.b;
        n2 += this.c * 111;
        return n2 += this.d * 17;
    }

    public boolean equals(Object object) {
        boolean bl;
        block13: {
            block12: {
                if (this == object) {
                    return true;
                }
                ObjectId objectId = ObjectId.massageToObjectId(object);
                if (objectId == null) {
                    return false;
                }
                if (this.b != objectId.b || this.c != objectId.c) break block12;
                if (this.d != objectId.d) break block12;
                bl = true;
                break block13;
            }
            bl = false;
        }
        return bl;
    }

    public String toStringBabble() {
        return ObjectId.babbleToMongod(this.toStringMongod());
    }

    public String toStringMongod() {
        String string;
        block5: {
            int n2 = Code.b;
            byte[] byArray = this.toByteArray();
            StringBuilder stringBuilder = new StringBuilder(24);
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                String string2;
                block6: {
                    int n3 = byArray[i2] & 0xFF;
                    string2 = Integer.toHexString(n3);
                    string = string2;
                    if (n2 != 0) break block5;
                    if (string.length() != 1) break block6;
                    stringBuilder.append("0");
                }
                stringBuilder.append(string2);
                if (n2 == 0) continue;
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[12];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putInt(this.b);
        byteBuffer.putInt(this.c);
        byteBuffer.putInt(this.d);
        return byArray;
    }

    static String a(String string, int n2) {
        return string.substring(n2 * 2, n2 * 2 + 2);
    }

    public static String babbleToMongod(String string) {
        StringBuilder stringBuilder;
        block14: {
            int n2;
            StringBuilder stringBuilder2;
            int n3;
            block12: {
                n3 = Code.b;
                if (!ObjectId.isValid(string)) {
                    throw new IllegalArgumentException("invalid object id: " + string);
                }
                stringBuilder2 = new StringBuilder(24);
                for (n2 = 7; n2 >= 0; --n2) {
                    stringBuilder2.append(ObjectId.a(string, n2));
                    if (n3 == 0) {
                        if (n3 == 0) continue;
                        break;
                    }
                    break block12;
                }
                n2 = 11;
            }
            do {
                if (n2 < 8) break;
                stringBuilder = stringBuilder2.append(ObjectId.a(string, n2));
                if (n3 != 0) break block14;
                --n2;
            } while (n3 == 0);
            stringBuilder = stringBuilder2;
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toStringMongod();
    }

    int a(int n2, int n3) {
        long l2 = 0xFFFFFFFFL;
        l2 = (long)n2 & l2;
        long l3 = 0xFFFFFFFFL;
        l3 = (long)n3 & l3;
        long l4 = l2 - l3;
        if (l4 < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (l4 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l4;
    }

    @Override
    public int compareTo(ObjectId objectId) {
        if (objectId == null) {
            return -1;
        }
        int n2 = this.a(this.b, objectId.b);
        if (n2 != 0) {
            return n2;
        }
        n2 = this.a(this.c, objectId.c);
        if (n2 != 0) {
            return n2;
        }
        return this.a(this.d, objectId.d);
    }

    public int getMachine() {
        return this.c;
    }

    public long getTime() {
        return (long)this.b * 1000L;
    }

    public int getTimeSecond() {
        return this.b;
    }

    public int getInc() {
        return this.d;
    }

    public int _time() {
        return this.b;
    }

    public int _machine() {
        return this.c;
    }

    public int _inc() {
        return this.d;
    }

    public boolean isNew() {
        return this.e;
    }

    public void notNew() {
        this.e = false;
    }

    public static int getGenMachineId() {
        return g;
    }

    public static int getCurrentInc() {
        return f.get();
    }

    public static int _flip(int n2) {
        int n3 = Code.b;
        int n4 = 0;
        n4 |= n2 << 24 & 0xFF000000;
        n4 |= n2 << 8 & 0xFF0000;
        n4 |= n2 >> 8 & 0xFF00;
        n4 |= n2 >> 24 & 0xFF;
        int n5 = n4;
        if (IfxObject.g) {
            Code.b = ++n3;
        }
        return n5;
    }

    static {
        try {
            int n2;
            Object object;
            try {
                StringBuilder stringBuilder = new StringBuilder();
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    stringBuilder.append(((NetworkInterface)object).toString());
                }
                n2 = stringBuilder.toString().hashCode() << 16;
            }
            catch (Throwable throwable) {
                a.log(Level.WARNING, throwable.getMessage(), throwable);
                n2 = new Random().nextInt() << 16;
            }
            a.fine("machine piece post: " + Integer.toHexString(n2));
            int n3 = new Random().nextInt();
            try {
                n3 = ManagementFactory.getRuntimeMXBean().getName().hashCode();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            object = ObjectId.class.getClassLoader();
            int n4 = object != null ? System.identityHashCode(object) : 0;
            int n5 = n4;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Integer.toHexString(n3));
            stringBuilder.append(Integer.toHexString(n5));
            int n6 = stringBuilder.toString().hashCode() & 0xFFFF;
            a.fine("process piece: " + Integer.toHexString(n6));
            g = n2 | n6;
            a.fine("machine : " + Integer.toHexString(g));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

