/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.asf;

import com.gbasedbt.asf.HttpConnection;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLConnection;

public class HttpBufferedOutputStream
extends BufferedOutputStream {
    private HttpConnection http;
    private ByteArrayOutputStream os;
    private String session = null;

    public HttpBufferedOutputStream(ByteArrayOutputStream byteArrayOutputStream, HttpConnection httpConnection, String string) throws IOException {
        super(byteArrayOutputStream);
        this.os = byteArrayOutputStream;
        this.session = string;
        this.http = httpConnection;
    }

    @Override
    public final void write(int n) throws IOException {
        this.os.write(n);
    }

    @Override
    public final void write(byte[] byArray, int n, int n2) throws IOException {
        this.os.write(byArray, n, n2);
    }

    @Override
    public final void flush() throws IOException {
        int n = this.http.getProxyVersion();
        if (n < 210 && this.os.size() > 0 || n >= 210 && this.os.size() > 1000000) {
            URLConnection uRLConnection = this.http.openConnection(false, true, true);
            this.http.setRequestProperty("JDBC_SESSION", this.session);
            this.http.setRequestProperty("JDBC_REQUEST", "SEND");
            this.http.flush(uRLConnection);
            String string = this.http.getHeaderField("JDBC_REQUEST");
            String string2 = this.http.getHeaderField("JDBC_SESSION");
            if (string.equals("SEND_ERR")) {
                throw new IOException(string2);
            }
        }
        this.os = this.http.getOutputStream();
    }

    @Override
    public final void close() throws IOException {
        this.http.stopKeepAlive();
        URLConnection uRLConnection = this.http.openConnection(false, true, true);
        this.http.setRequestProperty("JDBC_SESSION", this.session);
        this.http.setRequestProperty("JDBC_REQUEST", "CLOSE");
        this.http.flush(uRLConnection);
    }

    public final void sendOOBData() throws IOException {
        URLConnection uRLConnection = this.http.openConnection(false, true, true);
        this.http.setRequestProperty("JDBC_SESSION", this.session);
        this.http.setRequestProperty("JDBC_REQUEST", "OOBDATA");
        this.http.flush(uRLConnection);
        this.session = this.http.getHeaderField("JDBC_SESSION");
    }
}

