/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.asf;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HttpConnection
extends Thread {
    public static final int optProxy = 210;
    private String proxy = null;
    private URL url = null;
    private ByteArrayOutputStream dataOs = null;
    private ByteArrayInputStream dataIs = null;
    private int proxyVer = 0;
    private String session = null;
    private Hashtable cookies = null;
    private StringBuffer reqProps = null;
    private Hashtable resHdrs = null;
    static int STREAM_BUF_SIZE = 4096;
    private long interval = 0L;
    private long lastflush = 0L;
    private boolean flushInProgress = true;
    private boolean sendKeepAlives = false;

    public HttpConnection(String string) throws IOException {
        this.proxy = string;
        try {
            this.url = new URL(string);
        }
        catch (IOException iOException) {
            throw new IOException();
        }
        this.reqProps = new StringBuffer();
        this.cookies = new Hashtable();
        this.resHdrs = new Hashtable();
        this.dataOs = new ByteArrayOutputStream(STREAM_BUF_SIZE);
        this.dataIs = new ByteArrayInputStream(new byte[0]);
        this.updateFlushTime();
    }

    public ByteArrayOutputStream getOutputStream() {
        return this.dataOs;
    }

    public ByteArrayInputStream getInputStream() {
        return this.dataIs;
    }

    public void flush(URLConnection uRLConnection) throws IOException {
        this.flushInProgress = true;
        this.sendRequest(uRLConnection);
        this.getResponse(uRLConnection);
        this.updateFlushTime();
        this.flushInProgress = false;
    }

    private void sendRequest(URLConnection uRLConnection) throws IOException {
        this.setCookies(uRLConnection);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(uRLConnection.getOutputStream()));
            dataOutputStream.writeShort(this.reqProps.toString().length());
            dataOutputStream.writeBytes(this.reqProps.toString());
            this.reqProps = new StringBuffer();
            this.dataOs.writeTo(dataOutputStream);
            this.dataOs.reset();
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            throw new IOException();
        }
    }

    private void getResponse(URLConnection uRLConnection) throws IOException {
        short s = 0;
        short s2 = 0;
        byte[] byArray = null;
        this.dataIs = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
            s = dataInputStream.readShort();
            if (s == -1) {
                throw new IOException();
            }
            byte[] byArray2 = new byte[s];
            dataInputStream.readFully(byArray2, 0, s);
            String string = new String(byArray2, 0, (int)s);
            try {
                this.parseResponse(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dataInputStream.available() > 0) {
                s2 = dataInputStream.readShort();
                if (s2 != -1) {
                    byArray = new byte[s2];
                    dataInputStream.readFully(byArray);
                    this.dataIs = new ByteArrayInputStream(byArray);
                }
            } else {
                this.dataIs = new ByteArrayInputStream(new byte[0]);
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            throw new IOException();
        }
    }

    public synchronized URLConnection openConnection(boolean bl, boolean bl2, boolean bl3) throws IOException {
        URLConnection uRLConnection = null;
        try {
            uRLConnection = this.url.openConnection();
            uRLConnection.setUseCaches(bl);
            uRLConnection.setRequestProperty("Content-Type", "application/binary");
            uRLConnection.setDoOutput(bl2);
            uRLConnection.setDoInput(bl3);
        }
        catch (IOException iOException) {
            throw new IOException();
        }
        return uRLConnection;
    }

    public String getHeaderField(String string) {
        String string2 = null;
        string2 = (String)this.resHdrs.get(string);
        return string2;
    }

    public void setRequestProperty(String string, String string2) {
        this.reqProps.append(string + "=" + string2 + "&");
    }

    public void saveCookie(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = null;
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, ";");
            while (stringTokenizer2.hasMoreTokens()) {
                String string2 = stringTokenizer2.nextToken().trim();
                stringTokenizer = new StringTokenizer(string2, "=");
                String string3 = stringTokenizer.nextToken().trim();
                if (string3.equalsIgnoreCase("Comment") || string3.equalsIgnoreCase("Discard") || string3.equalsIgnoreCase("Domain") || string3.equalsIgnoreCase("Expires") || string3.equalsIgnoreCase("Max-Age") || string3.equalsIgnoreCase("Path") || string3.equalsIgnoreCase("Secure") || string3.equalsIgnoreCase("Version")) continue;
                stringBuffer.append(string2 + ";");
            }
            if (stringBuffer.length() > 0) {
                this.cookies.put(this.cookies.size(), stringBuffer);
            }
        }
    }

    public void setCookies(URLConnection uRLConnection) {
        if (this.cookies.size() > 0) {
            Enumeration enumeration = this.cookies.elements();
            while (enumeration.hasMoreElements()) {
                uRLConnection.setRequestProperty("Cookie", enumeration.nextElement().toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseResponse(String string) throws Exception {
        this.resHdrs = new Hashtable();
        StringTokenizer stringTokenizer = null;
        TokenPhase tokenPhase = TokenPhase.NEW;
        boolean bl = false;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null) {
            return;
        }
        stringTokenizer = new StringTokenizer(string, ";=\"", true);
        while (stringTokenizer.hasMoreTokens()) {
            block32: {
                String string3;
                block31: {
                    string3 = stringTokenizer.nextToken();
                    if (string3.length() != 1) break block31;
                    switch (string3.charAt(0)) {
                        case '\"': {
                            switch (tokenPhase) {
                                case EQUAL: {
                                    tokenPhase = TokenPhase.VALUE;
                                    bl = true;
                                    break block32;
                                }
                                case VALUE: {
                                    if (!bl) throw new Exception();
                                    bl = false;
                                    break block32;
                                }
                                default: {
                                    throw new Exception();
                                }
                            }
                        }
                        case ';': {
                            if (tokenPhase == TokenPhase.VALUE) {
                                if (bl) {
                                    stringBuffer.append(string3);
                                } else {
                                    tokenPhase = TokenPhase.SEMICOLON;
                                }
                            } else {
                                if (tokenPhase != TokenPhase.EQUAL) throw new Exception();
                                tokenPhase = TokenPhase.SEMICOLON;
                            }
                            break block32;
                        }
                        case '=': {
                            switch (tokenPhase) {
                                case KEY: {
                                    tokenPhase = TokenPhase.EQUAL;
                                    break block32;
                                }
                                case VALUE: {
                                    if (!bl) throw new Exception();
                                    stringBuffer.append(string3);
                                    break block32;
                                }
                                default: {
                                    throw new Exception();
                                }
                            }
                        }
                        case ' ': {
                            if (tokenPhase == TokenPhase.VALUE && bl) {
                                stringBuffer.append(string3);
                            }
                            break block32;
                        }
                        default: {
                            if (tokenPhase != TokenPhase.VALUE || !bl) throw new Exception();
                            stringBuffer.append(string3);
                            break block32;
                        }
                    }
                }
                switch (tokenPhase) {
                    case NEW: {
                        string2 = string3;
                        tokenPhase = TokenPhase.KEY;
                        break;
                    }
                    case EQUAL: {
                        stringBuffer.append(string3);
                        tokenPhase = TokenPhase.VALUE;
                        break;
                    }
                    case VALUE: {
                        if (!bl) throw new Exception();
                        stringBuffer.append(string3);
                        break;
                    }
                    default: {
                        throw new Exception();
                    }
                }
            }
            if (tokenPhase != TokenPhase.SEMICOLON) continue;
            this.resHdrs.put(string2, stringBuffer.toString());
            tokenPhase = TokenPhase.NEW;
            bl = false;
            string2 = null;
            stringBuffer.delete(0, stringBuffer.length());
        }
        switch (tokenPhase) {
            case EQUAL: 
            case KEY: {
                this.resHdrs.put(string2, "");
                return;
            }
            case VALUE: 
            case SEMICOLON: {
                if (bl) {
                    throw new Exception();
                }
                this.resHdrs.put(string2, stringBuffer.toString());
            }
        }
    }

    public void updateURL(String string) throws IOException {
        try {
            this.url = new URL(string);
        }
        catch (IOException iOException) {
            throw new IOException();
        }
    }

    public void setProxyVersion(int n) {
        this.proxyVer = n;
    }

    public int getProxyVersion() {
        return this.proxyVer;
    }

    private synchronized void updateFlushTime() {
        this.lastflush = System.currentTimeMillis();
    }

    public void startKeepAlive(String string, long l) throws IOException {
        this.interval = l * 1000L;
        this.session = string;
        if (this.proxyVer >= 210) {
            this.sendKeepAlives = true;
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.setPriority(5);
            thread.start();
        }
    }

    @Override
    public void run() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JDBC_SESSION=" + this.session + "&" + "JDBC_REQUEST" + "=KEEPALIVE&");
        long l = 0L;
        long l2 = 0L;
        long l3 = this.interval;
        while (this.sendKeepAlives) {
            try {
                Thread.sleep(l3);
                l2 = System.currentTimeMillis();
                l = l2 - this.lastflush;
                if (l >= this.interval) {
                    if (!this.flushInProgress && this.sendKeepAlives) {
                        try {
                            URLConnection uRLConnection = this.openConnection(false, true, true);
                            this.setCookies(uRLConnection);
                            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(uRLConnection.getOutputStream()));
                            dataOutputStream.writeShort(stringBuffer.toString().length());
                            dataOutputStream.writeBytes(stringBuffer.toString());
                            dataOutputStream.close();
                            InputStream inputStream = uRLConnection.getInputStream();
                            inputStream.close();
                            this.updateFlushTime();
                            l3 = this.interval;
                        }
                        catch (IOException iOException) {
                            this.sendKeepAlives = false;
                        }
                        continue;
                    }
                    l3 = this.interval;
                    continue;
                }
                l3 = this.interval - l;
            }
            catch (InterruptedException interruptedException) {
                this.sendKeepAlives = false;
            }
        }
    }

    public void stopKeepAlive() throws IOException {
        this.sendKeepAlives = false;
    }

    private static enum TokenPhase {
        NEW,
        KEY,
        EQUAL,
        VALUE,
        SEMICOLON;

    }
}

