/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.asf;

import com.gbasedbt.asf.IfxDataOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class IfxDebugDataOutputStream
extends IfxDataOutputStream {
    private ByteArrayOutputStream trace = new ByteArrayOutputStream();

    public IfxDebugDataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public IfxDebugDataOutputStream(OutputStream outputStream, boolean bl) {
        super(outputStream, bl);
    }

    @Override
    public void writePadded(byte[] byArray, int n, int n2) throws IOException {
        super.writePadded(byArray, n, n2);
        this.trace.write(byArray, n, n2);
        this.checkPadding();
        if ((n2 & 1) >= 1) {
            this.trace.write(0);
        }
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
        this.trace.write((byte)n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.trace.write(byArray, n, n2);
        this.trace.flush();
        this.checkPadding();
    }

    @Override
    public void writeWithMangledTrace(byte[] byArray) throws IOException {
        super.write(byArray, 0, byArray.length);
    }

    public void writeWithMangledTrace(byte[] byArray, int n, int n2) throws IOException {
        this.write(byArray, n, n2);
        byte[] byArray2 = new byte[n2];
        Arrays.fill(byArray2, (byte)42);
        this.trace.write(byArray2);
        this.checkPadding();
        this.written += n2;
    }

    protected void checkPadding() {
    }

    @Override
    protected void clearTrace() {
        try {
            this.trace.flush();
            this.trace.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void dumpTrace(OutputStream outputStream) {
        try {
            this.trace.writeTo(outputStream);
            this.trace.flush();
            this.trace.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int getTraceLength() {
        return this.trace.size();
    }

    protected void resetTrace() {
        try {
            this.trace.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

