/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.crypto.provider;

import com.gbasedbt.crypto.provider.AESConstants;
import com.gbasedbt.crypto.provider.SymmetricCipher;
import java.security.InvalidKeyException;

final class AESCrypt
extends SymmetricCipher
implements AESConstants {
    private boolean ROUNDS_12 = false;
    private boolean ROUNDS_14 = false;
    private Object[] sessionK = null;
    private int[] K = null;
    private int limit = 0;
    private static int[] alog;
    private static int[] log;
    private static final byte[] S;
    private static final byte[] Si;
    private static final int[] T1;
    private static final int[] T2;
    private static final int[] T3;
    private static final int[] T4;
    private static final int[] T5;
    private static final int[] T6;
    private static final int[] T7;
    private static final int[] T8;
    private static final int[] U1;
    private static final int[] U2;
    private static final int[] U3;
    private static final int[] U4;
    private static final byte[] rcon;

    AESCrypt() {
    }

    @Override
    int getBlockSize() {
        return 16;
    }

    @Override
    void init(boolean bl, String string, byte[] byArray) throws InvalidKeyException {
        if (!string.equalsIgnoreCase("AES") && !string.equalsIgnoreCase("Rijndael")) {
            throw new InvalidKeyException("Wrong algorithm: AES or Rijndael required");
        }
        if (!AESCrypt.isKeySizeValid(byArray.length)) {
            throw new InvalidKeyException("Invalid AES key length: " + byArray.length + " bytes");
        }
        this.sessionK = AESCrypt.makeKey(byArray);
        this.setSubKey(bl);
    }

    private void setSubKey(boolean bl) {
        int n;
        int n2;
        int[][] nArray = (int[][])this.sessionK[bl ? 1 : 0];
        int n3 = nArray.length;
        this.K = new int[n3 * 4];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < 4; ++n) {
                this.K[n2 * 4 + n] = nArray[n2][n];
            }
        }
        if (bl) {
            n2 = this.K[this.K.length - 4];
            n = this.K[this.K.length - 3];
            int n4 = this.K[this.K.length - 2];
            int n5 = this.K[this.K.length - 1];
            for (int i = this.K.length - 1; i > 3; --i) {
                this.K[i] = this.K[i - 4];
            }
            this.K[0] = n2;
            this.K[1] = n;
            this.K[2] = n4;
            this.K[3] = n5;
        }
        this.ROUNDS_12 = n3 >= 13;
        this.ROUNDS_14 = n3 == 15;
        this.limit = --n3 * 4;
    }

    private static final int mul(int n, int n2) {
        return n != 0 && n2 != 0 ? alog[(log[n & 0xFF] + log[n2 & 0xFF]) % 255] : 0;
    }

    private static final int mul4(int n, byte[] byArray) {
        if (n == 0) {
            return 0;
        }
        n = log[n & 0xFF];
        int n2 = byArray[0] != 0 ? alog[(n + log[byArray[0] & 0xFF]) % 255] & 0xFF : 0;
        int n3 = byArray[1] != 0 ? alog[(n + log[byArray[1] & 0xFF]) % 255] & 0xFF : 0;
        int n4 = byArray[2] != 0 ? alog[(n + log[byArray[2] & 0xFF]) % 255] & 0xFF : 0;
        int n5 = byArray[3] != 0 ? alog[(n + log[byArray[3] & 0xFF]) % 255] & 0xFF : 0;
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    static final boolean isKeySizeValid(int n) {
        for (int i = 0; i < AES_KEYSIZES.length; ++i) {
            if (n != AES_KEYSIZES[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3;
        int n4 = 0;
        int n5 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ this.K[n4++];
        int n6 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ this.K[n4++];
        int n7 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ this.K[n4++];
        int n8 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ this.K[n4++];
        while (n4 < this.limit) {
            n3 = T1[n5 >>> 24] ^ T2[n6 >>> 16 & 0xFF] ^ T3[n7 >>> 8 & 0xFF] ^ T4[n8 & 0xFF] ^ this.K[n4++];
            int n9 = T1[n6 >>> 24] ^ T2[n7 >>> 16 & 0xFF] ^ T3[n8 >>> 8 & 0xFF] ^ T4[n5 & 0xFF] ^ this.K[n4++];
            int n10 = T1[n7 >>> 24] ^ T2[n8 >>> 16 & 0xFF] ^ T3[n5 >>> 8 & 0xFF] ^ T4[n6 & 0xFF] ^ this.K[n4++];
            n8 = T1[n8 >>> 24] ^ T2[n5 >>> 16 & 0xFF] ^ T3[n6 >>> 8 & 0xFF] ^ T4[n7 & 0xFF] ^ this.K[n4++];
            n5 = n3;
            n6 = n9;
            n7 = n10;
        }
        n3 = this.K[n4++];
        byArray2[n2++] = (byte)(S[n5 >>> 24] ^ n3 >>> 24);
        byArray2[n2++] = (byte)(S[n6 >>> 16 & 0xFF] ^ n3 >>> 16);
        byArray2[n2++] = (byte)(S[n7 >>> 8 & 0xFF] ^ n3 >>> 8);
        byArray2[n2++] = (byte)(S[n8 & 0xFF] ^ n3);
        n3 = this.K[n4++];
        byArray2[n2++] = (byte)(S[n6 >>> 24] ^ n3 >>> 24);
        byArray2[n2++] = (byte)(S[n7 >>> 16 & 0xFF] ^ n3 >>> 16);
        byArray2[n2++] = (byte)(S[n8 >>> 8 & 0xFF] ^ n3 >>> 8);
        byArray2[n2++] = (byte)(S[n5 & 0xFF] ^ n3);
        n3 = this.K[n4++];
        byArray2[n2++] = (byte)(S[n7 >>> 24] ^ n3 >>> 24);
        byArray2[n2++] = (byte)(S[n8 >>> 16 & 0xFF] ^ n3 >>> 16);
        byArray2[n2++] = (byte)(S[n5 >>> 8 & 0xFF] ^ n3 >>> 8);
        byArray2[n2++] = (byte)(S[n6 & 0xFF] ^ n3);
        n3 = this.K[n4++];
        byArray2[n2++] = (byte)(S[n8 >>> 24] ^ n3 >>> 24);
        byArray2[n2++] = (byte)(S[n5 >>> 16 & 0xFF] ^ n3 >>> 16);
        byArray2[n2++] = (byte)(S[n6 >>> 8 & 0xFF] ^ n3 >>> 8);
        byArray2[n2] = (byte)(S[n7 & 0xFF] ^ n3);
    }

    @Override
    void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 4;
        int n7 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ this.K[n6++];
        int n8 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ this.K[n6++];
        int n9 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ this.K[n6++];
        int n10 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF) ^ this.K[n6++];
        if (this.ROUNDS_12) {
            n5 = T5[n7 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n9 >>> 8 & 0xFF] ^ T8[n8 & 0xFF] ^ this.K[n6++];
            n4 = T5[n8 >>> 24] ^ T6[n7 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n9 & 0xFF] ^ this.K[n6++];
            n3 = T5[n9 >>> 24] ^ T6[n8 >>> 16 & 0xFF] ^ T7[n7 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n6++];
            n10 = T5[n10 >>> 24] ^ T6[n9 >>> 16 & 0xFF] ^ T7[n8 >>> 8 & 0xFF] ^ T8[n7 & 0xFF] ^ this.K[n6++];
            n7 = T5[n5 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n3 >>> 8 & 0xFF] ^ T8[n4 & 0xFF] ^ this.K[n6++];
            n8 = T5[n4 >>> 24] ^ T6[n5 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n3 & 0xFF] ^ this.K[n6++];
            n9 = T5[n3 >>> 24] ^ T6[n4 >>> 16 & 0xFF] ^ T7[n5 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n6++];
            n10 = T5[n10 >>> 24] ^ T6[n3 >>> 16 & 0xFF] ^ T7[n4 >>> 8 & 0xFF] ^ T8[n5 & 0xFF] ^ this.K[n6++];
            if (this.ROUNDS_14) {
                n5 = T5[n7 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n9 >>> 8 & 0xFF] ^ T8[n8 & 0xFF] ^ this.K[n6++];
                n4 = T5[n8 >>> 24] ^ T6[n7 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n9 & 0xFF] ^ this.K[n6++];
                n3 = T5[n9 >>> 24] ^ T6[n8 >>> 16 & 0xFF] ^ T7[n7 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n6++];
                n10 = T5[n10 >>> 24] ^ T6[n9 >>> 16 & 0xFF] ^ T7[n8 >>> 8 & 0xFF] ^ T8[n7 & 0xFF] ^ this.K[n6++];
                n7 = T5[n5 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n3 >>> 8 & 0xFF] ^ T8[n4 & 0xFF] ^ this.K[n6++];
                n8 = T5[n4 >>> 24] ^ T6[n5 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n3 & 0xFF] ^ this.K[n6++];
                n9 = T5[n3 >>> 24] ^ T6[n4 >>> 16 & 0xFF] ^ T7[n5 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n6++];
                n10 = T5[n10 >>> 24] ^ T6[n3 >>> 16 & 0xFF] ^ T7[n4 >>> 8 & 0xFF] ^ T8[n5 & 0xFF] ^ this.K[n6++];
            }
        }
        n5 = T5[n7 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n9 >>> 8 & 0xFF] ^ T8[n8 & 0xFF] ^ this.K[n6++];
        n4 = T5[n8 >>> 24] ^ T6[n7 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n9 & 0xFF] ^ this.K[n6++];
        n3 = T5[n9 >>> 24] ^ T6[n8 >>> 16 & 0xFF] ^ T7[n7 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n6++];
        n10 = T5[n10 >>> 24] ^ T6[n9 >>> 16 & 0xFF] ^ T7[n8 >>> 8 & 0xFF] ^ T8[n7 & 0xFF] ^ this.K[n6++];
        n7 = T5[n5 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n3 >>> 8 & 0xFF] ^ T8[n4 & 0xFF] ^ this.K[n6++];
        n8 = T5[n4 >>> 24] ^ T6[n5 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n3 & 0xFF] ^ this.K[n6++];
        n9 = T5[n3 >>> 24] ^ T6[n4 >>> 16 & 0xFF] ^ T7[n5 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n6++];
        n10 = T5[n10 >>> 24] ^ T6[n3 >>> 16 & 0xFF] ^ T7[n4 >>> 8 & 0xFF] ^ T8[n5 & 0xFF] ^ this.K[n6++];
        n5 = T5[n7 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n9 >>> 8 & 0xFF] ^ T8[n8 & 0xFF] ^ this.K[n6++];
        n4 = T5[n8 >>> 24] ^ T6[n7 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n9 & 0xFF] ^ this.K[n6++];
        n3 = T5[n9 >>> 24] ^ T6[n8 >>> 16 & 0xFF] ^ T7[n7 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n6++];
        n10 = T5[n10 >>> 24] ^ T6[n9 >>> 16 & 0xFF] ^ T7[n8 >>> 8 & 0xFF] ^ T8[n7 & 0xFF] ^ this.K[n6++];
        n7 = T5[n5 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n3 >>> 8 & 0xFF] ^ T8[n4 & 0xFF] ^ this.K[n6++];
        n8 = T5[n4 >>> 24] ^ T6[n5 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n3 & 0xFF] ^ this.K[n6++];
        n9 = T5[n3 >>> 24] ^ T6[n4 >>> 16 & 0xFF] ^ T7[n5 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n6++];
        n10 = T5[n10 >>> 24] ^ T6[n3 >>> 16 & 0xFF] ^ T7[n4 >>> 8 & 0xFF] ^ T8[n5 & 0xFF] ^ this.K[n6++];
        n5 = T5[n7 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n9 >>> 8 & 0xFF] ^ T8[n8 & 0xFF] ^ this.K[n6++];
        n4 = T5[n8 >>> 24] ^ T6[n7 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n9 & 0xFF] ^ this.K[n6++];
        n3 = T5[n9 >>> 24] ^ T6[n8 >>> 16 & 0xFF] ^ T7[n7 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n6++];
        n10 = T5[n10 >>> 24] ^ T6[n9 >>> 16 & 0xFF] ^ T7[n8 >>> 8 & 0xFF] ^ T8[n7 & 0xFF] ^ this.K[n6++];
        n7 = T5[n5 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n3 >>> 8 & 0xFF] ^ T8[n4 & 0xFF] ^ this.K[n6++];
        n8 = T5[n4 >>> 24] ^ T6[n5 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n3 & 0xFF] ^ this.K[n6++];
        n9 = T5[n3 >>> 24] ^ T6[n4 >>> 16 & 0xFF] ^ T7[n5 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n6++];
        n10 = T5[n10 >>> 24] ^ T6[n3 >>> 16 & 0xFF] ^ T7[n4 >>> 8 & 0xFF] ^ T8[n5 & 0xFF] ^ this.K[n6++];
        n5 = T5[n7 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n9 >>> 8 & 0xFF] ^ T8[n8 & 0xFF] ^ this.K[n6++];
        n4 = T5[n8 >>> 24] ^ T6[n7 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n9 & 0xFF] ^ this.K[n6++];
        n3 = T5[n9 >>> 24] ^ T6[n8 >>> 16 & 0xFF] ^ T7[n7 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n6++];
        n10 = T5[n10 >>> 24] ^ T6[n9 >>> 16 & 0xFF] ^ T7[n8 >>> 8 & 0xFF] ^ T8[n7 & 0xFF] ^ this.K[n6++];
        n7 = T5[n5 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n3 >>> 8 & 0xFF] ^ T8[n4 & 0xFF] ^ this.K[n6++];
        n8 = T5[n4 >>> 24] ^ T6[n5 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n3 & 0xFF] ^ this.K[n6++];
        n9 = T5[n3 >>> 24] ^ T6[n4 >>> 16 & 0xFF] ^ T7[n5 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n6++];
        n10 = T5[n10 >>> 24] ^ T6[n3 >>> 16 & 0xFF] ^ T7[n4 >>> 8 & 0xFF] ^ T8[n5 & 0xFF] ^ this.K[n6++];
        n5 = T5[n7 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n9 >>> 8 & 0xFF] ^ T8[n8 & 0xFF] ^ this.K[n6++];
        n4 = T5[n8 >>> 24] ^ T6[n7 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n9 & 0xFF] ^ this.K[n6++];
        n3 = T5[n9 >>> 24] ^ T6[n8 >>> 16 & 0xFF] ^ T7[n7 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n6++];
        n10 = T5[n10 >>> 24] ^ T6[n9 >>> 16 & 0xFF] ^ T7[n8 >>> 8 & 0xFF] ^ T8[n7 & 0xFF] ^ this.K[n6++];
        n8 = this.K[0];
        byArray2[n2++] = (byte)(Si[n5 >>> 24] ^ n8 >>> 24);
        byArray2[n2++] = (byte)(Si[n10 >>> 16 & 0xFF] ^ n8 >>> 16);
        byArray2[n2++] = (byte)(Si[n3 >>> 8 & 0xFF] ^ n8 >>> 8);
        byArray2[n2++] = (byte)(Si[n4 & 0xFF] ^ n8);
        n8 = this.K[1];
        byArray2[n2++] = (byte)(Si[n4 >>> 24] ^ n8 >>> 24);
        byArray2[n2++] = (byte)(Si[n5 >>> 16 & 0xFF] ^ n8 >>> 16);
        byArray2[n2++] = (byte)(Si[n10 >>> 8 & 0xFF] ^ n8 >>> 8);
        byArray2[n2++] = (byte)(Si[n3 & 0xFF] ^ n8);
        n8 = this.K[2];
        byArray2[n2++] = (byte)(Si[n3 >>> 24] ^ n8 >>> 24);
        byArray2[n2++] = (byte)(Si[n4 >>> 16 & 0xFF] ^ n8 >>> 16);
        byArray2[n2++] = (byte)(Si[n5 >>> 8 & 0xFF] ^ n8 >>> 8);
        byArray2[n2++] = (byte)(Si[n10 & 0xFF] ^ n8);
        n8 = this.K[3];
        byArray2[n2++] = (byte)(Si[n10 >>> 24] ^ n8 >>> 24);
        byArray2[n2++] = (byte)(Si[n3 >>> 16 & 0xFF] ^ n8 >>> 16);
        byArray2[n2++] = (byte)(Si[n4 >>> 8 & 0xFF] ^ n8 >>> 8);
        byArray2[n2] = (byte)(Si[n5 & 0xFF] ^ n8);
    }

    private static Object[] makeKey(byte[] byArray) throws InvalidKeyException {
        int n;
        if (byArray == null) {
            throw new InvalidKeyException("Empty key");
        }
        if (!AESCrypt.isKeySizeValid(byArray.length)) {
            throw new InvalidKeyException("Invalid AES key length: " + byArray.length + " bytes");
        }
        int n2 = AESCrypt.getRounds(byArray.length);
        int n3 = (n2 + 1) * 4;
        int n4 = 4;
        int[][] nArray = new int[n2 + 1][4];
        int[][] nArray2 = new int[n2 + 1][4];
        int n5 = byArray.length / 4;
        int[] nArray3 = new int[n5];
        int n6 = 0;
        int n7 = 0;
        while (n6 < n5) {
            nArray3[n6] = byArray[n7] << 24 | (byArray[n7 + 1] & 0xFF) << 16 | (byArray[n7 + 2] & 0xFF) << 8 | byArray[n7 + 3] & 0xFF;
            ++n6;
            n7 += 4;
        }
        int n8 = 0;
        for (n7 = 0; n7 < n5 && n8 < n3; ++n7, ++n8) {
            nArray[n8 / 4][n8 % 4] = nArray3[n7];
            nArray2[n2 - n8 / 4][n8 % 4] = nArray3[n7];
        }
        int n9 = 0;
        while (n8 < n3) {
            n = nArray3[n5 - 1];
            nArray3[0] = nArray3[0] ^ (S[n >>> 16 & 0xFF] << 24 ^ (S[n >>> 8 & 0xFF] & 0xFF) << 16 ^ (S[n & 0xFF] & 0xFF) << 8 ^ S[n >>> 24] & 0xFF ^ rcon[n9++] << 24);
            if (n5 != 8) {
                n6 = 1;
                n7 = 0;
                while (n6 < n5) {
                    int n10 = n6++;
                    nArray3[n10] = nArray3[n10] ^ nArray3[n7];
                    ++n7;
                }
            } else {
                n6 = 1;
                n7 = 0;
                while (n6 < n5 / 2) {
                    int n11 = n6++;
                    nArray3[n11] = nArray3[n11] ^ nArray3[n7];
                    ++n7;
                }
                n = nArray3[n5 / 2 - 1];
                int n12 = n5 / 2;
                nArray3[n12] = nArray3[n12] ^ (S[n & 0xFF] & 0xFF ^ (S[n >>> 8 & 0xFF] & 0xFF) << 8 ^ (S[n >>> 16 & 0xFF] & 0xFF) << 16 ^ S[n >>> 24] << 24);
                n7 = n5 / 2;
                n6 = n7 + 1;
                while (n6 < n5) {
                    int n13 = n6++;
                    nArray3[n13] = nArray3[n13] ^ nArray3[n7];
                    ++n7;
                }
            }
            for (n7 = 0; n7 < n5 && n8 < n3; ++n7, ++n8) {
                nArray[n8 / 4][n8 % 4] = nArray3[n7];
                nArray2[n2 - n8 / 4][n8 % 4] = nArray3[n7];
            }
        }
        for (int i = 1; i < n2; ++i) {
            for (n7 = 0; n7 < n4; ++n7) {
                n = nArray2[i][n7];
                nArray2[i][n7] = U1[n >>> 24 & 0xFF] ^ U2[n >>> 16 & 0xFF] ^ U3[n >>> 8 & 0xFF] ^ U4[n & 0xFF];
            }
        }
        Object[] objectArray = new Object[]{nArray, nArray2};
        return objectArray;
    }

    private static int getRounds(int n) {
        return (n >> 2) + 6;
    }

    static {
        int n;
        int n2;
        alog = new int[256];
        log = new int[256];
        S = new byte[256];
        Si = new byte[256];
        T1 = new int[256];
        T2 = new int[256];
        T3 = new int[256];
        T4 = new int[256];
        T5 = new int[256];
        T6 = new int[256];
        T7 = new int[256];
        T8 = new int[256];
        U1 = new int[256];
        U2 = new int[256];
        U3 = new int[256];
        U4 = new int[256];
        rcon = new byte[30];
        int n3 = 283;
        int n4 = 0;
        AESCrypt.alog[0] = 1;
        for (n2 = 1; n2 < 256; ++n2) {
            n4 = alog[n2 - 1] << 1 ^ alog[n2 - 1];
            if ((n4 & 0x100) != 0) {
                n4 ^= n3;
            }
            AESCrypt.alog[n2] = n4;
        }
        for (n2 = 1; n2 < 255; ++n2) {
            AESCrypt.log[AESCrypt.alog[n2]] = n2;
        }
        byte[][] byArrayArray = new byte[][]{{1, 1, 1, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 1, 1, 1, 1}, {1, 1, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 0, 0, 0, 1, 1}, {1, 1, 1, 1, 0, 0, 0, 1}};
        byte[] byArray = new byte[]{0, 1, 1, 0, 0, 0, 1, 1};
        byte[][] byArray2 = new byte[256][8];
        byArray2[1][7] = 1;
        for (n2 = 2; n2 < 256; ++n2) {
            n4 = alog[255 - log[n2]];
            for (n = 0; n < 8; ++n) {
                byArray2[n2][n] = (byte)(n4 >>> 7 - n & 1);
            }
        }
        byte[][] byArray3 = new byte[256][8];
        for (n2 = 0; n2 < 256; ++n2) {
            for (n = 0; n < 8; ++n) {
                byArray3[n2][n] = byArray[n];
                for (n4 = 0; n4 < 8; ++n4) {
                    byte[] byArray4 = byArray3[n2];
                    int n5 = n;
                    byArray4[n5] = (byte)(byArray4[n5] ^ byArrayArray[n][n4] * byArray2[n2][n4]);
                }
            }
        }
        for (n2 = 0; n2 < 256; ++n2) {
            AESCrypt.S[n2] = (byte)(byArray3[n2][0] << 7);
            for (n = 1; n < 8; ++n) {
                int n6 = n2;
                S[n6] = (byte)(S[n6] ^ byArray3[n2][n] << 7 - n);
            }
            AESCrypt.Si[AESCrypt.S[n2] & 0xFF] = (byte)n2;
        }
        byte[][] byArrayArray2 = new byte[][]{{2, 1, 1, 3}, {3, 2, 1, 1}, {1, 3, 2, 1}, {1, 1, 3, 2}};
        byte[][] byArray5 = new byte[4][8];
        for (n2 = 0; n2 < 4; ++n2) {
            for (n4 = 0; n4 < 4; ++n4) {
                byArray5[n2][n4] = byArrayArray2[n2][n4];
            }
            byArray5[n2][n2 + 4] = 1;
        }
        byte[][] byArray6 = new byte[4][4];
        for (n2 = 0; n2 < 4; ++n2) {
            byte by = byArray5[n2][n2];
            if (by == 0) {
                for (n = n2 + 1; byArray5[n][n2] == 0 && n < 4; ++n) {
                }
                if (n == 4) {
                    throw new RuntimeException("G matrix is not invertible");
                }
                for (n4 = 0; n4 < 8; ++n4) {
                    byte by2 = byArray5[n2][n4];
                    byArray5[n2][n4] = byArray5[n][n4];
                    byArray5[n][n4] = by2;
                }
                by = byArray5[n2][n2];
            }
            for (n4 = 0; n4 < 8; ++n4) {
                if (byArray5[n2][n4] == 0) continue;
                byArray5[n2][n4] = (byte)alog[(255 + log[byArray5[n2][n4] & 0xFF] - log[by & 0xFF]) % 255];
            }
            for (n = 0; n < 4; ++n) {
                if (n2 == n) continue;
                for (n4 = n2 + 1; n4 < 8; ++n4) {
                    byte[] byArray7 = byArray5[n];
                    int n7 = n4;
                    byArray7[n7] = (byte)(byArray7[n7] ^ AESCrypt.mul(byArray5[n2][n4], byArray5[n][n2]));
                }
                byArray5[n][n2] = 0;
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            for (n4 = 0; n4 < 4; ++n4) {
                byArray6[n2][n4] = byArray5[n2][n4 + 4];
            }
        }
        for (n = 0; n < 256; ++n) {
            byte by = S[n];
            AESCrypt.T1[n] = AESCrypt.mul4(by, byArrayArray2[0]);
            AESCrypt.T2[n] = AESCrypt.mul4(by, byArrayArray2[1]);
            AESCrypt.T3[n] = AESCrypt.mul4(by, byArrayArray2[2]);
            AESCrypt.T4[n] = AESCrypt.mul4(by, byArrayArray2[3]);
            by = Si[n];
            AESCrypt.T5[n] = AESCrypt.mul4(by, byArray6[0]);
            AESCrypt.T6[n] = AESCrypt.mul4(by, byArray6[1]);
            AESCrypt.T7[n] = AESCrypt.mul4(by, byArray6[2]);
            AESCrypt.T8[n] = AESCrypt.mul4(by, byArray6[3]);
            AESCrypt.U1[n] = AESCrypt.mul4(n, byArray6[0]);
            AESCrypt.U2[n] = AESCrypt.mul4(n, byArray6[1]);
            AESCrypt.U3[n] = AESCrypt.mul4(n, byArray6[2]);
            AESCrypt.U4[n] = AESCrypt.mul4(n, byArray6[3]);
        }
        AESCrypt.rcon[0] = 1;
        int n8 = 1;
        for (n = 1; n < 30; ++n) {
            n8 = AESCrypt.mul(2, n8);
            AESCrypt.rcon[n] = (byte)n8;
        }
        log = null;
        alog = null;
    }
}

