/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.crypto.provider;

import com.gbasedbt.crypto.provider.DESKey;
import com.gbasedbt.crypto.provider.SunJCE;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.DESKeySpec;

public final class DESKeyGenerator
extends KeyGeneratorSpi {
    private SecureRandom random = null;

    public DESKeyGenerator() {
        if (!SunJCE.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The SunJCE provider may have been tampered.");
        }
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("DES key generation does not take any parameters");
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        if (n != 56) {
            throw new InvalidParameterException("Wrong keysize: must be equal to 56");
        }
        this.engineInit(secureRandom);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        DESKey dESKey = null;
        if (this.random == null) {
            this.random = SunJCE.RANDOM;
        }
        try {
            byte[] byArray = new byte[8];
            do {
                this.random.nextBytes(byArray);
                DESKeyGenerator.setParityBit(byArray, 0);
            } while (DESKeySpec.isWeak(byArray, 0));
            dESKey = new DESKey(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return dESKey;
    }

    static void setParityBit(byte[] byArray, int n) {
        if (byArray == null) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            int n2 = byArray[n] & 0xFE;
            n2 |= Integer.bitCount(n2) & 1 ^ 1;
            byArray[n++] = (byte)n2;
        }
    }
}

