/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.crypto.provider;

import com.gbasedbt.base64.BASE64Decoder;
import com.gbasedbt.base64.BASE64Encoder;
import com.gbasedbt.crypto.provider.AESCipher;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;

public class EncrypAES {
    private static char[] defaultKey = new char[]{'\u00c8', '\u008b', '\u0099', '\u009c', '\u00cb', '\u008d', '\u0098', '\u0091', '\u00cf', '\u0090', '\u0094', '\u0092', '\u00c8', '\u0096', '\u0093', '\u00de'};
    private AESCipher encryptCipher = null;
    private AESCipher decryptCipher = null;
    private static EncrypAES instance = new EncrypAES(EncrypAES.getDefaultKey(defaultKey));

    public static EncrypAES getInstance() {
        return instance;
    }

    private EncrypAES(String string) {
        if (string == null) {
            string = EncrypAES.getDefaultKey(defaultKey);
        }
        byte[] byArray = null;
        try {
            byArray = string.getBytes("GBK");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        byte[] byArray2 = new byte[16];
        for (int i = 0; i < byArray.length && i < byArray2.length; ++i) {
            byArray2[i] = byArray[i];
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "AES");
        try {
            this.encryptCipher = new AESCipher();
            SecureRandom secureRandom = new SecureRandom();
            this.encryptCipher.engineInit(1, secretKeySpec, secureRandom);
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
    }

    private static String getDefaultKey(char[] cArray) {
        cArray = defaultKey;
        int n = 16;
        char[] cArray2 = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray2[i] = (char)(cArray[i] ^ 0xFF);
        }
        String string = String.valueOf(cArray2);
        return string;
    }

    public byte[] Encrytor(byte[] byArray) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        return this.encryptCipher.engineDoFinal(byArray, 0, byArray.length);
    }

    public byte[] Decryptor(byte[] byArray) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        return this.decryptCipher.engineDoFinal(byArray, 0, byArray.length);
    }

    public static void printHexString(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i] & 0xFF);
            if (string.length() == 1) {
                string = '0' + string;
            }
            System.out.print(string.toUpperCase());
        }
    }

    public static String getBASE64(byte[] byArray) {
        String string = null;
        if (byArray != null) {
            string = new BASE64Encoder().encode(byArray);
        }
        return string;
    }

    public static byte[] getFromBASE64(String string) {
        byte[] byArray = null;
        if (string != null) {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            try {
                byArray = bASE64Decoder.decodeBuffer(string);
                return byArray;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return byArray;
    }

    public static void main(String[] stringArray) throws Exception {
        EncrypAES encrypAES = EncrypAES.getInstance();
        String string = "gbasedbt";
        byte[] byArray = string.getBytes("GBK");
        byte[] byArray2 = encrypAES.Encrytor(byArray);
        String string2 = EncrypAES.getBASE64(byArray2);
        System.out.println("base64enconde:" + string2);
        System.out.println("msg:\n" + byArray);
        System.out.println("\n encode msg:" + new String(byArray2));
        System.out.println("\n encodeMSG:\n");
        EncrypAES.printHexString(byArray2);
        System.out.println("\n deconMSG:\n");
    }
}

