/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.crypto.provider;

import com.gbasedbt.crypto.provider.FeedbackCipher;
import com.gbasedbt.crypto.provider.SymmetricCipher;
import java.security.InvalidKeyException;

final class PCBC
extends FeedbackCipher {
    private final byte[] k = new byte[this.blockSize];
    private byte[] kSave = null;

    PCBC(SymmetricCipher symmetricCipher) {
        super(symmetricCipher);
    }

    @Override
    String getFeedback() {
        return "PCBC";
    }

    @Override
    void init(boolean bl, String string, byte[] byArray, byte[] byArray2) throws InvalidKeyException {
        if (byArray == null || byArray2 == null || byArray2.length != this.blockSize) {
            throw new InvalidKeyException("Internal error");
        }
        this.iv = byArray2;
        this.reset();
        this.embeddedCipher.init(bl, string, byArray);
    }

    @Override
    void reset() {
        System.arraycopy(this.iv, 0, this.k, 0, this.blockSize);
    }

    @Override
    void save() {
        if (this.kSave == null) {
            this.kSave = new byte[this.blockSize];
        }
        System.arraycopy(this.k, 0, this.kSave, 0, this.blockSize);
    }

    @Override
    void restore() {
        System.arraycopy(this.kSave, 0, this.k, 0, this.blockSize);
    }

    @Override
    void encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n + n2;
        while (n < n4) {
            int n5;
            for (n5 = 0; n5 < this.blockSize; ++n5) {
                int n6 = n5;
                this.k[n6] = (byte)(this.k[n6] ^ byArray[n5 + n]);
            }
            this.embeddedCipher.encryptBlock(this.k, 0, byArray2, n3);
            for (n5 = 0; n5 < this.blockSize; ++n5) {
                this.k[n5] = (byte)(byArray[n5 + n] ^ byArray2[n5 + n3]);
            }
            n += this.blockSize;
            n3 += this.blockSize;
        }
    }

    @Override
    void decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n + n2;
        while (n < n4) {
            int n5;
            this.embeddedCipher.decryptBlock(byArray, n, byArray2, n3);
            for (n5 = 0; n5 < this.blockSize; ++n5) {
                int n6 = n5 + n3;
                byArray2[n6] = (byte)(byArray2[n6] ^ this.k[n5]);
            }
            for (n5 = 0; n5 < this.blockSize; ++n5) {
                this.k[n5] = (byte)(byArray2[n5 + n3] ^ byArray[n5 + n]);
            }
            n3 += this.blockSize;
            n += this.blockSize;
        }
    }
}

